/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunScriptOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceIdentifierType;
import com.nuix.automate.workflow.core.execution.options.relativityscript.RelativityScriptDetails;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RelativityRunScriptOperationImplementation
extends RelativityRunScriptOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunScriptOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                RelativityRestVersion relativityRestVersion = RelativityRestVersion.valueOf((String)this.executionContext.evalParameters("{wfn_relativity_rest_version}", this));
                if (relativityRestVersion == RelativityRestVersion.RSAPI) {
                    throw new IOException(this.iu.getString("RelativityScriptOperation.Exception.CannotRunScriptRSAPI"));
                }
                this.initializeRelativityClient(relativityRestVersion);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceId = -1L;
                if (this.scriptLocation == WorkspaceIdentifierType.CURRENT_WORKSPACE) {
                    relativityWorkspaceId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                }
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.scriptIdentifier = this.executionContext.evalParameters(this.scriptIdentifier, this);
                this.exportPath = this.executionContext.evalParameters(this.exportPath, this);
                if (!FileUtils.isPathAbsolute((String)this.exportPath)) {
                    String errorMsg = this.iu.getFormattedString("RelativityRunScriptOperationImplementation.Exception.ExportPathRelative", (Object)this.exportPath);
                    LOGGER.error("Export file can't be a relative path");
                    this.exception = new Exception(errorMsg);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                long relativityScriptArtifactId = -1L;
                this.stageName = this.iu.getString("RelativityScriptOperation.Stage.GettingScript");
                this.addExecutionLog(this.iu.getString("RelativityScriptOperation.Log.GettingScript"));
                List<EligibleObject> eligibleScripts = this.relativityRestClient.queryEligibleScripts(relativityWorkspaceId);
                EligibleObject eligibleScript = RelativityUtils.getInstance().filterEligibleObject(this.scriptIdentifier, this.scriptIdentifierType, eligibleScripts, RelativityFieldType.SCRIPT);
                if (eligibleScript == null) {
                    throw new IOException(this.iu.getFormattedString("RelativityScriptOperation.Exception.MissingScript", new Object[]{this.scriptIdentifier}));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityScriptOperation.Log.ScriptName", (Object)eligibleScript.getName()));
                relativityScriptArtifactId = eligibleScript.getArtifactId();
                this.percentageComplete = 0.33;
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                for (Object[] row : this.parameterValues) {
                    String inputId = String.valueOf(row[0]);
                    String inputValue = String.valueOf(row[1]);
                    inputId = this.executionContext.evalParameters(inputId, this);
                    inputValue = this.executionContext.evalParameters(inputValue, this);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityScriptOperation.Log.ScriptParameter", new Object[]{inputId, inputValue}));
                    parameterMap.put(inputId, inputValue);
                }
                this.stageName = this.iu.getString("RelativityScriptOperation.Stage.QueueingScript");
                this.addExecutionLog(this.iu.getString("RelativityScriptOperation.Log.QueueingScript"));
                String jobRunId = this.relativityRestClient.queueScript(relativityWorkspaceId, relativityScriptArtifactId, parameterMap);
                this.addExecutionLog(this.iu.getFormattedString("RelativityScriptOperation.Log.RunningScript", (Object)jobRunId));
                this.stageName = this.iu.getString("RelativityScriptOperation.Stage.ReadingOutput");
                this.addExecutionLog(this.iu.getString("RelativityScriptOperation.Log.ReadingOutput"));
                String status = "";
                while (!RelativityUtils.getInstance().hasScriptCompleted(status)) {
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    Thread.sleep(1000L);
                    status = this.relativityRestClient.getScriptStatus(relativityWorkspaceId, jobRunId);
                }
                RelativityScriptDetails relativityScriptDetails = this.relativityRestClient.readScriptOutput(relativityWorkspaceId, jobRunId);
                this.percentageComplete = 0.75;
                if (relativityScriptDetails.getErrorMessage() != null && !relativityScriptDetails.getErrorMessage().equals("")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_relativity_script_error}", relativityScriptDetails.getErrorMessage())));
                    throw new IOException(relativityScriptDetails.getErrorMessage());
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityScriptOperation.Log.ScriptFinished", (Object)relativityScriptDetails.getStatus()));
                this.percentageComplete = 0.9;
                if (this.writeOutput) {
                    this.stageName = this.iu.getString("RelativityScriptOperation.Stage.ExportingOutput");
                    List rows = FileUtils.loadVariableColumnCsv((String)relativityScriptDetails.getResponseOutput());
                    this.writeReport(rows);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public void writeReport(List<Object[]> lines) throws Exception {
        int templateWorksheetIndex;
        Object buffer;
        Object[] headersObject = lines.remove(0);
        String[] headers = new String[headersObject.length];
        for (int i = 0; i < headersObject.length; ++i) {
            headers[i] = headersObject[i].toString();
        }
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customOutputTemplatePath.length() > 0 && !(templateFile = new File(this.customOutputTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_METADATA.toString();
        HashSet<String> worksheetNames = new HashSet<String>();
        for (Object o : workbook.getWorksheets()) {
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            Worksheet worksheet = (Worksheet)o;
            worksheetNames.add(worksheet.getName());
        }
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("RelativityRunScriptOperation.Report.Name"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("RelativityRunScriptOperation.Report.Name"));
        }
        int rowId = 3;
        int columnId = 0;
        int processedItems = 0;
        int columnsCount = headers.length;
        if (columnsCount > 3) {
            for (int i = 0; i < columnsCount - 3; ++i) {
                worksheet.getCells().insertColumn(sc + 2);
                worksheet.getCells().copyColumn(worksheet.getCells(), sc + 1, sc + 2);
            }
        } else if (columnsCount == 2) {
            worksheet.getCells().deleteColumn(sc + 1);
        } else if (columnsCount == 1) {
            worksheet.getCells().deleteColumn(sc + 1);
            worksheet.getCells().deleteColumn(sc + 1);
        }
        for (String header : headers) {
            worksheet.getCells().get(sr, sc + columnId).setValue((Object)header);
            ++columnId;
        }
        for (Object[] result : lines) {
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            worksheet.getCells().insertRow(sr + ++rowId);
            Boolean isLastRow = processedItems == lines.size() - 1;
            Boolean isFirstRow = processedItems == 0;
            if (isFirstRow.booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (!isLastRow.booleanValue()) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            int column = 0;
            for (Object object : result) {
                try {
                    int numberValue = Integer.parseInt(object.toString());
                    worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)numberValue);
                }
                catch (Exception e) {
                    String value = object.toString();
                    worksheet.getCells().get(sr + rowId, sc + column++).setValue((Object)value);
                }
            }
            ++processedItems;
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.outputLocation = this.executionContext.evalParameters(this.outputLocation, this);
        File reportFile = new File(this.outputLocation);
        this.outputLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".csv")) {
            for (String worksheetName : worksheetNames) {
                try {
                    workbook.getWorksheets().removeAt(worksheetName);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot remove sheet " + worksheetName);
                }
            }
        } else {
            for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
                try {
                    workbook.getWorksheets().removeAt(templateWorksheetName.toString());
                }
                catch (Exception e) {
                    LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
                }
            }
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else if (reportFile.getAbsolutePath().toLowerCase().endsWith(".csv")) {
            workbook.save(reportFile.getAbsolutePath(), 1);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.addExecutionLog(this.iu.getFormattedString("RelativityRunScriptOperation.Info.OutputLocation", (Object)reportFile.getAbsolutePath()));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (percentageComplete > 0.0) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

