/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunSearchTermReportOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SearchTermReportProgress;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class RelativityRunSearchTermReportOperationImplementation
extends RelativityRunSearchTermReportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunSearchTermReportOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                Long searchTermReportArtifactId = 0L;
                this.stageName = this.iu.getString("RelativityRunSearchTermReportOperation.Stage.GettingSearchTermReport");
                this.percentageComplete = 0.05;
                this.searchTermReportIdentifier = this.executionContext.evalParameters(this.searchTermReportIdentifier, this);
                this.searchTermResultsLocation = this.executionContext.evalParameters(this.searchTermResultsLocation, this);
                this.customReportTemplatePath = this.executionContext.evalParameters(this.customReportTemplatePath, this);
                List<EligibleObject> eligibleSearchTermReports = this.relativityRestClient.querySearchTermReports(this.searchTermReportIdentifier, this.searchTermReportIdentifierType, relativityWorkspaceArtifactId);
                EligibleObject eligibleSearchTermReport = RelativityUtils.getInstance().filterAllEligibleObject(this.searchTermReportIdentifier, this.searchTermReportIdentifierType, eligibleSearchTermReports, RelativityFieldType.SEARCH_TERM_REPORT);
                if (eligibleSearchTermReport == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Exception.SearchTermReportMissing", (Object)String.valueOf(this.searchTermReportIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.SearchTermReportIdentifier", (Object)String.valueOf(this.searchTermReportIdentifier)));
                searchTermReportArtifactId = eligibleSearchTermReport.getArtifactId();
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.ReportRunType", (Object)this.searchTermReportRunType.toString()));
                this.percentageComplete = 0.1;
                this.relativityRestClient.runSearchTermsReport(relativityWorkspaceArtifactId, searchTermReportArtifactId, this.searchTermReportRunType);
                Thread.sleep(1000L);
                SearchTermReportProgress progress = null;
                int iter = 0;
                while (true) {
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    progress = this.relativityRestClient.getSearchTermReportProgress(relativityWorkspaceArtifactId, searchTermReportArtifactId);
                    if (progress != null) {
                        if (iter == 0) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.SearchTermsCount", (Object)progress.getTermsTotal()));
                            this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.RunTypeCount", (Object)progress.getTermsPending()));
                        }
                        if (progress.getJobType().equals("No Active Job")) {
                            if (progress.getTermsError() <= 0) break;
                            this.addWarning(this.iu.getNumeralString("RelativityRunSearchTermReportOperation.Warning.TermsCompletedWithErrors", (long)progress.getTermsError().intValue()));
                            break;
                        }
                        this.percentageComplete = 0.1 + (double)progress.getTermsCompleted().intValue() / (double)progress.getTermsTotal().intValue() * 0.85;
                        this.stageName = this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Stage.RunningSearchTermsCount", new Object[]{progress.getTermsCompleted(), progress.getTermsTotal()});
                        ++iter;
                    }
                    Thread.sleep(5000L);
                }
                String searchTermReportResultCsv = this.relativityRestClient.getSearchTermResults(relativityWorkspaceArtifactId, searchTermReportArtifactId);
                searchTermReportResultCsv = searchTermReportResultCsv.substring(1);
                if (this.saveResultsToFile) {
                    FileUtils.writeToFile((String)searchTermReportResultCsv, (Path)Paths.get(this.searchTermResultsLocation, new String[0]));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.ResultsLocation", (Object)this.searchTermResultsLocation));
                }
                List csvFile = FileUtils.loadVariableColumnCsv((String)searchTermReportResultCsv);
                String[] headers = new String[((Object[])csvFile.get(0)).length];
                for (int i = 0; i < ((Object[])csvFile.get(0)).length; ++i) {
                    headers[i] = ((Object[])csvFile.get(0))[i].toString();
                }
                JsonObject json = new JsonObject();
                JsonArray array = new JsonArray();
                json.add("results", (JsonElement)array);
                for (int i = 0; i < csvFile.size(); ++i) {
                    if (i == 0) continue;
                    Object[] row = (Object[])csvFile.get(i);
                    JsonObject rowObject = new JsonObject();
                    for (int j = 0; j < row.length; ++j) {
                        rowObject.add(headers[j], (JsonElement)new JsonPrimitive(row[j].toString()));
                    }
                    array.add((JsonElement)rowObject);
                }
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_search_term_results_json}", SerializationUtils.toJson((Object)json))));
                if (this.writeReport) {
                    this.stageName = this.iu.getString("RelativityRunSearchTermReportOperation.Stage.GeneratingSearchTermReport");
                    this.writeReport(csvFile);
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void writeReport(List<Object[]> lines) throws Exception {
        int templateWorksheetIndex;
        Object buffer;
        lines.remove(0);
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_RELATIVITY_RUN_SEARCH_TERMS.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("RelativityRunSearchTermReportOperation.Report.SearchTermReport"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("RelativityRunSearchTermReportOperation.Report.SearchTermReport"));
        }
        int rowId = 3;
        int columnId = 0;
        int processedItems = 0;
        String[] headers = new String[]{this.iu.getString("RelativityRunSearchTermReportOperation.Report.LastRunHeader"), this.iu.getString("RelativityRunSearchTermReportOperation.Report.SearchTermHeader"), this.iu.getString("RelativityRunSearchTermReportOperation.Report.HitsHeaders"), this.iu.getString("RelativityRunSearchTermReportOperation.Report.GroupHitsHeader"), this.iu.getString("RelativityRunSearchTermReportOperation.Report.UniqueHitsHeader")};
        for (String header : headers) {
            worksheet.getCells().get(sr, sc + columnId).setValue((Object)header);
            ++columnId;
        }
        for (Object[] result : lines) {
            boolean isFirstRow;
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            worksheet.getCells().insertRow(sr + ++rowId);
            int isLastRow = processedItems == lines.size() - 1 ? 1 : 0;
            boolean bl = isFirstRow = processedItems == 0;
            if (isFirstRow) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (isLastRow == 0) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            String searchTerm = result[0].toString();
            String lastRunTime = result[4].toString();
            worksheet.getCells().get(sr + rowId, sc).setValue((Object)lastRunTime);
            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)searchTerm);
            String documentHits = result[1].toString();
            try {
                worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)Integer.parseInt(documentHits));
            }
            catch (Exception e) {
                worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)0);
            }
            String documentHitsGroups = result[2].toString();
            try {
                worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)Integer.parseInt(documentHitsGroups));
            }
            catch (Exception e) {
                worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)0);
            }
            String uniqueHits = result[3].toString();
            try {
                worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)Integer.parseInt(uniqueHits));
            }
            catch (Exception e) {
                worksheet.getCells().get(sr + rowId, sc + 4).setValue((Object)0);
            }
            ++processedItems;
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File reportFile = new File(this.reportLocation);
        this.reportLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.addExecutionLog(this.iu.getFormattedString("RelativityRunSearchTermReportOperation.Info.ReportLocation", (Object)reportFile.getAbsolutePath()));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

