/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccRemoteCommand;
import com.nuix.automate.utils.ecc.internal.EccRemoteCommandType;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Presence;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RemoveEccAgentsOperation;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class RemoveEccAgentsOperationImplementation
extends RemoveEccAgentsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RemoveEccAgentsOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient AtomicLong agentsRemoved;
    private transient AtomicLong agentsFailedToRemove;
    private transient ConcurrentHashMap<String, Computer> computers;
    private transient ExecutorService threadPool;
    private transient ConcurrentHashMap<String, Future<Boolean>> removeFutures;
    private transient Map<String, Integer> retryCountMap;
    private transient EccUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("RemoveEccAgentsOperation.Stage.PreparingForRemoving");
                this.utils = EccUtils.getInstance();
                this.initializeEccClient();
                HashMap<String, String> removedComputersMap = new HashMap<String, String>();
                HashSet<String> removedComputerFailedList = new HashSet<String>();
                this.username = this.executionContext.evalParameters(this.username, this);
                this.password = this.executionContext.evalProtectedParameter(this.password);
                this.uninstallCommand = this.executionContext.evalParameters(this.uninstallCommand, this);
                if (this.useComputerNamesFile) {
                    this.computerNamesFileLocation = this.executionContext.evalParameters(this.computerNamesFileLocation, this);
                    Path path = Paths.get(this.computerNamesFileLocation, new String[0]);
                    this.addExecutionLog(this.iu.getFormattedString("RemoveEccAgentsOperation.Log.ComputerNamesFileLocation", (Object)path.toFile().getAbsolutePath()));
                    this.computerNames = new ArrayList();
                    List names = FileUtils.loadVariableColumnDetectFormatFile((File)path.toFile());
                    for (Object[] name : names) {
                        this.computerNames.add(name[0].toString());
                    }
                }
                if (this.useDeployedComputers) {
                    this.computerNames = new ArrayList();
                    try {
                        String collectionJson = this.executionContext.evalParameters("{ecc_deployed_computer_names}", this);
                        if (!collectionJson.equals("{ecc_deployed_computer_names}")) {
                            Collection parameterCollection = (Collection)SerializationUtils.fromJson((String)collectionJson);
                            this.computerNames.addAll(parameterCollection);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not parse {ecc_deployed_computer_names} parameter,", (Throwable)e);
                    }
                }
                ArrayList<String> evaluatedComputerNames = new ArrayList<String>();
                for (String computerName : this.computerNames) {
                    List<String> evaluatedComputerName = this.executionContext.evalOneOrManyStringParameter(computerName, this);
                    evaluatedComputerNames.addAll(evaluatedComputerName);
                }
                int totalComputers = evaluatedComputerNames.size();
                if (this.useDeployedComputers && totalComputers == 0) {
                    this.addWarning(this.iu.getString("RemoveEccAgentsOperation.Warning.PreviousAgentsNotDeployed"));
                    return;
                }
                this.percentageComplete = 0.1;
                this.stageName = this.iu.getString("RemoveEccAgentsOperation.Stage.RemovingAgents");
                this.addExecutionLog(this.iu.getFormattedString("RemoveEccAgentsOperation.Log.ComputerRemoveCount", (Object)totalComputers));
                this.agentsFailedToRemove = new AtomicLong(0L);
                this.agentsRemoved = new AtomicLong(0L);
                this.computers = new ConcurrentHashMap();
                this.threadPool = Executors.newFixedThreadPool(10);
                this.removeFutures = new ConcurrentHashMap();
                this.retryCountMap = new HashMap<String, Integer>();
                this.updateCachedComputersMap(evaluatedComputerNames, this.computers);
                HashSet<Presence> presences = new HashSet<Presence>();
                presences.add(Presence.NEAR_LINE);
                presences.add(Presence.OFFLINE);
                HashMap<String, EccRemoteCommand> remoteCommands = new HashMap<String, EccRemoteCommand>();
                for (String string : evaluatedComputerNames) {
                    EccRemoteCommand remoteCommand = new EccRemoteCommand(string, this.timeout, this.computers, EccRemoteCommandType.REMOVING_AGENT, this.uninstallCommand, presences, this.username, this.password);
                    remoteCommands.put(string, remoteCommand);
                    this.removeFutures.put(string, this.threadPool.submit(remoteCommand));
                    if (!this.retryRunningCommandIfFails) continue;
                    this.retryCountMap.put(string, 0);
                }
                while (this.removeFutures.size() != 0) {
                    boolean computersMapUpdated = this.updateCachedComputersMap(evaluatedComputerNames, this.computers);
                    if (computersMapUpdated) {
                        for (EccRemoteCommand remoteCommand : remoteCommands.values()) {
                            remoteCommand.setComputersMap(this.computers);
                        }
                    }
                    for (Map.Entry<String, Future<Boolean>> entry : this.removeFutures.entrySet()) {
                        String name = entry.getKey();
                        Future<Boolean> status = entry.getValue();
                        if (status.isDone()) {
                            Boolean result = status.get();
                            this.removeFutures.remove(name);
                            if (!result.booleanValue()) {
                                if (this.retryRunningCommandIfFails) {
                                    int currentRetryCount = this.retryCountMap.get(name) + 1;
                                    if (currentRetryCount < this.retryCount) {
                                        LOGGER.warn("Failed to run command on computer " + name + ", retry (" + currentRetryCount + " of " + this.retryCount + ")");
                                        remoteCommands.remove(name);
                                        this.retryCountMap.put(name, currentRetryCount);
                                        EccRemoteCommand remoteCommand = new EccRemoteCommand(name, this.timeout, this.computers, EccRemoteCommandType.REMOVING_AGENT, this.uninstallCommand, presences, this.username, this.password);
                                        remoteCommands.put(name, remoteCommand);
                                        this.removeFutures.put(name, this.threadPool.submit(remoteCommand));
                                        continue;
                                    }
                                    this.agentsFailedToRemove.incrementAndGet();
                                    this.addWarning(this.iu.getFormattedString("RemoveEccAgentsOperation.Warning.FailedToRemoveOn", new Object[]{name, ((EccRemoteCommand)remoteCommands.get(name)).getOutputLog().getAbsolutePath()}));
                                    removedComputerFailedList.add(name);
                                    continue;
                                }
                                this.agentsFailedToRemove.incrementAndGet();
                                this.addWarning(this.iu.getFormattedString("RemoveEccAgentsOperation.Warning.FailedToRemoveOn", new Object[]{name, ((EccRemoteCommand)remoteCommands.get(name)).getOutputLog().getAbsolutePath()}));
                                removedComputerFailedList.add(name);
                                continue;
                            }
                            this.agentsRemoved.incrementAndGet();
                            remoteCommands.remove(name);
                            removedComputersMap.put(name, this.resolveComputerId(name, this.computers));
                        }
                        int totalAgentsFinished = this.agentsRemoved.intValue() + this.agentsFailedToRemove.intValue();
                        this.percentageComplete = 0.1 + (double)totalAgentsFinished / (double)totalComputers * 0.9;
                    }
                    if (this.stopRequested) {
                        for (EccRemoteCommand remoteCommand : remoteCommands.values()) {
                            remoteCommand.setStopRequested(true);
                        }
                        this.threadPool.shutdownNow();
                        throw new WorkflowExecutionStopRequested();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.error("Sleep interrupted");
                        break;
                    }
                }
                if (this.agentsRemoved.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("RemoveEccAgentsOperation.Log.AgentsRemoved", this.agentsRemoved.get()));
                }
                if (this.agentsFailedToRemove.get() > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("RemoveEccAgentsOperation.Warning.FailedAgents", this.agentsFailedToRemove.get()));
                }
                this.concatenateToCollectionJson("{ecc_removed_computer_names}", removedComputersMap.keySet());
                this.concatenateToCollectionJson("{ecc_failed_computer_names}", removedComputerFailedList);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

