/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.IncludeItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoveEntitiesModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.RemoveEntitiesOperation;
import com.nuix.automate.workflow.core.execution.options.general.ToInclude;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nuix.Item;
import nuix.ItemModifierCallback;

public class RemoveEntitiesOperationImplementation
extends RemoveEntitiesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(IncludeItemsOperation.class);
    private transient int stageTotalItems;
    private transient int itemsProcessed;
    private transient String stageName;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.stageTotalItems = 0;
                this.itemsProcessed = 0;
                this.addExecutionLog(this.iu.getFormattedString("IncludeItemsOperation.Log.ScopeQuery", (Object)this.scope));
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("IncludeItemsOperation.Log.ScopeCount", scopeCount));
                this.addExecutionLog(this.iu.getFormattedString("RemoveEntitiesOperation.Log.Entities", (Object)this.entitiesToRemove.toString()));
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                HashSet<String> types = new HashSet<String>();
                if (this.entitiesToRemove.equals((Object)ToInclude.SPECIFIC)) {
                    for (Object[] entityType : this.entityType) {
                        types.add(this.executionContext.evalParameters(entityType[0].toString(), this));
                    }
                }
                this.stageName = this.iu.getString("RemoveEntitiesOperation.Stage.RemovingEntities");
                this.stageTotalItems = items.size();
                AtomicReference ex = new AtomicReference();
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    for (Item item : items) {
                        ++this.itemsProcessed;
                        try {
                            if (this.entitiesToRemove.equals((Object)ToInclude.ALL)) {
                                Map itemEntities = item.getAllEntitiesByType();
                                Set<String> itemEntityTypes = itemEntities.keySet();
                                item.modify((ItemModifierCallback)new RemoveEntitiesModifierCallback(itemEntityTypes));
                                continue;
                            }
                            item.modify((ItemModifierCallback)new RemoveEntitiesModifierCallback(types));
                        }
                        catch (IOException e) {
                            ex.set(e);
                            LOGGER.error("Cannot remove entity", (Throwable)e);
                            break;
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Exception)ex.get();
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageTotalItems > 0) {
            percentageComplete = (double)this.itemsProcessed / (double)this.stageTotalItems;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.itemsProcessed > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("FilterEmailsOperation.Progress.ItemsProcessed", (long)this.itemsProcessed);
        }
        return result;
    }
}

