/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RemoveFromItemSetOperation;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicationMethod;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import nuix.ItemSet;

public class RemoveFromItemSetOperationImplementation
extends RemoveFromItemSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RemoveFromItemSetOperation.class);
    private transient String stage;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                DeduplicationMethod deduplicationMethod;
                boolean requiredVersionSatisfied;
                this.executionContext.closeAllTabs();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.itemSetName = this.executionContext.evalParameters(this.itemSetName, this);
                this.addExecutionLog(this.iu.getFormattedString("RemoveFromItemSetOperation.Log.ItemSetName", (Object)this.itemSetName));
                ItemSet itemSet = this.executionContext.nuixCase.findItemSetByName(this.itemSetName);
                if (itemSet == null) {
                    Exception e = new Exception(this.iu.getFormattedString("RemoveFromItemSetOperation.Exception.ItemSetDoesNotExist", (Object)this.itemSetName));
                    LOGGER.error("Item set " + this.itemSetName + " does not exist", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.addExecutionLog(this.iu.getFormattedString("RemoveFromItemSetOperation.Log.ScopeQuery", (Object)this.scope));
                Set itemsToRemove = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("RemoveFromItemSetOperation.Log.ScopeCount", (long)itemsToRemove.size()));
                HashMap<String, Boolean> removeOptions = new HashMap<String, Boolean>();
                removeOptions.put("removeDuplicates", false);
                boolean bl = requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(new Version("7.0.0")) >= 0;
                if (requiredVersionSatisfied && ((deduplicationMethod = DeduplicationMethod.getDeduplicationMethod(itemSet.getSettings().get("deduplication").toString())) == DeduplicationMethod.MESSAGE_ID || deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5 || deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5_CUSTODIAN || deduplicationMethod == DeduplicationMethod.MAPI_SEARCH_KEY)) {
                    Exception e = new Exception(this.iu.getFormattedString("RemoveFromItemSetOperation.Exception.CannotRemoveItemsFromItemSetWithCustomDeduplicationMethod", (Object)deduplicationMethod));
                    LOGGER.error("Cannot remove items from Item Set with custom deduplication method: " + String.valueOf((Object)deduplicationMethod), (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                if (this.removeDuplicates) {
                    this.stage = this.iu.getString("RemoveFromItemSetOperation.Stage.RemovingItems");
                    this.addExecutionLog(this.iu.getString("RemoveFromItemSetOperation.Log.RemovingItemSetDuplicates"));
                    removeOptions.put("removeDuplicates", true);
                }
                long countItemSetItemsInitial = this.executionContext.nuixCase.count("item-set:\"" + this.itemSetName + "\"");
                itemSet.removeItems((Collection)itemsToRemove, removeOptions);
                long countItemSetItemsFinal = this.executionContext.nuixCase.count("item-set:\"" + this.itemSetName + "\"");
                long itemsRemoved = countItemSetItemsInitial - countItemSetItemsFinal;
                if (itemsRemoved > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("RemoveFromItemSetOperation.Log.RemovedItems", countItemSetItemsInitial - countItemSetItemsFinal));
                } else {
                    this.addWarning(this.iu.getString("RemoveFromItemSetOperation.Warning.ItemSetDidNotContainAnyItemsInScope"));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.stage != null) {
            result = (String)result + this.stage;
        }
        return result;
    }
}

