/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RemoveItemsFromFolderOperation;
import com.nuix.automate.workflow.core.utils.nuix.CaseFolders;
import com.nuix.automate.workflow.core.utils.nuix.Folder;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.HashSet;
import nuix.BulkAnnotater;

public class RemoveItemsFromFolderOperationImplementation
extends RemoveItemsFromFolderOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RemoveItemsFromFolderOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient boolean stopTriggered = false;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.addExecutionLog(this.iu.getFormattedString("Operation.Log.ScopeQuery", (Object)this.scope));
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ScopeCount", scopeCount));
                this.stageCount = this.securedFolderQueries.size() * 2;
                this.stageId = 0;
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                CaseFolders caseFolders = NuixUtils.getCaseFolders(this.executionContext);
                for (Object[] securedFolderQuery : this.securedFolderQueries) {
                    HashSet items;
                    if (this.stopTriggered) {
                        this.executionState = ExecutionState.STOPPED;
                        return;
                    }
                    String folderName = securedFolderQuery[0].toString().trim();
                    try {
                        folderName = this.executionContext.evalParameters(folderName, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    String folderQuery = securedFolderQuery[1].toString().trim();
                    try {
                        folderQuery = this.executionContext.evalParameters(folderQuery, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    try {
                        folderQuery = this.executionContext.evalParameters(folderQuery, this);
                    }
                    catch (ParameterException e) {
                        LOGGER.error("Error finding unpacking exclusion query", (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    if (folderName.length() == 0) {
                        this.addExecutionLog(this.iu.getString("ItemsSecurityOperation.Log.SkippedBlankFolderName"));
                        continue;
                    }
                    if (folderQuery.length() == 0) {
                        this.addWarning(this.iu.getFormattedString("ItemsSecurityOperation.Log.SkippedBlankQuery", (Object)folderName));
                        continue;
                    }
                    Folder caseFolder = caseFolders.getFolderWithName(folderName);
                    if (caseFolder == null) {
                        this.addWarning(this.iu.getFormattedString("ItemsSecurityOperation.Log.SkippedNonExistentFolder", (Object)folderName));
                        continue;
                    }
                    this.stageName = this.iu.getString("Operation.Stage.SearchingForItems");
                    String query = NuixUtils.addAndQuery(this.scope, folderQuery);
                    try {
                        items = new HashSet(this.executionContext.nuixCase.searchUnsorted(query));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error running query " + query, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                    this.stageName = this.iu.getString("Operation.Stage.RemovingItems");
                    try {
                        bulkAnnotater.removeCustomMetadata("folder_security_" + caseFolder.getId(), items, null);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("ItemsSecurityOperation.Log.RemoveItems", (long)items.size(), (Object)folderName));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error assigning items to folder " + folderName, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.stopTriggered = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

