/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ReplaceItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.WorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.configuration.KeystoreFile;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import com.nuix.filetype.MimeType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import nuix.BatchLoadDetails;
import nuix.Item;
import nuix.LicenceException;
import nuix.LoadProcessingJob;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessedItem;
import nuix.ProcessingJob;
import nuix.Processor;
import nuix.SimpleCase;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.ReadableInstant;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class ReplaceItemsOperationImplementation
extends ReplaceItemsOperation
implements WorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ReplaceItemsOperation.class);
    private transient String stageName;
    private transient AtomicLong processedItems;
    private transient long stageTotalItems;
    private transient int stageId;
    private transient int stageCount;
    private transient LoadProcessingJob loadProcessingJob;
    private transient int workersPendingCount;
    private transient boolean isPaused;
    private transient Set<Item> itemsToTag;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);

    Item getItemEncryptedSource(Item item) {
        return (Item)item.getParent();
    }

    @Override
    public void startTriggered() throws Exception {
        this.sourceFolder = this.executionContext.evalParameters(this.sourceFolder, this);
        this.executionContext.closeAllTabs();
        ReplaceItemsOperationImplementation currentOperation = this;
        this.addExecutionLog(this.iu.getFormattedString("ReplaceItemsOperation.Log.ReplaceItemsBy", new Object[]{this.matchItemsByMD5 ? "MD5" : "", this.matchItemsByGUID ? ";GUID" : ""}));
        if (this.keepOriginal) {
            this.addExecutionLog(this.iu.getString("ReplaceItemsOperation.Log.KeepOriginalItems"));
        } else {
            this.addExecutionLog(this.iu.getString("ReplaceItemsOperation.Log.ReplaceOriginalItems"));
        }
        try {
            this.executionContext.workflowLocalWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{local_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerCountFromParameter", new Object[]{"{local_worker_count}", this.executionContext.workflowLocalWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowBrokerWorkersCount = Integer.parseInt(this.executionContext.evalParameters("{broker_worker_count}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingBrokerWorkerCountFromParameter", new Object[]{"{broker_worker_count}", this.executionContext.workflowBrokerWorkersCount}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.executionContext.workflowLocalWorkersMemoryMb = Integer.parseInt(this.executionContext.evalParameters("{local_worker_memory}", this));
            this.executionContext.workflowParallelSettings = true;
            this.addExecutionLog(this.iu.getFormattedString("General.Log.SettingLocalWorkerMemoryFromParameter", new Object[]{"{local_worker_memory}", this.executionContext.workflowLocalWorkersMemoryMb}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executionContext.jobBrokerIp = null;
        this.executionContext.workflowLocalWorkersTempFolder = this.executionContext.evalParameters(this.executionContext.workflowLocalWorkersTempFolder, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                void var8_24;
                String workerSideScript;
                String workerSideScriptParameterName;
                Processor processor;
                this.stageCount = 2;
                this.stageId = 0;
                if (this.tagMatchedItems) {
                    ++this.stageCount;
                    this.itemsToTag = new HashSet<Item>();
                }
                this.stageName = this.iu.getString("ReplaceItemsOperation.Stage.ScanningFilesForImport");
                this.processedItems = new AtomicLong(0L);
                this.addExecutionLog(this.iu.getFormattedString("ReplaceItemsOperation.Log.SourceFolder", (Object)this.sourceFolder));
                try {
                    SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
                    processor = simpleCase.createProcessor();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot create processor", (Throwable)e);
                    this.exception = new Exception(this.iu.getString("ReplaceItemsOperation.Exception.CannotAccessNuixProcessor"), e);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                Map<Object, Object> processingSettings = new HashMap();
                ConfigurationParser configurationParser = new ConfigurationParser();
                if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", currentOperation).equalsIgnoreCase("true")) {
                    processingSettings = configurationParser.getProperties(this.executionContext.nuixVersion);
                    processor.setParallelProcessingSettings(configurationParser.getParallelProcessingSettings());
                }
                if (!(workerSideScriptParameterName = "{wfn_worker_side_script_file}").equals(workerSideScript = this.executionContext.evalParameters(workerSideScriptParameterName, currentOperation))) {
                    if (workerSideScript.length() > 0) {
                        this.addExecutionLog(this.iu.getFormattedString("ReplaceItemsOperation.Log.WorkerSideScriptFile", (Object)workerSideScript));
                        processor.getProcessingSettings().put("workerItemCallback", String.join((CharSequence)"\r\n", Files.readAllLines(Paths.get(workerSideScript, new String[0]))));
                    } else {
                        processor.getProcessingSettings().remove("workerItemCallback");
                    }
                }
                processingSettings.put("reportProcessingStatus", "physical_files");
                processingSettings.put("calculateAuditedSize", true);
                if (this.executionContext.evalParameters("{wfn_use_configuration_profile}", currentOperation).equalsIgnoreCase("true")) {
                    Map<String, Map<String, Object>> mimeTypeSettings;
                    block58: {
                        mimeTypeSettings = configurationParser.getMimeTypeSettings();
                        try {
                            void var8_16;
                            if (!processingSettings.keySet().contains("disabledMimeTypes")) break block58;
                            LOGGER.info("Setting disabled mime-types");
                            Object disabledMimeTypesSetting = processingSettings.get("disabledMimeTypes");
                            if (disabledMimeTypesSetting instanceof String[]) {
                                String[] stringArray = (String[])disabledMimeTypesSetting;
                            } else {
                                String[] stringArray = new String[]{(String)disabledMimeTypesSetting};
                            }
                            for (void disabledMimeType : var8_16) {
                                if (disabledMimeType.startsWith("kind:")) {
                                    String disabledKindId = disabledMimeType.replace("kind:", "");
                                    if (this.executionContext.nuixVersion.compareTo(new Version("7.2.0")) < 0) {
                                        this.addWarning(this.iu.getFormattedString("ReplaceItemsOperation.Warning.CannotDisableKind", (Object)disabledKindId));
                                        continue;
                                    }
                                    LOGGER.info("Parsing disabled kind ID " + disabledKindId);
                                    for (MimeType mimeType : NuixUtils.getAllMimeTypes()) {
                                        if (!mimeType.getKind().getId().equals(disabledKindId)) continue;
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("Handling child mime-type " + mimeType.toString());
                                        }
                                        mimeTypeSettings.remove(mimeType.toString());
                                        HashMap<String, Boolean> disabledSetting = new HashMap<String, Boolean>();
                                        disabledSetting.put("enabled", false);
                                        mimeTypeSettings.put(mimeType.toString(), disabledSetting);
                                    }
                                    continue;
                                }
                                LOGGER.info("Parsing disabled mime-type " + (String)disabledMimeType);
                                mimeTypeSettings.remove(disabledMimeType);
                                HashMap<String, Boolean> disabledSetting = new HashMap<String, Boolean>();
                                disabledSetting.put("enabled", false);
                                mimeTypeSettings.put((String)disabledMimeType, (Map<String, Object>)disabledSetting);
                            }
                        }
                        catch (Exception exception) {
                            this.addWarning(this.iu.getFormattedString("ReplaceItemsOperation.Warning.ErrorHandlingDisabledMimeTypes", (Object)exception.getLocalizedMessage()));
                            LOGGER.error("Error handling disabled mime-types", (Throwable)exception);
                        }
                    }
                    for (String mimeType : mimeTypeSettings.keySet()) {
                        try {
                            Object v;
                            Map currentProcessorSetting = processor.getMimeTypeProcessingSettings(mimeType);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Current mime-type " + mimeType + " properties");
                            }
                            if (currentProcessorSetting != null) {
                                for (Object key : currentProcessorSetting.keySet()) {
                                    v = currentProcessorSetting.get(key);
                                    if (!LOGGER.isDebugEnabled()) continue;
                                    LOGGER.debug(" " + String.valueOf(key) + " " + key.getClass().toString() + " = " + String.valueOf(v) + " " + v.getClass().toString());
                                }
                            }
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Setting mime-type " + mimeType + " properties  to " + ((Map)mimeTypeSettings.get(mimeType)).toString());
                            }
                            processor.setMimeTypeProcessingSettings(mimeType, (Map)mimeTypeSettings.get(mimeType));
                            currentProcessorSetting = processor.getMimeTypeProcessingSettings(mimeType);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Updated mime-type " + mimeType + " properties");
                            }
                            if (currentProcessorSetting != null) {
                                for (Object key : currentProcessorSetting.keySet()) {
                                    v = currentProcessorSetting.get(key);
                                    if (!LOGGER.isDebugEnabled()) continue;
                                    LOGGER.debug(" " + String.valueOf(key) + " " + key.getClass().toString() + " = " + String.valueOf(v) + " " + v.getClass().toString());
                                }
                            }
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug(" ");
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot set mime-type " + mimeType + " properties.", (Throwable)e);
                        }
                    }
                }
                LOGGER.info("Applying processing settings");
                for (String string : processingSettings.keySet()) {
                    Object settingValue = processingSettings.get(string);
                    String settingType = settingValue != null ? settingValue.getClass().toString() : "n/a";
                    LOGGER.info("# Setting: " + string + "\tValue: " + String.valueOf(settingValue) + "\tType: " + settingType);
                }
                String processingProfileParameterName = "{wfn_processing_profile_name}";
                String string = this.executionContext.evalParameters(processingProfileParameterName, currentOperation);
                try {
                    String string2 = this.executionContext.evalParametersIfSet("{processing_profile_name}", this);
                    this.addExecutionLog(this.iu.getFormattedString("AddEvidence.Log.SettingProcessingProfile", new Object[]{"{processing_profile_name}", string2}));
                }
                catch (ParameterException settingValue) {
                    // empty catch block
                }
                if (!processingProfileParameterName.equals(var8_24)) {
                    try {
                        processor.setProcessingProfile((String)var8_24);
                        this.addExecutionLog(this.iu.getFormattedString("ReplaceItemsOperation.Log.ProcessingProfile", (Object)var8_24));
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot set profile", (Throwable)e);
                        throw new IllegalStateException(this.iu.getFormattedString("AddEvidenceOperation.Error.CannotUseProfile", new Object[]{var8_24, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    }
                    processor.getProcessingSettings().remove("additionalDigests");
                    processor.getProcessingSettings().put("imageClassificationImageWidth", 299);
                    processor.getProcessingSettings().put("imageClassificationImageHeight", 299);
                    processor.getProcessingSettings().put("imageClassificationLabels", "");
                }
                NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)processor, true);
                long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOGGER.info("Memory used before start: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                processor.whenItemProcessed(this::itemProcessed);
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (this.executionContext.keystoreList != null) {
                    for (KeystoreFile kf : this.executionContext.keystoreList) {
                        File keyFile = new File(kf.getKeystoreFilePath());
                        HashMap<String, Object> keyParameters = new HashMap<String, Object>();
                        if (kf.getKeystoreFilePassword() != null && !kf.getKeystoreFilePassword().equals("")) {
                            keyParameters.put("filePassword", kf.getKeystoreFilePassword());
                        }
                        if (kf.getKeyPasswords().size() > 0) {
                            keyParameters.put("keyPasswords", kf.getKeyPasswords());
                        }
                        if (kf.getTarget() != null && !kf.getTarget().equals("")) {
                            keyParameters.put("target", kf.getTarget());
                        }
                        processor.addKeyStore(keyFile, (Map)keyParameters);
                    }
                }
                if (this.executionContext.passwords != null && this.executionContext.passwords.size() > 0) {
                    Version requiredNuixVersion = new Version("7.2.0");
                    int requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion);
                    if (requiredVersionSatisfied < 0) {
                        this.addWarning(this.iu.getString("ReplaceItemsOperation.Warning.CannotUsePasswordSettings"));
                    } else {
                        ArrayList<char[]> passwordList = new ArrayList<char[]>();
                        for (String password : this.executionContext.passwords) {
                            passwordList.add(password.toCharArray());
                        }
                        LOGGER.info("Added " + passwordList.size() + " passwords");
                        processor.addPasswordList("AutomateWorkflowPasswords", passwordList);
                        HashMap<String, String> passwordDiscoverySettings = new HashMap<String, String>();
                        passwordDiscoverySettings.put("mode", "word-list");
                        passwordDiscoverySettings.put("word-list", "AutomateWorkflowPasswords");
                        passwordDiscoverySettings.put("wordList", "AutomateWorkflowPasswords");
                        processor.setPasswordDiscoverySettings(passwordDiscoverySettings);
                    }
                }
                List<File> matchedFiles = new ArrayList();
                HashMap fileKeysToFiles = new HashMap();
                if (this.keepOriginal) {
                    File sourceFolderFile = new File(this.sourceFolder);
                    if (!sourceFolderFile.exists()) {
                        throw new IOException(this.iu.getFormattedString("ReplaceItemsOperation.Error.CannotAccessFolder", (Object)this.sourceFolder));
                    }
                    this.stageName = this.iu.getString("ReplaceItemsOperation.Stage.ScanningFiles");
                    try (Stream<Path> stream = Files.walk(Paths.get(sourceFolderFile.getPath(), new String[0]), new FileVisitOption[0]);){
                        stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                            String fileKey = FilenameUtils.getBaseName((String)f.toFile().getName()).toLowerCase();
                            fileKeysToFiles.put(fileKey, f.toFile());
                        });
                    }
                    this.stageName = this.iu.getString("ReplaceItemsOperation.Stage.MatchingFilesToItems");
                    Set caseItems = this.executionContext.nuixCase.searchUnsorted("");
                    this.stageTotalItems = caseItems.size();
                    ConcurrentHashMap matches = new ConcurrentHashMap();
                    FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)caseItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                    Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                        while (iterator.hasNext()) {
                            String md5;
                            File matchingFile;
                            Item item = (Item)iterator.next();
                            boolean match = false;
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            boolean itemMatched = false;
                            if (this.matchItemsByGUID) {
                                try {
                                    String guid = item.getGuid();
                                    matchingFile = (File)fileKeysToFiles.get(guid);
                                    if (matchingFile != null) {
                                        matches.put(item, matchingFile);
                                        itemMatched = true;
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot process item " + item.getGuid(), (Throwable)e);
                                }
                            }
                            if (!itemMatched && this.matchItemsByMD5 && (md5 = item.getDigests().getMd5()) != null && (matchingFile = (File)fileKeysToFiles.get(md5)) != null) {
                                matches.put(item, matchingFile);
                                itemMatched = true;
                            }
                            this.processedItems.incrementAndGet();
                        }
                    }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    for (Item item : matches.keySet()) {
                        File matchedFile = (File)matches.get(item);
                        processor.addChildItems(item, Collections.singletonList(matchedFile));
                        matchedFiles.add(matchedFile);
                    }
                } else {
                    matchedFiles = processor.replaceItemsFromSourceData(this.sourceFolder);
                }
                this.stageTotalItems = matchedFiles.size();
                this.addExecutionLog(this.iu.getNumeralString("ReplaceItemsOperation.Log.MatchedCount", this.stageTotalItems));
                if (this.stageTotalItems == 0L) {
                    this.addWarning(this.iu.getString("ReplaceItemsOperation.Warning.NoItemsMatched"));
                    this.trackFinished();
                } else {
                    ++this.stageId;
                    this.stageName = this.iu.getString("ReplaceItemsOperation.Stage.LoadingReplacementItems");
                    this.processedItems = new AtomicLong(0L);
                    this.loadProcessingJob = processor.processAsync();
                    NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.loadProcessingJob, this.addedWorkerCount);
                    NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.loadProcessingJob);
                    if (this.executionState == ExecutionState.STOPPING) {
                        this.trackStopped();
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void resumeTriggered() {
        try {
            this.loadProcessingJob.resume();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    public void pauseTriggered() {
        try {
            this.loadProcessingJob.pause();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.loadProcessingJob != null) {
                        LOGGER.info("Sending stop command");
                        this.loadProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job", (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }

    @Override
    public synchronized void updateState() {
        if (this.loadProcessingJob != null) {
            if (!this.isPaused && this.loadProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.loadProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.PAUSING) {
                if (this.loadProcessingJob.hasFinished()) {
                    try {
                        long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        LOGGER.info("Memory used after finish: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                        try {
                            this.executionContext.nuixCase.getBatchLoads();
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot get batchloads", (Throwable)e);
                            NuixUtils.reopenCase(this.executionContext);
                        }
                        BatchLoadDetails lastBatchLoad = null;
                        for (Object batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
                            if (lastBatchLoad != null && !batchLoadDetails.getLoaded().isAfter((ReadableInstant)lastBatchLoad.getLoaded())) continue;
                            lastBatchLoad = batchLoadDetails;
                        }
                        if (this.tagMatchedItems) {
                            long itemsToTagCount;
                            this.itemsToTag = new HashSet<Item>(this.executionContext.nuixCase.searchUnsorted(this.executionContext.evalParameters("batch-load-guid:{last_batch_load_guid}", this)));
                            HashSet<Item> parentItemsToTag = new HashSet<Item>();
                            if (this.keepOriginal) {
                                for (Item item : this.itemsToTag) {
                                    Item parent = (Item)item.getParent();
                                    if (parent == null || this.itemsToTag.contains(parent)) continue;
                                    parentItemsToTag.add(parent);
                                }
                                this.itemsToTag.addAll(parentItemsToTag);
                            }
                            if ((itemsToTagCount = (long)this.itemsToTag.size()) == 0L) {
                                this.addExecutionLog(this.iu.getString("ReplaceItemsOperation.Log.NoItemsToTag"));
                                this.trackFinished();
                            }
                            this.stageName = this.iu.getString("ReplaceItemsOperation.Stage.TaggingMatchedItems");
                            String evaluatedTagName = this.executionContext.evalParameters(this.tagName, this);
                            LOGGER.info("Tagging " + this.itemsToTag.size() + " items with " + evaluatedTagName);
                            this.executionContext.nuixCase.createTag(evaluatedTagName);
                            this.executionContext.nuixUtilities.getBulkAnnotater().addTag(evaluatedTagName, this.itemsToTag);
                            this.addExecutionLog(this.iu.getNumeralString("ReplaceItemsOperation.Log.TagCount", itemsToTagCount));
                            this.addExecutionLog(this.iu.getFormattedString("ReplaceItemsOperation.Log.TagName", (Object)evaluatedTagName));
                        }
                        System.gc();
                        memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        LOGGER.info("Memory used after clean-up: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                        if (this.startTriggerThread != null && this.startTriggerThread.isAlive()) {
                            LOGGER.info("Interrupting startTriggerThread");
                            this.startTriggerThread.interrupt();
                        }
                        if (this.startTriggerThread != null) {
                            try {
                                LOGGER.info("Waiting 60s for startTriggerThread to complete");
                                this.startTriggerThread.join(60000L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.warn("Could not wait for startTriggerThread to finish", (Throwable)e);
                            }
                        }
                        this.trackFinished();
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
            } else if (this.executionState == ExecutionState.STOPPING && this.loadProcessingJob.hasFinished()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageTotalItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.processedItems != null && this.processedItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("ReplaceItemsOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }

    public void itemProcessed(ProcessedItem processedItem) {
        this.processedItems.incrementAndGet();
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processed", (Object)String.join((CharSequence)"/", processedItem.getPath())));
        this.trackItemProcessedIrregular(processedItem.getMimeType(), processedItem.isCorrupted(), processedItem.isEncrypted(), processedItem.isDeleted());
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.loadProcessingJob != null) {
            return this.loadProcessingJob.getJobGuid();
        }
        return null;
    }
}

