/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.operations.ProcessorMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.operations.RescanEvidenceRepositoriesOperation;
import com.nuix.automate.workflow.core.execution.options.rescanevidencerepositories.ContinueMode;
import com.nuix.automate.workflow.core.nuix.DummyParallelProcessingConfigurable;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BatchLoadDetails;
import nuix.EvidenceContainer;
import nuix.LicenceException;
import nuix.ProcessedItem;
import nuix.ProcessingJob;
import nuix.SimpleCase;
import org.joda.time.ReadableInstant;

public class RescanEvidenceRepositoriesOperationImplementation
extends ProcessorMimeTypeVolumesUtilizationOperation
implements RemoteWorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RescanEvidenceRepositoriesOperation.class);
    @ExcludeFromPrintableOptions
    public ContinueMode noNewEvidenceContinueMode = ContinueMode.STOP_WITH_ERROR;
    private transient AtomicLong processedItems;
    private transient boolean isPaused;
    private transient String utilizationScopeQuery;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient Integer workerMemory = null;

    @Override
    public void startTriggered() throws Exception {
        this.processedItems = new AtomicLong(0L);
        this.timeZoneId = this.executionContext.evalParameters(this.timeZoneId, this);
        this.setWorkerSettings();
        NuixWorkerUtils.verifyWorkerSettings(this.executionContext, this);
        this.executionContext.closeAllTabs();
        RescanEvidenceRepositoriesOperationImplementation currentOperation = this;
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeProcessingProfileBuilder();
                try {
                    SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
                    this.processor = simpleCase.createProcessor();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot create processor", (Throwable)e);
                    this.exception = new Exception(this.iu.getString("RescanEvidenceRepositoriesOperation.Exception.CannotAccessNuixProcessor"), e);
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.setConfigurationProfileSettings();
                HashMap<String, Object> overWritingParallelProcessingSettings = new HashMap<String, Object>();
                if (this.executionContext.jobBrokerIp != null) {
                    this.addExecutionLog(this.iu.getFormattedString("General.Log.JobRemoteBroker", (Object)(this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort)));
                    overWritingParallelProcessingSettings.put("workerBrokerAddress", this.executionContext.jobBrokerIp + ":" + this.executionContext.jobBrokerPort);
                }
                this.setProcessingProfileSettings(overWritingParallelProcessingSettings);
                this.setWorkerParallelSettings(overWritingParallelProcessingSettings);
                this.applyProcessingProfile();
                long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                LOGGER.info("Memory used before start: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                this.processor.whenItemProcessed(this::itemProcessed);
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                boolean discoveredNewEvidence = false;
                List evidenceContainers = this.processor.rescanEvidenceRepositories(true);
                for (EvidenceContainer evidenceContainer : evidenceContainers) {
                    this.addExecutionLog(this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Log.DiscoveredNewEvidence", (Object)evidenceContainer.getName()));
                    discoveredNewEvidence = true;
                }
                if (!discoveredNewEvidence) {
                    this.addExecutionLog(this.iu.getString("RescanEvidenceRepositoriesOperation.Log.DidNotDiscoverNewEvidence"));
                }
                this.processor.getProcessingSettings().put("calculateAuditedSize", true);
                this.loadProcessingJob = this.processor.processAsync();
                String processingJobGuid = this.loadProcessingJob.getJobGuid().replace("-", "");
                LOGGER.info("Job Guid: " + processingJobGuid);
                NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.loadProcessingJob, this.addedWorkerCount);
                NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.loadProcessingJob);
                if (this.executionState == ExecutionState.STOPPING) {
                    this.trackStopped();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void resumeTriggered() {
        try {
            this.loadProcessingJob.resume();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    public void pauseTriggered() {
        try {
            this.loadProcessingJob.pause();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.loadProcessingJob != null) {
                        LOGGER.info("Sending stop command");
                        this.loadProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job", (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName());
        thread.start();
    }

    @Override
    public synchronized void updateState() {
        if (this.loadProcessingJob != null) {
            if (!this.isPaused && this.loadProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.loadProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.PAUSING) {
                if (this.loadProcessingJob.hasFinished()) {
                    boolean loadedNewEvidence;
                    long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    LOGGER.info("Memory used after finish: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                    BatchLoadDetails lastBatchLoad = null;
                    for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
                        if (lastBatchLoad != null && !batchLoadDetails.getLoaded().isAfter((ReadableInstant)lastBatchLoad.getLoaded())) continue;
                        lastBatchLoad = batchLoadDetails;
                    }
                    System.gc();
                    memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    LOGGER.info("Memory used after clean-up: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                    if (this.startTriggerThread != null && this.startTriggerThread.isAlive()) {
                        LOGGER.info("Interrupting startTriggerThread");
                        this.startTriggerThread.interrupt();
                    }
                    if (this.startTriggerThread != null) {
                        try {
                            LOGGER.info("Waiting 60s for startTriggerThread to complete");
                            this.startTriggerThread.join(60000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("Could not wait for startTriggerThread to finish", (Throwable)e);
                        }
                    }
                    long loadedItems = 0L;
                    for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
                        if (!batchLoadDetails.getBatchId().equals(this.loadProcessingJob.getJobGuid())) continue;
                        try {
                            loadedItems = batchLoadDetails.getItems().size();
                        }
                        catch (IOException e) {
                            LOGGER.error("Error handling loadedItems", (Throwable)e);
                            this.addWarning(this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Warning.UnexpectedErrorEncountered", (Object)e.getLocalizedMessage()));
                        }
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Log.ProcessingMode", (Object)this.loadProcessingJob.getProcessingMode()));
                    this.addExecutionLog(this.iu.getNumeralString("RescanEvidenceRepositoriesOperation.Log.TraversedCount", Math.max(this.processedItems.get(), this.loadProcessingJob.getItemsProcessed())));
                    this.addExecutionLog(this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Log.TraversedSize", (Object)FormattingUtils.sizeToDisplaySize((long)this.loadProcessingJob.getBytesProcessed())));
                    if (loadedItems > 0L) {
                        this.addExecutionLog(this.iu.getNumeralString("RescanEvidenceRepositoriesOperation.Log.LoadedCount", loadedItems));
                    }
                    this.utilizationScopeQuery = "batch-load-guid:" + this.loadProcessingJob.getJobGuid();
                    this.addExecutionLog(this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Log.BatchLoadGuid", (Object)this.loadProcessingJob.getJobGuid()));
                    boolean bl = loadedNewEvidence = this.loadProcessingJob.getItemsProcessed() > 0L;
                    if (!loadedNewEvidence) {
                        if (this.noNewEvidenceContinueMode == ContinueMode.STOP_WITH_ERROR) {
                            LOGGER.error("No new evidence was found in repository");
                            this.exception = new IllegalStateException(this.iu.getString("RescanEvidenceRepositoriesOperation.Exception.NoNewEvidence"));
                            this.executionState = ExecutionState.ERROR;
                            return;
                        }
                        if (this.noNewEvidenceContinueMode == ContinueMode.CONTINUE_WITH_WARNING) {
                            this.addWarning(this.iu.getString("RescanEvidenceRepositoriesOperation.Warning.NoNewEvidenceInRepository"));
                            this.trackFinished();
                        } else if (this.noNewEvidenceContinueMode == ContinueMode.FINISH) {
                            this.addExecutionLog(this.iu.getString("RescanEvidenceRepositoriesOperation.Log.NoNewEvidence"));
                            this.executionContext.workflowExecution.setNextWorkflowExecutionPosition(this.executionContext.workflowExecution.getWorkflow().getOperations().size() + 1);
                            this.trackFinished();
                        }
                    } else {
                        this.trackFinished();
                    }
                }
            } else if (this.executionState == ExecutionState.STOPPING && this.loadProcessingJob.hasFinished()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.loadProcessingJob != null && this.loadProcessingJob.getBytesProcessed() * this.loadProcessingJob.getJobSizeTotalBytes() > 0L) {
            double calculatedPercentageComplete = (double)this.loadProcessingJob.getBytesProcessed() / (double)this.loadProcessingJob.getJobSizeTotalBytes();
            double maxValidPercentageComplete = 0.9999;
            if (this.loadProcessingJob.hasFinished()) {
                maxValidPercentageComplete = 1.0;
            }
            return Math.min(calculatedPercentageComplete, maxValidPercentageComplete);
        }
        return -1.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        if (this.loadProcessingJob != null) {
            double percentageComplete = this.getNormalizedPercentageComplete();
            if (percentageComplete > 0.0) {
                result = (String)result + String.format("%.2f%%", percentageComplete * 100.0) + " / ";
            }
            try {
                result = (String)result + this.iu.getNumeralString("RescanEvidenceRepositoriesOperation.Progress.ItemsProcessed", Math.max(this.processedItems.get(), this.loadProcessingJob.getItemsProcessed()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.loadProcessingJob.getBytesProcessed() > 0L) {
                    result = (String)result + this.iu.getFormattedString("RescanEvidenceRepositoriesOperation.Progress.BytesProcessed", (Object)FormattingUtils.sizeToDisplaySize((long)this.loadProcessingJob.getBytesProcessed()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public void itemProcessed(ProcessedItem processedItem) {
        this.processedItems.incrementAndGet();
        if (this.loadProcessingJob != null) {
            try {
                this.trackVolumeProcessed(this.loadProcessingJob.getBytesProcessed());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processed", (Object)String.join((CharSequence)"/", processedItem.getPath())));
        this.trackItemProcessedIrregular(processedItem.getMimeType(), processedItem.isCorrupted(), processedItem.isEncrypted(), processedItem.isDeleted());
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RescanEvidenceRepositoriesOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.RESCAN_EVIDENCE_REPOSITORIES;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LOAD;
    }

    @Override
    public Activity getActivity() {
        return Activity.LOAD;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return this.utilizationScopeQuery;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.loadProcessingJob != null) {
            return this.loadProcessingJob.getJobGuid();
        }
        return null;
    }

    @Override
    protected ConsumptionSubType getConsumptionSubType() {
        return ConsumptionSubType.LOAD;
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        if (this.workerMemory != null) {
            return this.workerMemory;
        }
        try {
            DummyParallelProcessingConfigurable configurable = new DummyParallelProcessingConfigurable();
            NuixWorkerUtils.setWorkerSettings(this.executionContext, this, configurable, false);
            this.workerMemory = Integer.parseInt(String.valueOf(configurable.getParallelProcessingSettings().get("workerMemory")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }
}

