/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.api.userservice.AuthenticationServiceTypeIdSubmission;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="userIdsRadioButtonGroup", radioButton="useUserIdFile", values={@RadioButtonValue(value="true", component="userIdsFile"), @RadioButtonValue(value="false", component="userIdList")})
@OperationMetadata(alias=OperationAlias.RESOLVE_USERS_TO_COMPUTERS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTag(name="Category", value={"CONFIGURATION"})
@OperationParameters(value={@OperationParameter(label="userComputerMapping", parameter="{ecc_user_computer_mapping}"), @OperationParameter(label="resolvedComputers", parameter="{ecc_resolved_computer_names}")})
@OperationLicenseModule(module=ModuleType.ECC_COLLECTIONS)
public class ResolveUsersToComputersOperation
extends Operation {
    @FormField
    @ExcludeFromPrintableOptions
    public boolean useUserIdFile;
    @FormField(enableOn={@OnField(name="useUserIdFile")})
    public String userIdsFile;
    @FormField(enableOn={@OnField(name="useUserIdFile", value={"false"})})
    public List<String> userIdList;
    @FormField(componentType=FieldComponentType.OBJECT_TABLE)
    public List<AuthenticationServiceTypeIdSubmission> authenticationServices;

    public boolean getDisplayUserIdsFiles() {
        return this.useUserIdFile;
    }

    public boolean getDisplayUserIdList() {
        return !this.useUserIdFile;
    }

    public ResolveUsersToComputersOperation() {
        this.requiresCase = false;
        this.useUserIdFile = false;
        this.userIdsFile = "";
        this.userIdList = new ArrayList<String>();
        this.authenticationServices = new ArrayList<AuthenticationServiceTypeIdSubmission>();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ResolveUsersToComputersOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.useUserIdFile && (this.userIdsFile == null || this.userIdsFile.trim().equals(""))) {
            prerequisites.add(this.iu.getString("ResolveUsersToComputersOperation.Prerequisites.MissingFile"));
        }
        if (!(this.useUserIdFile || this.userIdList != null && this.userIdList.size() != 0)) {
            prerequisites.add(this.iu.getString("ResolveUsersToComputersOperation.Prerequisites.MissingUsers"));
        }
        if (this.authenticationServices == null || this.authenticationServices.size() == 0) {
            prerequisites.add(this.iu.getString("ResolveUsersToComputersOperation.Prerequisites.MissingAuthenticationServices"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

