/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.common.reflect.TypeToken;
import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.ecc.internal.UserComputerMapping;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.userservice.AuthenticationServiceTypeIdSubmission;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ResolveUsersToComputersOperation;
import com.nuix.automate.workflow.core.execution.script.OperationAutomateRestClient;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ResolveUsersToComputersOperationImplementation
extends ResolveUsersToComputersOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResolveUsersToComputersOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient OperationAutomateRestClient restClient;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("ResolveUsersToComputersOperation.Stage.PreparingUsers");
                this.initializeRestClient();
                HashSet<String> userIds = new HashSet<String>(this.userIdList);
                if (this.useUserIdFile) {
                    this.userIdsFile = this.executionContext.evalParameters(this.userIdsFile, this);
                    Path path = Paths.get(this.userIdsFile, new String[0]);
                    this.addExecutionLog(this.iu.getFormattedString("ResolveUsersToComputersOperation.Log.UserIdFile", (Object)path.toFile().getAbsolutePath()));
                    userIds = new HashSet();
                    List names = FileUtils.loadVariableColumnDetectFormatFile((File)path.toFile());
                    Iterator iterator = names.iterator();
                    while (iterator.hasNext()) {
                        Object[] name = (Object[])iterator.next();
                        userIds.add(name[0].toString());
                    }
                }
                HashSet<String> evaluatedUserIds = new HashSet<String>();
                for (String userId : userIds) {
                    List<String> evaluatedOneToManyUserIds = this.executionContext.evalOneOrManyStringParameter(userId, this);
                    evaluatedUserIds.addAll(evaluatedOneToManyUserIds);
                }
                if (evaluatedUserIds.size() == 0) {
                    this.addWarning(this.iu.getString("ResolveUsersToComputersOperation.Warning.NoUsers"));
                    this.trackFinished();
                    return;
                }
                this.stageName = this.iu.getString("ResolveUsersToComputersOperation.Stage.ResolvingUsers");
                this.addExecutionLog(this.iu.getFormattedString("ResolveUsersToComputersOperation.Log.UsersCount", (Object)String.valueOf(evaluatedUserIds.size())));
                ArrayList mappings = new ArrayList();
                Type mappingType = new TypeToken<List<UserComputerMapping>>(){}.getType();
                for (AuthenticationServiceTypeIdSubmission authService : this.authenticationServices) {
                    String authenticationServiceId = this.executionContext.evalParameters(authService.getServiceId(), this);
                    try {
                        Response response = this.restClient.post("/api/v1/scheduler/users/userService/" + authenticationServiceId + "/resolveComputers", evaluatedUserIds);
                        List authenticationServiceMappings = (List)SerializationUtils.fromJson((String)response.text, (Type)mappingType);
                        int authenticationServiceMappingCount = authenticationServiceMappings.size();
                        this.addExecutionLog(this.iu.getNumeralFormattedString("ResolveUsersToComputersOperation.Log.AuthenticationServiceMapped", (long)authenticationServiceMappingCount, new Object[]{this.iu.getString("ResolveUsersToComputersOperation.UserServiceType." + authService.getServiceType().name()), authenticationServiceId}));
                        mappings.addAll(authenticationServiceMappings);
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("ResolveUsersToComputersOperation.Warning.UnableToResolveUsers", new Object[]{this.iu.getString("ResolveUsersToComputersOperation.UserServiceType." + authService.getServiceType().name()), authenticationServiceId, e.getMessage()}));
                    }
                }
                if (mappings.size() == 0) {
                    this.addWarning(this.iu.getString("ResolveUsersToComputersOperation.Warning.NoComputersMapped"));
                    this.trackFinished();
                    return;
                }
                HashSet<String> resolvedComputerNames = new HashSet<String>();
                HashSet<String> uniqueUserIds = new HashSet<String>();
                HashSet<String> uniqueComputerIds = new HashSet<String>();
                for (UserComputerMapping mapping : mappings) {
                    resolvedComputerNames.add(mapping.getComputerName());
                    uniqueComputerIds.add(mapping.getComputerId());
                    uniqueUserIds.add(mapping.getUserId());
                }
                this.addExecutionLog(this.iu.getNumeralFormattedString("ResolveUsersToComputersOperation.Log.MappedUser", (long)uniqueUserIds.size(), (Object)this.iu.getNumeralString("ResolveUsersToComputersOperation.Log.MappedComputer", (long)uniqueComputerIds.size())));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_user_computer_mapping}", SerializationUtils.toJson(mappings))));
                this.addExecutionLog(this.iu.getFormattedString("ResolveUsersToComputersOperation.Log.SetComputersParameter", (Object)"{ecc_user_computer_mapping}"));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_resolved_computer_names}", SerializationUtils.toJson(resolvedComputerNames))));
                this.addExecutionLog(this.iu.getFormattedString("ResolveUsersToComputersOperation.Log.SettingComputerNamesParameter", (Object)"{ecc_resolved_computer_names}"));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    protected void initializeRestClient() throws Exception {
        String schedulerUrl = this.executionContext.evalParameters("{scheduler_url}", this);
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}");
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        try {
            whitelistedCertFingerprints.addAll((Collection)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{scheduler_cert_fingerprint}", this)));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        this.restClient = new OperationAutomateRestClient(schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

