/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RunExternalApplicationOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class RunExternalApplicationOperationImplementation
extends RunExternalApplicationOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RunExternalApplicationOperation.class);
    private transient boolean externalApplicationFatalErrorOccurred = false;
    private transient Process externalApplicationLoadProcess;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;
    private transient String maskedApplicationArguments;

    @Override
    protected void startTriggered() throws Exception {
        File externalApplication;
        this.applicationLocation = this.executionContext.evalParameters(this.applicationLocation, this);
        this.maskedApplicationArguments = this.applicationArguments;
        if (this.applicationArguments != null && !this.applicationArguments.equals("")) {
            this.maskedApplicationArguments = this.executionContext.evalParameters(this.applicationArguments, this, false, false);
            this.applicationArguments = this.executionContext.evalParameters(this.applicationArguments, this);
        }
        if (this.applicationWorkingDirectory != null && !this.applicationWorkingDirectory.equals("")) {
            this.applicationWorkingDirectory = this.executionContext.evalParameters(this.applicationWorkingDirectory, this);
        }
        if (!(externalApplication = new File(this.applicationLocation)).exists()) {
            throw new FileNotFoundException(this.iu.getFormattedString("RunExternalApplicationOperation.Exception.FileNotFound", (Object)externalApplication.getAbsolutePath()));
        }
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_exit_code}", "")));
        this.startTriggerThread = new Thread(() -> {
            try {
                if (externalApplication.isFile()) {
                    this.runExternalApplication();
                    this.waitForIo();
                    if (this.externalApplicationFatalErrorOccurred) {
                        this.addWarning(this.iu.getString("RunExternalApplicationOperation.Warning.FatalError"));
                    } else if (this.externalApplicationLoadProcess != null) {
                        int exitValue = this.externalApplicationLoadProcess.exitValue();
                        boolean warn = true;
                        if (this.validExitValues != null && !this.validExitValues.isEmpty()) {
                            ArrayList<String> exitValues = new ArrayList<String>();
                            for (String validExitValue : this.validExitValues) {
                                try {
                                    validExitValue = this.executionContext.evalParameters(validExitValue, this);
                                    int value = Integer.parseInt(validExitValue);
                                    if (exitValue == value) {
                                        warn = false;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                exitValues.add(validExitValue);
                            }
                            this.addExecutionLog(this.iu.getFormattedString("RunExternalApplicationOperation.Log.ExpectedExitValues", (Object)String.join((CharSequence)", ", exitValues)));
                        } else if (exitValue == 0) {
                            warn = false;
                        }
                        if (warn) {
                            this.addWarning(this.iu.getFormattedString("RunExternalApplicationOperation.Log.ExitValue", (Object)exitValue));
                        } else {
                            this.addExecutionLog(this.iu.getFormattedString("RunExternalApplicationOperation.Log.ExitValue", (Object)exitValue));
                        }
                        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_exit_code}", "" + exitValue)));
                    }
                }
                if (!externalApplication.isFile() || !externalApplication.canExecute()) {
                    this.exception = new Exception(this.iu.getFormattedString("RunExternalApplicationOperation.Exception.NotValidFile", (Object)externalApplication.getAbsolutePath()));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                this.exception = new Exception(message);
                this.executionState = ExecutionState.ERROR;
                this.stopLoad(true);
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    public void readOutputStream(BufferedReader standardInputReader) throws IOException {
        String line = "";
        while ((line = standardInputReader.readLine()) != null) {
            if (Thread.interrupted()) {
                return;
            }
            this.addExecutionLog(line);
        }
    }

    public void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            if (Thread.interrupted()) {
                return;
            }
            if (line.trim().length() > 0 && !line.startsWith(" ")) {
                this.addWarning(line);
            }
            LOGGER.warn(line);
        }
    }

    private void waitForIo() {
        try {
            this.externalApplicationLoadProcess.waitFor();
            this.readStandardOutputThread.join();
            this.readStandardErrorThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted");
        }
    }

    public void runExternalApplication() throws IOException, InterruptedException {
        this.addExecutionLog(this.iu.getFormattedString("RunExternalApplicationOperation.Log.StartingApplication", (Object)this.applicationLocation));
        String command = this.applicationLocation + " " + this.applicationArguments;
        String maskedCommand = this.applicationLocation + " " + this.maskedApplicationArguments;
        File activeWorkingDirectory = null;
        if (this.applicationWorkingDirectory != null && !this.applicationWorkingDirectory.equals("")) {
            File workingDirectory = new File(this.applicationWorkingDirectory);
            if (workingDirectory.exists() && workingDirectory.isDirectory()) {
                activeWorkingDirectory = workingDirectory;
            } else {
                this.addExecutionLog(this.iu.getFormattedString("RunExternalApplicationOperation.Log.NotValidWorkingDirectory", (Object)workingDirectory.getAbsolutePath()));
            }
        }
        LOGGER.info("Command: " + maskedCommand);
        this.externalApplicationLoadProcess = Runtime.getRuntime().exec(command, null, activeWorkingDirectory);
        LOGGER.info("Application Running");
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.externalApplicationLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.externalApplicationLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Run External Application Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Run External Application Standard Error Thread");
        this.readStandardErrorThread.start();
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad(false);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Thread interrupted, attempting to stop process", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    private void stopLoad(boolean silent) {
        if (this.externalApplicationLoadProcess != null) {
            LOGGER.info("Attempting to destroy external application load process");
            try {
                this.startTriggerThread.interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Cannot interrupt thread", (Throwable)e);
            }
            try {
                this.externalApplicationLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy external application process", (Throwable)e);
            }
            this.readStandardErrorThread.interrupt();
            this.readStandardOutputThread.interrupt();
            if (!silent && !this.externalApplicationLoadProcess.isAlive()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        String result = "";
        if (this.externalApplicationLoadProcess == null) {
            result = this.iu.getString("RunExternalApplicationOperation.Progress.StartingApplication");
        } else if (!(this.externalApplicationLoadProcess.isAlive() || this.readStandardErrorThread.isAlive() || this.readStandardOutputThread.isAlive())) {
            result = this.iu.getString("RunExternalApplicationOperation.Progress.Finished");
        }
        return result;
    }
}

