/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.ScriptFileOperation;
import com.nuix.automate.workflow.core.execution.options.script.ScriptType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useScriptFileRadioButtonGroup", radioButton="useScriptFile", values={@RadioButtonValue(value="false", component="scriptCode"), @RadioButtonValue(value="true", component="scriptFileName")})
@OperationMetadata(alias=OperationAlias.SCRIPT, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE", "NUIX_ENGINE"}), @OperationTag(name="Category", value={"SCRIPT", "EXTERNAL_COMMAND"})})
@OperationParameters(value={@OperationParameter(label="scriptOutput", parameter="{last_script_output}"), @OperationParameter(label="scriptError", parameter="{last_script_error}"), @OperationParameter(label="scriptReturnValue", parameter="{last_script_return_value}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ScriptOperation
extends Operation
implements ScriptFileOperation {
    @FormField
    public ScriptType scriptType;
    @FormField
    public boolean useScriptFile;
    @FormField(enableOn={@OnField(name="useScriptFile")})
    public String scriptFileName;
    @FormField(componentType=FieldComponentType.SCRIPT_PANE, scriptLanguageField="scriptType", enableOn={@OnField(name="useScriptFile", value={"false"})})
    public String scriptCode;
    private Boolean operationHasScriptFiles;

    public boolean getDisplayScriptFileName() {
        return this.useScriptFile;
    }

    public boolean getDisplayScriptCode() {
        return !this.useScriptFile;
    }

    public ScriptOperation() {
        this.requiresCase = false;
        this.scriptType = ScriptType.ECMA_SCRIPT;
        this.useScriptFile = false;
        this.scriptCode = "";
        this.scriptFileName = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ScriptOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.useScriptFile && this.scriptFileName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ScriptOperation.Prerequisites.ScriptMustBeSpecified"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    public void setLibraryFiles(Map<String, FileLibraryFile> libraryFiles) {
    }

    public void updateFileLibraryFile(FileLibraryFile fileLibraryFile) {
    }

    public Map<String, FileLibraryFile> getUpdatedLibraryFiles() {
        return null;
    }

    public void addUpdatedParameter(Parameter parameter) {
    }

    public List<Parameter> getUpdatedParameters() {
        return null;
    }

    @Override
    public Boolean getOperationHasScriptFiles() {
        return this.operationHasScriptFiles;
    }

    @Override
    public void setOperationHasScriptFiles() {
        this.operationHasScriptFiles = this.useScriptFile && this.scriptFileName != null && !this.scriptFileName.trim().isEmpty();
    }
}

