/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.JsonParseException;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.util.Set;

public class ScriptParameters {
    ExecutionContext executionContext;
    Operation currentOperation;

    public ScriptParameters(ExecutionContext executionContext, Operation currentOperation) {
        this.executionContext = executionContext;
        this.currentOperation = currentOperation;
    }

    public Set<String> getAllParameterNames() {
        Parameters parameters = this.executionContext.getAllParameters();
        return parameters.getNames();
    }

    public String put(String parameterName, String parameterValue) {
        String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
        StaticParameter parameter = new StaticParameter(normalizedParameterName, parameterValue);
        this.currentOperation.trackParameter((Parameter)parameter);
        this.executionContext.getExecutionCustomParameters().put((Parameter)parameter);
        this.executionContext.getParameterNames().add(normalizedParameterName);
        return normalizedParameterName;
    }

    public String getDisplayValue(String parameterName) throws ParameterException {
        return this.executionContext.evalParameterUserPrintableValue(parameterName);
    }

    public String get(String parameterName) throws ParameterException {
        return this.executionContext.evalParameters(parameterName, this.currentOperation);
    }

    public Object get(String parameterName, Object defaultValue) throws ParameterException {
        String value = this.executionContext.evalParameters(parameterName, this.currentOperation);
        if (parameterName.equals(value)) {
            return defaultValue;
        }
        return value;
    }

    public long getLong(String parameterName) throws ParameterException {
        return Long.parseLong(this.get(parameterName));
    }

    public long getLong(String parameterName, long defaultValue) throws ParameterException {
        try {
            return this.getLong(parameterName);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String putLong(String parameterName, long value) throws ParameterException {
        return this.put(parameterName, "" + value);
    }

    public boolean getBoolean(String parameterName) throws ParameterException {
        String parameterValue = this.get(parameterName).toLowerCase();
        if (!parameterValue.equals("true") && !parameterValue.equals("false")) {
            throw new IllegalArgumentException("Value is not of boolean type");
        }
        return Boolean.parseBoolean(parameterValue);
    }

    public boolean getBoolean(String parameterName, boolean defaultValue) throws ParameterException {
        try {
            return this.getBoolean(parameterName);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public String putBoolean(String parameterName, boolean value) throws ParameterException {
        return this.put(parameterName, "" + value);
    }

    public double getDouble(String parameterName) throws ParameterException {
        return Double.parseDouble(this.get(parameterName));
    }

    public double getDouble(String parameterName, double defaultValue) throws ParameterException {
        try {
            return this.getDouble(parameterName);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String putDouble(String parameterName, double value) throws ParameterException {
        return this.put(parameterName, "" + value);
    }

    public Object getJsonObject(String parameterName) throws ParameterException {
        String parameterValue = this.get(parameterName);
        if (parameterName.equals(parameterValue)) {
            throw new JsonParseException("Value is not a serialized JSON object");
        }
        return SerializationUtils.fromJson((String)parameterValue, Object.class);
    }

    public Object getJsonObject(String parameterName, Object defaultValue) throws ParameterException {
        try {
            return this.getJsonObject(parameterName);
        }
        catch (JsonParseException e) {
            return defaultValue;
        }
    }

    public String putJsonObject(String parameterName, Object value) throws ParameterException {
        return this.put(parameterName, SerializationUtils.toJson((Object)value, (boolean)true));
    }
}

