/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.SearchAndAssignCustodiansOperation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import nuix.BulkAnnotater;

public class SearchAndAssignCustodiansOperationImplementation
extends SearchAndAssignCustodiansOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SearchAndAssignCustodiansOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient boolean stopTriggered = false;
    private transient long countItemsToProcess;

    private void loadListFromFile(File f) throws IOException {
        this.searches = FileUtils.loadTwoColumnDetectFormat((File)f, (String)"searches", (String)"name", (String)"query");
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.stageCount = this.searches.size() * 2;
                this.stageId = 0;
                this.addExecutionLog(this.iu.getFormattedString("SearchAndAssignCustodiansOperation.Log.ScopeQuery", (Object)this.scope));
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.countItemsToProcess = scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("SearchAndAssignCustodiansOperation.Log.ScopeCount", this.countItemsToProcess));
                if (this.useSearchesFile) {
                    if (this.searchesFileName == null) {
                        this.searchesFileName = "";
                    }
                    this.searchesFileName = this.executionContext.evalParameters(this.searchesFileName, this);
                    this.loadListFromFile(new File(this.searchesFileName));
                    this.addExecutionLog(this.iu.getFormattedString("SearchAndAssignCustodiansOperation.Log.SearchesFile", (Object)this.searchesFileName));
                }
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                for (Object[] search : this.searches) {
                    Set items;
                    if (this.stopTriggered) {
                        this.executionState = ExecutionState.STOPPED;
                        return;
                    }
                    String custodianName = search[0].toString().trim();
                    try {
                        custodianName = this.executionContext.evalParameters(custodianName, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(this.iu.getFormattedString("SearchAndAssignCustodiansOperation.Warning.ExceptionMessage", (Object)e.getLocalizedMessage()));
                    }
                    String query = search[1].toString().trim();
                    try {
                        query = this.executionContext.evalParameters(query, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(this.iu.getFormattedString("SearchAndAssignCustodiansOperation.Warning.ExceptionMessage", (Object)e.getLocalizedMessage()));
                    }
                    if (custodianName.length() == 0) {
                        this.addExecutionLog(this.iu.getString("SearchAndAssignCustodiansOperation.Log.SkippedBlankCustodianName"));
                        continue;
                    }
                    if (query.length() == 0) {
                        this.addExecutionLog(this.iu.getFormattedString("SearchAndAssignCustodiansOperation.Log.SkippedBlankQuery", search[0]));
                        continue;
                    }
                    this.stageName = this.iu.getString("SearchAndAssignCustodiansOperation.Stage.SearchingForItems");
                    query = NuixUtils.addAndQuery(this.scope, query);
                    try {
                        LOGGER.info("Searching for: " + query);
                        items = this.executionContext.nuixCase.searchUnsorted(query);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error running query " + query, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                    this.stageName = this.iu.getString("SearchAndAssignCustodiansOperation.Stage.AssigningCustodians");
                    try {
                        bulkAnnotater.assignCustodian(custodianName, (Collection)items);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("SearchAndAssignCustodiansOperation.Log.AssignedCustodianItems", (long)items.size(), (Object)custodianName));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error assigning custodian " + custodianName, (Throwable)e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                    ++this.stageId;
                }
                this.addExecutionLog(this.iu.getNumeralString("SearchAndAssignCustodiansOperation.Log.HandledQueries", (long)this.searches.size()));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

