/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.searchandtag.RemoveTagsMethod;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="optionsGroup", children={"optionsRow"}), @FormFieldGroup(name="tagsGroup", children={"assignTags", "alwaysCreateTags", "tagPrefix", "removePreviousTags", "removePreviousMethod"}), @FormFieldGroup(name="reportingGroup", children={"writeReport", "reportLocation", "customReportTemplatePath"})})
@FormFieldRow(name="optionsRow", numberOfColumns=2, children={"identifyFamilies", "defaultNuixSearchLocations", "identifyDescendants", "searchContent", "identifyExclusiveHits", "searchProperties", "computeSize", "searchCommunications", "computeTotals", "searchNames", "breakdownByCustodian", "searchPathNames", "logResults", "searchEvidenceMetadata", "searchExcludedItems", "searchCustomMetadata"})
@FormFieldRadioButtonGroup(name="keywordsRadioButtonGroup", radioButton="useKeywordsFile", values={@RadioButtonValue(value="false", component="searches"), @RadioButtonValue(value="true", component="keywordsFileName")})
@OperationMetadata(alias=OperationAlias.SEARCH_AND_TAG, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"SEARCH", "TAG"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class SearchAndTagOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited";
    @FormField
    public boolean identifyFamilies = false;
    @FormField
    public Boolean defaultNuixSearchLocations = true;
    @FormField
    public boolean identifyDescendants = false;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchContent = true;
    @FormField
    public boolean identifyExclusiveHits = false;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchProperties = true;
    @FormField
    public boolean computeSize = false;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchCommunications = false;
    @FormField
    public boolean computeTotals = false;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchNames = true;
    @FormField
    public boolean breakdownByCustodian;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchPathNames = true;
    @FormField
    public boolean logResults;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchEvidenceMetadata = true;
    @FormField
    @ExcludeFromPrintableOptions
    public boolean searchExcludedItems = true;
    @FormField(enableOn={@OnField(name="defaultNuixSearchLocations", value={"false"})})
    @ExcludeFromPrintableOptions
    public boolean searchCustomMetadata = true;
    @FormField
    public boolean assignTags = true;
    @FormField(enableOn={@OnField(name="assignTags")})
    public boolean alwaysCreateTags = true;
    @FormField(required=false, enableOn={@OnField(name="assignTags")})
    public String tagPrefix = "Searches";
    @FormField(enableOn={@OnField(name="assignTags")})
    public boolean removePreviousTags = false;
    @FormField(enableOn={@OnField(name="removePreviousTags")})
    @ExcludeFromPrintableOptions
    public RemoveTagsMethod removePreviousMethod;
    @FormField
    public boolean writeReport;
    @FormField(enableOn={@OnField(name="writeReport")})
    public String reportLocation;
    @FormField(required=false, enableOn={@OnField(name="writeReport")})
    public String customReportTemplatePath;
    @FormField
    public boolean useKeywordsFile;
    @FormField(enableOn={@OnField(name="useKeywordsFile", value={"false"})}, columnFields={@FormFieldColumn(label="tag"), @FormFieldColumn(label="query")})
    public List<Object[]> searches = new ArrayList<Object[]>();
    @FormField(enableOn={@OnField(name="useKeywordsFile")})
    public String keywordsFileName;

    public boolean getDisplaySearchContent() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchProperties() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchCommunications() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchNames() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchPathNames() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchEvidenceMetadata() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearchCustomMetadata() {
        return this.defaultNuixSearchLocations;
    }

    public boolean getDisplaySearches() {
        return !this.useKeywordsFile;
    }

    public boolean getDisplayKeywordsFileName() {
        return this.useKeywordsFile;
    }

    public SearchAndTagOperation() {
        this.searches.add(new String[]{"KW 01", "Plan*"});
        this.searches.add(new String[]{"KW 02", "Non-Conform*"});
        this.useKeywordsFile = false;
        this.keywordsFileName = null;
        this.removePreviousMethod = RemoveTagsMethod.RENAME;
        this.writeReport = false;
        this.reportLocation = "{case_folder}/Reports/{case_name} - Search Report {date_time}.xlsx";
        this.customReportTemplatePath = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("SearchAndTagOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.SEARCH_AND_TAG;
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.defaultNuixSearchLocations == null) {
            this.defaultNuixSearchLocations = this.searchContent && this.searchProperties && this.searchNames && this.searchPathNames && this.searchEvidenceMetadata && this.searchCustomMetadata ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        boolean searchAnyOption;
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.useKeywordsFile && this.keywordsFileName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("SearchAndTagOperation.Prerequisites.KeywordsFileMustBeSpecified"));
        }
        boolean bl = searchAnyOption = this.defaultNuixSearchLocations != false || this.searchContent || this.searchProperties || this.searchNames || this.searchPathNames || this.searchEvidenceMetadata || this.searchCustomMetadata;
        if (!searchAnyOption) {
            prerequisites.add(this.iu.getString("SearchAndTagOperation.Prerequisites.NoSearchFieldSelected"));
        }
        return prerequisites;
    }

    public void loadListFromFile(File f) throws IOException {
        this.searches = FileUtils.loadTwoColumnDetectFormat((File)f, (String)"searches", (String)"tag", (String)"query");
    }
}

