/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GraphService;
import com.nuix.automate.utils.models.api.thirdparty.SemanticService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.SemanticConfigureOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.semantic.SemanticClient;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.Map;
import java.util.Set;

public class SemanticConfigureOperationImplementation
extends SemanticConfigureOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SemanticConfigureOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), GraphService.class.getSimpleName(), ParameterType.SEMANTIC_SERVICE);
                this.stageName = "";
                if (this.useSemanticService) {
                    this.semanticServiceId = this.executionContext.evalParameters(this.semanticServiceId, this);
                    this.textEmbeddingsModel = this.executionContext.evalParameters(this.textEmbeddingsModel, this);
                    this.imageEmbeddingsModel = this.executionContext.evalParameters(this.imageEmbeddingsModel, this);
                    this.transcriptionModel = this.executionContext.evalParameters(this.transcriptionModel, this);
                    if (this.thirdPartyServices == null || this.thirdPartyServices.get(this.semanticServiceId) == null) {
                        throw new IllegalStateException(this.iu.getFormattedString("SemanticSearchConfigureOperation.Exception.MissingService", (Object)this.semanticServiceId));
                    }
                    SemanticService semanticService = (SemanticService)this.thirdPartyServices.get(this.semanticServiceId);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_service_url}", semanticService.getUrl())));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_service_name}", semanticService.getName())));
                    SemanticClient semanticClient = new SemanticClient(semanticService.getUrl());
                    this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.SemanticService", (Object)semanticService.getName()));
                    semanticClient.test();
                } else {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.EmbeddedService"));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_service_url}", "")));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_service_name}", "Embedded")));
                }
                Set modules = this.executionContext.licenceInfo.getAllModules();
                if (!modules.contains(ModuleType.SEMANTIC_TEXT_SEARCH)) {
                    this.textEmbeddingsModel = "";
                }
                if (!modules.contains(ModuleType.SEMANTIC_IMAGE_SEARCH)) {
                    this.imageEmbeddingsModel = "";
                }
                if (!modules.contains(ModuleType.SEMANTIC_FACE_VECTORIZATION)) {
                    this.detectFaces = false;
                }
                if (!modules.contains(ModuleType.SEMANTIC_TRANSCRIPTION)) {
                    this.transcriptionModel = "";
                }
                if (!this.textEmbeddingsModel.trim().isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.TextEmbeddingsModel", (Object)this.textEmbeddingsModel));
                } else {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.TextEmbeddingsDisabled"));
                }
                if (!this.imageEmbeddingsModel.trim().isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.ImageEmbeddingsModel", (Object)this.imageEmbeddingsModel));
                } else {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.ImageEmbeddingsDisabled"));
                }
                if (this.detectFaces) {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.DetectFacesEnabled"));
                } else {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.DetectFacesDisabled"));
                }
                if (!this.transcriptionModel.trim().isEmpty()) {
                    this.addExecutionLog(this.iu.getFormattedString("SemanticSearchConfigureOperation.Log.TranscriptionModel", (Object)this.transcriptionModel));
                } else {
                    this.addExecutionLog(this.iu.getString("SemanticSearchConfigureOperation.Log.TranscriptionDisabled"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_text_model}", this.textEmbeddingsModel.trim())));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_image_model}", this.imageEmbeddingsModel.trim())));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_detect_faces}", Boolean.toString(this.detectFaces))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_semantic_transcription_model}", this.transcriptionModel.trim())));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

