/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.SemanticFindSimilarItemsOperation;
import com.nuix.automate.workflow.core.execution.operations.TagItemsOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class SemanticFindSimilarItemsOperationImplementation
extends SemanticFindSimilarItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TagItemsOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.tagName = this.executionContext.evalParameters(this.tagName, this);
        this.executionContext.closeAllTabs();
        this.countItemsProcessed = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                long itemsWithSemanticImageIndex;
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                long itemsWithSemanticTextIndex = this.executionContext.nuixCase.count("text-semantic:* ");
                if (itemsWithSemanticTextIndex + (itemsWithSemanticImageIndex = this.executionContext.nuixCase.count("image-semantic:*")) == 0L) {
                    this.addWarning(this.iu.getFormattedString("SemanticFindSimilarItemsOperation.Warning.NoItemsWithIndex", new Object[0]));
                } else {
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.TextSemanticIndexCount", itemsWithSemanticTextIndex));
                    this.addExecutionLog(this.iu.getNumeralString("Operation.Log.ImageSemanticIndexCount", itemsWithSemanticImageIndex));
                }
                this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.ScopeQuery", (Object)this.scope));
                this.stageName = this.iu.getString("TagItemsOperation.Stage.MatchingItems");
                this.stageId = 0;
                this.stageCount = 3;
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                Set matchedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.ScopeCount", (long)scopeItems.size()));
                this.countItemsToProcess = scopeItems.size();
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)scopeItems, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    while (iterator.hasNext()) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        Item item = (Item)iterator.next();
                        List semanticallySimilarItems = item.semanticallySimilarItems((float)this.similarityThreshold);
                        matchedItems.addAll(semanticallySimilarItems);
                        this.countItemsProcessed.incrementAndGet();
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                ++this.stageId;
                this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.MatchCount", (long)matchedItems.size()));
                this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
                this.countItemsProcessed.set(0L);
                this.countItemsToProcess = 0L;
                long countItemsToTagged = matchedItems.size();
                try {
                    this.stageName = this.iu.getString("TagItemsOperation.Stage.TaggingItems");
                    if (this.createEmptyTags || countItemsToTagged > 0L) {
                        LOGGER.info("Tagging " + countItemsToTagged + " items with " + this.tagName);
                        this.executionContext.nuixCase.createTag(this.tagName);
                        this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tagName, matchedItems);
                    }
                    this.addExecutionLog(this.iu.getNumeralString("TagItemsOperation.Log.TagCount", countItemsToTagged));
                    this.addExecutionLog(this.iu.getFormattedString("TagItemsOperation.Log.TagName", (Object)this.tagName));
                }
                catch (Exception e) {
                    this.addWarning(this.iu.getFormattedString("TagItemsOperation.Warning.ErrorApplyingTag", new Object[]{this.tagName, e.getLocalizedMessage()}));
                    LOGGER.error("Error applying tag " + this.tagName, (Throwable)e);
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double stagePercent = 0.0;
        if (this.countItemsToProcess > 0L) {
            stagePercent = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = ((double)this.stageId + stagePercent) / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
            if (this.countItemsToProcess > 0L) {
                result = (String)result + " / ";
                result = (String)result + this.iu.getNumeralString("TagItemsOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
            }
        }
        return result;
    }
}

