/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.InvalidCustomDigestSizeException;
import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.workflow.core.execution.operations.ScanCaseStatisticsOperationImplementation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BatchLoadDetails;
import nuix.Case;
import nuix.CaseStatistics;
import nuix.HistoryEvent;
import nuix.Item;
import nuix.ItemType;
import nuix.Utilities;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.GrowingChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class SessionStats {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SessionStats.class);
    private String id;
    private String user;
    private String previousEventUser;
    private String serverName = "Unknown";
    private List<Operation> operations;
    private Session session;
    private int operationId;
    private Case nuixCase;
    private Utilities nuixUtilities;
    private String nuixVersion;
    private ScanCaseStatisticsOperationImplementation scanCaseStatisticsOperation;
    private Set<String> batchTypeEvents;
    private boolean sessionStarted = false;
    private boolean sessionEnded = false;
    private boolean sessionEndedUnexpectedly = false;
    private boolean sessionStartedUnexpectedly = false;
    private DateTime sessionStartDate;
    private DateTime sessionEndDate;
    private HistoryEvent previousEvent;
    private String rampivaSessionProductName;
    private boolean pastEventOpenSession;
    private String matterId;
    private String customDigestSizeMetadataFieldName;
    private boolean computeDigests;
    private DateTime nonWorkerBasedBatchStartDate;
    private DateTime nonWorkerBasedBatchEndDate;

    public boolean getIsRampivaSession() {
        return this.rampivaSessionProductName != null;
    }

    public String getRampivaSessionProductName() {
        return this.rampivaSessionProductName;
    }

    public void setRampivaSessionProductName(String rampivaSessionProductName) {
        this.rampivaSessionProductName = rampivaSessionProductName;
    }

    public String getCustomDigestSizeMetadataFieldName() {
        return this.customDigestSizeMetadataFieldName;
    }

    public void setCustomDigestSizeMetadataFieldName(String customDigestSizeMetadataFieldName) {
        this.customDigestSizeMetadataFieldName = customDigestSizeMetadataFieldName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public void setSessionStarted(boolean sessionStarted) {
        this.sessionStarted = sessionStarted;
    }

    public void setSessionEnded(boolean sessionEnded) {
        this.sessionEnded = sessionEnded;
    }

    public void setSessionEndedUnexpectedly(boolean sessionEndedUnexpectedly) {
        this.sessionEndedUnexpectedly = sessionEndedUnexpectedly;
    }

    public void setSessionStartedUnexpectedly(boolean sessionStartedUnexpectedly) {
        this.sessionStartedUnexpectedly = sessionStartedUnexpectedly;
    }

    public List<Operation> getOperations() {
        if (this.operations.size() == 0 && this.sessionStartDate != null && this.sessionEndDate != null) {
            Operation operation = new Operation();
            ++this.operationId;
            operation.setOperationExecutionPosition(this.operationId);
            operation.setOperationId(this.session.getSessionId() + "-" + this.operationId);
            operation.setMimeTypeVolumes(new ArrayList());
            operation.setOperationType(OperationType.OTHER_NON_WORKER);
            operation.setSessionId(this.id);
            operation.setOperationStartEpoch(this.sessionStartDate.getMillis());
            long sessionInactivityMillis = this.sessionStartDate.getMillis() + 60000L;
            long eventEndDate = Math.min(sessionInactivityMillis, this.sessionEndDate.getMillis());
            operation.setOperationEndEpoch(eventEndDate);
            operation.setOperationName("Unknown");
            this.operations.add(operation);
        }
        return this.operations;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUser() {
        return this.user;
    }

    public String getId() {
        return this.id;
    }

    public DateTime getSessionStartDate() {
        return this.sessionStartDate;
    }

    public void setSessionStartDate(DateTime sessionStartDate) {
        this.sessionStartDate = sessionStartDate;
    }

    public DateTime getSessionEndDate() {
        return this.sessionEndDate;
    }

    public void setSessionEndDate(DateTime sessionEndDate) {
        this.sessionEndDate = sessionEndDate;
    }

    public SessionStats() {
    }

    public SessionStats(Case nuixCase, Utilities nuixUtilities, String matterId, ScanCaseStatisticsOperationImplementation scanCaseStatisticsOperation) {
        this.operations = new ArrayList<Operation>();
        this.nuixCase = nuixCase;
        this.nuixUtilities = nuixUtilities;
        this.scanCaseStatisticsOperation = scanCaseStatisticsOperation;
        this.customDigestSizeMetadataFieldName = scanCaseStatisticsOperation.getCustomDigestSizeMetadataFieldName();
        this.computeDigests = scanCaseStatisticsOperation.computeDigestSize;
        this.session = new Session();
        this.session.setSessionWorkers(1);
        this.session.setNuixVersion("Unknown");
        this.session.setProductName("Nuix");
        this.session.setProductVersion("via SCS " + SessionStats.class.getPackage().getImplementationVersion());
        this.batchTypeEvents = new HashSet<String>();
        this.batchTypeEvents.add("loadData");
        this.batchTypeEvents.add("openSession");
        this.batchTypeEvents.add("closeSession");
        this.batchTypeEvents.add("export");
        this.previousEventUser = null;
        this.operationId = 0;
        this.nuixVersion = "Unknown";
        this.matterId = matterId;
        this.computeDigests = scanCaseStatisticsOperation.computeDigestSize;
    }

    private OperationType getExportType(HistoryEvent event) {
        Map exportDetails = event.getDetails();
        Object exportTarget = exportDetails.get("target");
        if (exportTarget == null) {
            return null;
        }
        if (exportTarget.toString().contains("bulk OCR")) {
            return OperationType.OCR;
        }
        if (exportTarget.toString().contains("to generate printed")) {
            return OperationType.IMAGE;
        }
        if (exportTarget.toString().startsWith("Item load format")) {
            return OperationType.NATIVE_EXPORT;
        }
        if (exportTarget.toString().contains("load format") || exportTarget.toString().startsWith("Ringtail")) {
            return OperationType.LEGAL_EXPORT;
        }
        return OperationType.OTHER_EXPORT;
    }

    private void setIdFromEvent(HistoryEvent event) {
        this.id = this.getIdFromEvent(event);
        this.session.setSessionId(this.id);
        this.user = event.getUser().toString();
        HashMap eventDetails = new HashMap();
        eventDetails.putAll(event.getDetails());
        Object version = eventDetails.get("version");
        if (version != null) {
            this.nuixVersion = version.toString();
        }
    }

    private String getIdFromString(String id) {
        id = DatatypeConverter.printHexBinary((byte[])HashingUtils.digestMd5((byte[])id.getBytes(StandardCharsets.UTF_8))).toLowerCase();
        return id;
    }

    private String getIdFromEvent(HistoryEvent event) {
        Object id = this.nuixCase.getGuid() + "-" + event.toString();
        id = UidUtils.fromString((String)id, (String)"session").toString();
        return id;
    }

    public void handleNonWorkerBasedBatch(HistoryEvent event) {
        long timeElapsedSinceLastEvent;
        if (this.batchTypeEvents.contains(event.getTypeString())) {
            if (this.nonWorkerBasedBatchStartDate != null && this.previousEvent != null) {
                this.nonWorkerBasedBatchEndDate = this.previousEvent.getEndDate().getMillis() > event.getStartDate().getMillis() ? event.getStartDate() : this.previousEvent.getEndDate();
                Operation operation = new Operation();
                ++this.operationId;
                operation.setOperationExecutionPosition(this.operationId);
                operation.setOperationId(this.session.getSessionId() + "-" + this.operationId);
                operation.setMimeTypeVolumes(new ArrayList());
                this.session.setNuixVersion(this.nuixVersion);
                operation.setOperationType(OperationType.OTHER_NON_WORKER);
                operation.setOperationStartEpoch(this.nonWorkerBasedBatchStartDate.getMillis());
                operation.setOperationEndEpoch(this.nonWorkerBasedBatchEndDate.getMillis());
                operation.setOperationName("Unknown");
                this.operations.add(operation);
                LOGGER.info("   Detected other non-worker " + this.nonWorkerBasedBatchStartDate.toString() + " to " + this.nonWorkerBasedBatchEndDate.toString());
                this.nonWorkerBasedBatchStartDate = null;
                this.nonWorkerBasedBatchEndDate = null;
            }
        } else if (this.nonWorkerBasedBatchStartDate == null) {
            this.nonWorkerBasedBatchStartDate = event.getStartDate();
        } else if (this.previousEvent != null && (timeElapsedSinceLastEvent = event.getStartDate().getMillis() - this.previousEvent.getEndDate().getMillis()) > 60000L) {
            this.nonWorkerBasedBatchEndDate = this.previousEvent.getEndDate();
            Operation operation = new Operation();
            ++this.operationId;
            operation.setOperationExecutionPosition(this.operationId);
            operation.setOperationId(this.session.getSessionId() + "-" + this.operationId);
            operation.setMimeTypeVolumes(new ArrayList());
            this.session.setNuixVersion(this.nuixVersion);
            operation.setOperationType(OperationType.OTHER_NON_WORKER);
            operation.setOperationStartEpoch(this.nonWorkerBasedBatchStartDate.getMillis());
            operation.setOperationEndEpoch(this.nonWorkerBasedBatchEndDate.getMillis());
            operation.setOperationName("Unknown");
            this.operations.add(operation);
            LOGGER.info("   Detected other non-worker " + this.nonWorkerBasedBatchStartDate.toString() + " to " + this.nonWorkerBasedBatchEndDate.toString());
            this.nonWorkerBasedBatchStartDate = event.getStartDate();
            this.nonWorkerBasedBatchEndDate = null;
        }
    }

    private boolean isEventOpenSession(HistoryEvent event) {
        Map eventDetails;
        Object searchString;
        if (event.getTypeString().equals("openSession")) {
            this.pastEventOpenSession = true;
            return true;
        }
        if (!this.pastEventOpenSession && event.getTypeString().equals("search") && (searchString = (eventDetails = event.getDetails()).get("searchString")) != null && searchString.toString().contains("Automate_Session_Start_")) {
            LOGGER.info("Detected Automate session start from " + String.valueOf(searchString));
            return true;
        }
        this.pastEventOpenSession = false;
        return false;
    }

    private void checkSessionRampiva(HistoryEvent event) {
        Map eventDetails;
        Object searchString;
        if (event.getTypeString().equals("search") && (searchString = (eventDetails = event.getDetails()).get("searchString")) != null) {
            if (searchString.toString().contains("Automate_Session_Type_EngineLicenceSession") || searchString.toString().contains("Rampiva_Session_Type_EngineLicenceSession")) {
                LOGGER.info(" Session is Automate Engine session from " + String.valueOf(searchString));
                this.rampivaSessionProductName = "Automate Engine";
                return;
            }
            if (searchString.toString().contains("Automate_Session_Type_WorkflowExecutionLicenceSession") || searchString.toString().contains("Rampiva_Session_Type_WorkflowExecutionLicenceSession")) {
                LOGGER.info(" Session is Automate Workflow session from " + String.valueOf(searchString));
                this.rampivaSessionProductName = "Automate Workflow";
                return;
            }
            if (searchString.toString().contains("Automate_Session_Type_UtilizationExtractionLicenceSession") || searchString.toString().contains("Rampiva_Session_Type_UtilizationExtractionLicenceSession")) {
                LOGGER.info(" Session is Automate UE session from " + String.valueOf(searchString));
                this.rampivaSessionProductName = "Automate UE";
                return;
            }
            if (searchString.toString().contains("Automate_Session_Type_BaselineEngineLicenceSession") || searchString.toString().contains("Rampiva_Session_Type_BaselineEngineLicenceSession")) {
                LOGGER.info(" Session is Automate Baseline session from " + String.valueOf(searchString));
                this.rampivaSessionProductName = "Automate Baseline";
                return;
            }
        }
    }

    private boolean isEventCloseSession(HistoryEvent event) {
        Map eventDetails;
        Object searchString;
        if (event.getTypeString().equals("closeSession")) {
            return true;
        }
        if (event.getTypeString().equals("search") && (searchString = (eventDetails = event.getDetails()).get("searchString")) != null && searchString.toString().contains("Automate_Session_End_")) {
            LOGGER.info("Detected Automate session end");
            return true;
        }
        return false;
    }

    public void processEvent(HistoryEvent event) {
        block21: {
            long timeElapsedSinceLastEvent;
            this.handleNonWorkerBasedBatch(event);
            this.checkSessionRampiva(event);
            if (this.isEventOpenSession(event)) {
                if (!this.sessionStarted) {
                    this.sessionStarted = true;
                    this.setIdFromEvent(event);
                    this.sessionStartDate = event.getStartDate();
                    LOGGER.info("Session started at " + String.valueOf(this.sessionStartDate));
                } else {
                    this.sessionEndDate = this.previousEvent.getEndDate().getMillis() > event.getStartDate().getMillis() ? event.getStartDate() : this.previousEvent.getEndDate();
                    this.sessionEnded = true;
                    this.sessionEndedUnexpectedly = true;
                }
            }
            if (this.sessionStartedUnexpectedly && this.previousEvent != null && (timeElapsedSinceLastEvent = event.getStartDate().getMillis() - this.previousEvent.getEndDate().getMillis()) > 60000L) {
                this.sessionEndDate = this.previousEvent.getEndDate();
                this.sessionEnded = true;
                this.sessionEndedUnexpectedly = true;
            }
            if (this.previousEventUser != null && event.getUser() != null && !this.previousEventUser.equals(event.getUser().getLongName())) {
                if (this.previousEvent != null) {
                    this.sessionEndDate = this.previousEvent.getEndDate();
                }
                this.sessionEnded = true;
                this.sessionEndedUnexpectedly = true;
            }
            this.previousEventUser = event.getUser().getLongName();
            if (this.isEventCloseSession(event)) {
                this.sessionEndDate = event.getEndDate();
                LOGGER.info("Session ended at " + String.valueOf(this.sessionEndDate));
                this.sessionEnded = true;
            } else {
                if (!this.sessionStarted) {
                    this.sessionStarted = true;
                    this.sessionStartedUnexpectedly = true;
                    this.setIdFromEvent(event);
                    this.sessionStartDate = event.getStartDate();
                    LOGGER.info("Session started at " + String.valueOf(this.sessionStartDate));
                }
                if (event.getTypeString().equals("loadData")) {
                    LOGGER.info("   Detected load data " + String.valueOf(event.getStartDate()) + " to " + String.valueOf(event.getEndDate()));
                    Operation operation = new Operation();
                    ++this.operationId;
                    operation.setOperationExecutionPosition(this.operationId);
                    operation.setOperationId(this.session.getSessionId() + "-" + this.operationId);
                    operation.setMimeTypeVolumes(new ArrayList());
                    this.session.setNuixVersion(this.nuixVersion);
                    operation.setOperationType(OperationType.LOAD);
                    operation.setOperationStartEpoch(event.getStartDate().getMillis());
                    operation.setOperationEndEpoch(event.getEndDate().getMillis());
                    operation.setOperationName("Add Evidence");
                    this.operations.add(operation);
                    try {
                        BatchLoadDetails bestMatch = null;
                        long bestEventToBatchStart = 0L;
                        for (BatchLoadDetails batchLoadDetails : this.nuixCase.getBatchLoads()) {
                            if (event.getEndDate().compareTo((ReadableInstant)batchLoadDetails.getLoaded()) < 0) continue;
                            long eventToBatchStart = batchLoadDetails.getLoaded().getMillis() - event.getStartDate().getMillis();
                            if (bestMatch != null && eventToBatchStart <= bestEventToBatchStart) continue;
                            bestEventToBatchStart = eventToBatchStart;
                            bestMatch = batchLoadDetails;
                        }
                        if (bestMatch != null && bestEventToBatchStart < 0L) {
                            LOGGER.warn("       Best batch match " + bestMatch.getBatchId() + " starts " + bestEventToBatchStart + " ms before event, at " + bestMatch.getLoaded().toString() + ", vs event start " + event.getStartDate().toString());
                        }
                        if (bestMatch != null && bestEventToBatchStart > -60000L) {
                            BatchLoadDetails batchLoadDetails = bestMatch;
                            this.scanCaseStatisticsOperation.setScanEventType(operation.getOperationType().toString());
                            this.session.setSessionWorkers(Math.max(this.session.getSessionWorkers(), (Integer)batchLoadDetails.getParallelProcessingSettings().get("Worker count")));
                            this.session.setNuixVersion(batchLoadDetails.getDataSettings().get("Software version").toString());
                            String batchLoadGuid = batchLoadDetails.getBatchId();
                            String query = "batch-load-guid:" + batchLoadGuid;
                            this.serverName = "Unknown (" + batchLoadDetails.getOperatingSystem() + " / " + String.valueOf(batchLoadDetails.getAdditionalSettings().get("system.processorCount")) + " proc / " + String.valueOf(batchLoadDetails.getAdditionalSettings().get("system.memory")) + ")";
                            CaseStatistics caseStatistics = this.nuixCase.getStatistics();
                            GrowingChunkPartitioner partitioner = new GrowingChunkPartitioner((Iterable)this.nuixUtilities.getItemTypeUtility().getAllTypes());
                            Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                                while (iterator.hasNext() && !this.scanCaseStatisticsOperation.stopRequested) {
                                    ItemType itemType = (ItemType)iterator.next();
                                    try {
                                        String countQuery = query + " AND mime-type:" + itemType.getName();
                                        long count = 0L;
                                        count = this.nuixCase.count(countQuery);
                                        if (count <= 0L) continue;
                                        MimeTypeVolume mimeTypeVolume = new MimeTypeVolume();
                                        mimeTypeVolume.setOperationId(operation.getOperationId());
                                        mimeTypeVolume.addItemsCount(count);
                                        mimeTypeVolume.setMimeTypeId(itemType.getName());
                                        String auditedQuery = countQuery + " AND flag:audited";
                                        long auditedCount = this.nuixCase.count(auditedQuery);
                                        long auditedSize = 0L;
                                        if (auditedCount > 0L) {
                                            auditedSize = caseStatistics.getAuditSize(auditedQuery);
                                        }
                                        if (auditedSize > 0L && auditedCount == 0L) {
                                            LOGGER.info("what is the count?");
                                        }
                                        mimeTypeVolume.addAuditedCount(auditedCount);
                                        mimeTypeVolume.addAuditedSize(auditedSize);
                                        String physicalQuery = countQuery + " AND flag:physical_file";
                                        long physicalCount = this.nuixCase.count(physicalQuery);
                                        long physicalSize = 0L;
                                        if (physicalCount > 0L) {
                                            physicalSize = caseStatistics.getFileSize(physicalQuery);
                                        }
                                        mimeTypeVolume.addPhysicalCount(physicalCount);
                                        mimeTypeVolume.addPhysicalSize(physicalSize);
                                        if (this.computeDigests) {
                                            mimeTypeVolume.addDigestSize(NuixUtils.getDigestSize(this.nuixCase, countQuery, this.customDigestSizeMetadataFieldName));
                                        }
                                        Operation operation2 = operation;
                                        synchronized (operation2) {
                                            operation.getMimeTypeVolumes().add(mimeTypeVolume);
                                        }
                                    }
                                    catch (IOException e) {
                                        LOGGER.error("Unexpected error", (Throwable)e);
                                    }
                                }
                            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                            break block21;
                        }
                        LOGGER.warn("Cannot find batch to match event " + event.toString());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot handle batch", (Throwable)e);
                    }
                } else if (event.getTypeString().equals("export")) {
                    OperationType eventType = this.getExportType(event);
                    LOGGER.info("   Detected " + String.valueOf(eventType) + " " + String.valueOf(event.getStartDate()) + " to " + String.valueOf(event.getEndDate()));
                    if (eventType != null) {
                        Operation operation = new Operation();
                        ++this.operationId;
                        operation.setOperationExecutionPosition(this.operationId);
                        operation.setOperationId(this.session.getSessionId() + "-" + this.operationId);
                        operation.setMimeTypeVolumes(new ArrayList());
                        this.session.setNuixVersion(this.nuixVersion);
                        operation.setOperationType(eventType);
                        operation.setOperationStartEpoch(event.getStartDate().getMillis());
                        operation.setOperationEndEpoch(event.getEndDate().getMillis());
                        String operationName = StringUtils.capitalize((String)eventType.toString().replace("_", " ").toLowerCase().replace("export", "Export"));
                        operation.setOperationName(operationName);
                        this.operations.add(operation);
                        this.scanCaseStatisticsOperation.setScanEventType(operation.getOperationType().toString());
                        ConcurrentHashMap operationMimeTypeVolumes = new ConcurrentHashMap();
                        AtomicLong exportSize = new AtomicLong(0L);
                        AtomicLong attachmentsSize = new AtomicLong(0L);
                        HashSet affectedItems = event.getAffectedItems();
                        LOGGER.info("Items count: " + affectedItems.size());
                        AtomicLong processedItems = new AtomicLong();
                        if (this.scanCaseStatisticsOperation.includeNativeExportNonExportedMaterialChildren && eventType.equals((Object)OperationType.NATIVE_EXPORT)) {
                            HashSet newAffectedItems = new HashSet();
                            newAffectedItems.addAll(affectedItems);
                            LOGGER.info("Native export operation items in scope: " + affectedItems.size());
                            Set descendants = this.nuixUtilities.getItemUtility().findDescendants((Collection)affectedItems);
                            LOGGER.info("All descendants: " + descendants.size());
                            int materialDescendants = 0;
                            for (Item item : descendants) {
                                if (!item.isAudited()) continue;
                                ++materialDescendants;
                                newAffectedItems.add(item);
                            }
                            LOGGER.info("Material descendants: " + materialDescendants);
                            LOGGER.info("Native export operation items + material descendants: " + newAffectedItems.size());
                            affectedItems = newAffectedItems;
                        }
                        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)affectedItems, ItemsUtils.getPartitionerChunkSize(1000, null));
                        AtomicLong pages = new AtomicLong(0L);
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            while (iterator.hasNext() && !this.scanCaseStatisticsOperation.stopRequested) {
                                MimeTypeVolume mimeTypeVolume;
                                Item item;
                                block12: {
                                    item = (Item)iterator.next();
                                    String mimeType = item.getType().getName();
                                    mimeTypeVolume = new MimeTypeVolume();
                                    mimeTypeVolume.setMimeTypeId(mimeType);
                                    mimeTypeVolume.setOperationId(operation.getOperationId());
                                    MimeTypeVolume existingMimeTypeVolume = operationMimeTypeVolumes.putIfAbsent(mimeType, mimeTypeVolume);
                                    if (existingMimeTypeVolume != null) {
                                        mimeTypeVolume = existingMimeTypeVolume;
                                    }
                                    mimeTypeVolume.incrementItemsCount();
                                    if (item.isPhysicalFile()) {
                                        mimeTypeVolume.incrementPhysicalCount();
                                        mimeTypeVolume.addPhysicalSize(item.getFileSize().longValue());
                                    }
                                    if (this.computeDigests) {
                                        try {
                                            mimeTypeVolume.addDigestSize(NuixUtils.getItemDigestSize(item, this.customDigestSizeMetadataFieldName));
                                        }
                                        catch (InvalidCustomDigestSizeException e) {
                                            if (!LOGGER.isDebugEnabled()) break block12;
                                            LOGGER.debug("Cannot compute digest for item " + item.getGuid() + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                                        }
                                    }
                                }
                                if (item.isAudited()) {
                                    long auditedSize = item.getAuditedSize();
                                    mimeTypeVolume.incrementAuditedCount();
                                    mimeTypeVolume.addAuditedSize(auditedSize);
                                    exportSize.addAndGet(auditedSize);
                                    if (!item.isTopLevel()) {
                                        attachmentsSize.addAndGet(auditedSize);
                                    }
                                }
                                if (eventType != OperationType.OCR && eventType != OperationType.IMAGE) continue;
                                Long itemPages = null;
                                try {
                                    Object pageCount = item.getProperties().get("Page Count");
                                    if (pageCount != null) {
                                        itemPages = (long)((Integer)pageCount);
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot get pages", (Throwable)e);
                                }
                                if (itemPages == null) {
                                    itemPages = 1L;
                                }
                                mimeTypeVolume.addPagesCount(itemPages.longValue());
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                        operation.getMimeTypeVolumes().addAll(operationMimeTypeVolumes.values());
                    }
                }
            }
        }
        if (this.previousEvent == null || event.getStartDate().compareTo((ReadableInstant)this.previousEvent.getEndDate()) >= 0) {
            this.previousEvent = event;
        }
    }

    public void endSession() {
        if (this.previousEvent != null) {
            this.sessionEndDate = this.previousEvent.getEndDate();
            this.sessionEnded = true;
        } else {
            LOGGER.info("Cannot close empty session");
        }
    }

    public boolean sessionEnded() {
        return this.sessionEnded;
    }

    public boolean getSessionEndedUnexpectedly() {
        return this.sessionEndedUnexpectedly;
    }

    public boolean getSessionStartedUnexpectedly() {
        return this.sessionStartedUnexpectedly;
    }

    public boolean isCurrentSession() {
        return false;
    }

    public String getNuixVersion() {
        return this.nuixVersion;
    }

    public Session getSession() {
        return this.session;
    }

    public String getMatterId() {
        return this.matterId;
    }
}

