/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccIdentifierType;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureEccConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.EccOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.SET_ECC_CASE, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"ECC"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@FormFieldRow(name="caseIdentifierRow", children={"caseIdentifierType", "caseIdentifier"})
@OperationParameters(value={@OperationParameter(label="caseName", parameter="{ecc_case_name}"), @OperationParameter(label="caseId", parameter="{ecc_case_id}"), @OperationParameter(label="caseCreated", parameter="{ecc_case_created}")})
public class SetEccCaseOperation
extends EccOperation {
    @FormField
    public EccIdentifierType caseIdentifierType;
    @FormField
    public String caseIdentifier;
    @FormField
    public boolean createCaseIfNotExists;
    @FormField(visibleOn={@OnField(name="createCaseIfNotExists"), @OnField(name="caseIdentifierType", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"NAME"})})
    public String caseName;

    public SetEccCaseOperation() {
        this.requiresCase = false;
        this.caseIdentifierType = EccIdentifierType.NAME;
        this.caseIdentifier = "";
        this.createCaseIfNotExists = true;
        this.caseName = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("SetEccCaseOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureEccConnectionOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureEccConnectionOperation) {
                detectedConfigureEccConnectionOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureEccConnectionOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccConnection"));
        }
        if (this.caseIdentifier == null || this.caseIdentifier.trim().length() == 0) {
            prerequisites.add(this.iu.getString("SetEccCaseOperation.Prerequisites.CaseIdentifierMissing"));
        }
        if (this.caseIdentifierType != EccIdentifierType.NAME && (this.caseName == null || this.caseName.trim().length() == 0)) {
            prerequisites.add(this.iu.getString("SetEccCaseOperation.Prerequisites.CaseNameMissing"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

