/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccIdentifierType;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.cases.Case;
import com.nuix.automate.utils.ecc.responses.cases.Cases;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.SetEccCaseOperation;
import org.apache.commons.lang3.NotImplementedException;

public class SetEccCaseOperationImplementation
extends SetEccCaseOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SetEccCaseOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient EccUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = "";
                this.utils = EccUtils.getInstance();
                this.caseIdentifier = this.executionContext.evalParameters(this.caseIdentifier, this);
                this.initializeEccClient();
                this.percentageComplete = 0.3;
                this.stageName = this.iu.getString("SetEccCaseOperation.Stage.GettingCase");
                Case eccCase = null;
                Cases eccCases = this.eccRestClient.getCases();
                eccCase = (Case)this.utils.filter(eccCases.getCases(), this.caseIdentifierType, this.caseIdentifier);
                if (eccCase != null) {
                    switch (this.caseIdentifierType) {
                        case ID: {
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseId", (Object)this.caseIdentifier));
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseName", (Object)eccCase.getName()));
                            break;
                        }
                        case NAME: {
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseName", (Object)this.caseIdentifier));
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseId", (Object)eccCase.getId()));
                            break;
                        }
                        case NAME_REGEX: {
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseNameRegex", (Object)this.caseIdentifier));
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseId", (Object)eccCase.getId()));
                            this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseName", (Object)eccCase.getName()));
                            break;
                        }
                        default: {
                            throw new NotImplementedException("Case identifier type " + String.valueOf(this.caseIdentifierType) + " not supported");
                        }
                    }
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_id}", String.valueOf(eccCase.getId()))));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_name}", eccCase.getName())));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_created}", "false")));
                } else if (this.createCaseIfNotExists) {
                    this.stageName = this.iu.getString("SetEccCaseOperation.Stage.CreatingCase");
                    this.addExecutionLog(this.iu.getString("SetEccCaseOperation.Log.CouldNotFindCase"));
                    this.percentageComplete = 0.6;
                    Case createCase = new Case();
                    if (this.caseIdentifierType == EccIdentifierType.NAME) {
                        createCase.setName(this.caseIdentifier);
                    } else {
                        createCase.setName(this.caseName);
                    }
                    boolean cloneCaseNameExists = this.utils.containsName(eccCases.getCases(), createCase.getName());
                    if (cloneCaseNameExists) {
                        throw new Exception(this.iu.getFormattedString("SetEccCaseOperation.Error.CannotCreateCase_NameExists", (Object)createCase.getName()));
                    }
                    createCase.setId(0);
                    eccCase = this.eccRestClient.createCase(createCase);
                    this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseId", (Object)eccCase.getId()));
                    this.addExecutionLog(this.iu.getFormattedString("SetEccCaseOperation.Log.CaseName", (Object)eccCase.getName()));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_id}", String.valueOf(eccCase.getId()))));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_name}", eccCase.getName())));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_case_created}", "true")));
                } else {
                    throw new Exception(this.iu.getFormattedString("SetEccCaseOperation.Error.CaseDoesNotExist", new Object[]{this.caseIdentifierType.toString(), this.caseIdentifier}));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

