/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.SqlCommandOperation;
import com.nuix.automate.workflow.core.execution.options.sqlcommand.SqlDatabase;
import com.nuix.automate.workflow.core.utils.sql.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SqlCommandOperationImplementation
extends SqlCommandOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SqlCommandOperation.class);
    private transient Connection connection;
    private transient String stageName;
    private transient int stageId;

    @Override
    protected void startTriggered() throws Exception {
        this.username = this.executionContext.evalParameters(this.username, this);
        this.password = this.executionContext.evalProtectedParameter(this.password);
        this.databaseName = this.executionContext.evalParameters(this.databaseName, this);
        this.sqlServerName = this.executionContext.evalParameters(this.sqlServerName, this);
        this.sqlQuery = this.executionContext.evalParameters(this.sqlQuery, this);
        if (this.sqlPlatform.getDatabaseType() == SqlDatabase.MICROSOFT_SQL) {
            this.instance = this.executionContext.evalParameters(this.instance, this);
            this.domain = this.executionContext.evalParameters(this.domain, this);
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                try {
                    this.stageName = this.iu.getString("SqlCommandOperation.Stage.ConnectingToSql");
                    this.stageId = 1;
                    this.connection = SqlUtils.createConnection(this.sqlPlatform, this.sqlServerName, this.port, this.instance, this.domain, this.databaseName, this.sqlEncryption, this.username, this.password, this.executionContext, this);
                }
                catch (SQLException e) {
                    this.addWarning(this.iu.getString("SqlCommandOperation.Warning.UnableToCreateConnection"));
                    LOGGER.warn("Unable to create connection to SQL server");
                    throw e;
                }
                PreparedStatement statement = this.connection.prepareStatement(this.sqlQuery);
                try {
                    this.stageName = this.iu.getString("SqlCommandOperation.Stage.RunningCommand");
                    this.stageId = 2;
                    int updatedRows = statement.executeUpdate();
                    if (updatedRows == 0) {
                        this.addExecutionLog(this.iu.getString("SqlCommandOperation.Log.SuccessfullyRanCommand"));
                    } else {
                        this.addExecutionLog(this.iu.getNumeralString("SqlCommandOperation.Log.UpdatedRows", (long)updatedRows));
                    }
                }
                catch (SQLException e) {
                    LOGGER.warn("Unable to run SQL command: " + e.getMessage());
                    this.addWarning(this.iu.getFormattedString("SqlCommandOperation.Warning.UnableToRunSqlCommand", (Object)e.getLocalizedMessage()));
                }
                this.connection.close();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.stageId == 1) {
            return 1.0E-4;
        }
        return 0.25;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        result = (String)result + this.stageName;
        return result;
    }
}

