/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureEccConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.EccOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.SetEccCaseOperation;
import com.nuix.automate.workflow.core.execution.operations.SetEccCollectionConfigurationOperation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="destinationLocationRow", children={"overrideDestinationLocation", "destinationLocation"})
@OperationMetadata(alias=OperationAlias.SUBMIT_ECC_COLLECTION, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"ECC"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
public class SubmitEccCollectionOperation
extends EccOperation {
    @FormField
    public String collectionName;
    @FormField
    public boolean waitForCollectionToFinish;
    @FormField
    public boolean overrideDestinationLocation;
    @FormField(enableOn={@OnField(name="overrideDestinationLocation")})
    public String destinationLocation;

    public SubmitEccCollectionOperation() {
        this.requiresCase = false;
        this.collectionName = "";
        this.overrideDestinationLocation = false;
        this.destinationLocation = "";
        this.waitForCollectionToFinish = true;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("SubmitEccCollectionOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureEccConnectionOperation = false;
        boolean detectedSetEccConfigurationOperation = false;
        boolean detectedSetEccCaseOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureEccConnectionOperation) {
                detectedConfigureEccConnectionOperation = true;
            }
            if (o instanceof SetEccCaseOperation) {
                detectedSetEccCaseOperation = true;
            }
            if (o instanceof SetEccCollectionConfigurationOperation) {
                detectedSetEccConfigurationOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureEccConnectionOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccConnection"));
        }
        if (!detectedSetEccCaseOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccCase"));
        }
        if (!detectedSetEccConfigurationOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingConfiguration"));
        }
        if (this.collectionName == null || this.collectionName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("SubmitEccCollectionOperation.Prerequisites.MissingCollectionName"));
        }
        if (this.overrideDestinationLocation && (this.destinationLocation == null || this.destinationLocation.trim().equals(""))) {
            prerequisites.add(this.iu.getString("SubmitEccCollectionOperation.Prerequisites.MissingDestinationLocation"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

