/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

class TreeCountSizeReportItemStats {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TreeCountSizeReportItemStats.class);
    public AtomicLong itemsCount;
    public AtomicLong containersCount;
    public AtomicLong totalSize;
    public AtomicLong imediateDescendantsSize;
    public AtomicLong imediateDescendantsCount;
    public DateTime createdTime;
    public DateTime lastModifiedTime;
    public String path;
    public String uniquePath;
    public int depth;
    public String guid;

    TreeCountSizeReportItemStats() {
    }

    public void merge(TreeCountSizeReportItemStats deltaItemStats) throws Exception {
        this.itemsCount.addAndGet(deltaItemStats.itemsCount.get());
        this.containersCount.addAndGet(deltaItemStats.containersCount.get());
        this.totalSize.addAndGet(deltaItemStats.totalSize.get());
        this.imediateDescendantsSize.addAndGet(deltaItemStats.imediateDescendantsSize.get());
        this.imediateDescendantsCount.addAndGet(deltaItemStats.imediateDescendantsCount.get());
        if (this.createdTime == null || deltaItemStats.createdTime == null || !this.createdTime.isEqual((ReadableInstant)deltaItemStats.createdTime)) {
            this.createdTime = null;
        }
        if (this.lastModifiedTime == null || deltaItemStats.lastModifiedTime == null || !this.lastModifiedTime.isEqual((ReadableInstant)deltaItemStats.lastModifiedTime)) {
            this.lastModifiedTime = null;
        }
        if (!this.path.equals(deltaItemStats.path)) {
            throw new Exception("Cannot merge guid " + this.guid + " with " + deltaItemStats.guid + " due to incompatible path. Expected: " + this.path + ", Got: " + deltaItemStats.path);
        }
        if (!this.guid.contains(deltaItemStats.guid)) {
            this.guid = this.guid + "; " + deltaItemStats.guid;
        }
    }

    public void initialize(Item item, int omitPathPrefixes) {
        int i;
        this.itemsCount = new AtomicLong(0L);
        this.containersCount = new AtomicLong(0L);
        this.totalSize = new AtomicLong(0L);
        this.imediateDescendantsSize = new AtomicLong(0L);
        this.imediateDescendantsCount = new AtomicLong(0L);
        this.guid = item.getGuid();
        List pathNames = item.getPathNames();
        pathNames = pathNames.subList(omitPathPrefixes, pathNames.size());
        this.path = String.join((CharSequence)"\\", pathNames);
        this.depth = pathNames.size();
        pathNames = item.getPathNames();
        StringBuilder sortPathBuilder = new StringBuilder();
        int[] positions = item.getPosition().toArray();
        StringBuilder omittedPathIds = new StringBuilder();
        for (i = 0; i < omitPathPrefixes; ++i) {
            omittedPathIds.append(positions[i]);
            omittedPathIds.append("-");
        }
        for (i = omitPathPrefixes; i < pathNames.size(); ++i) {
            if (i == omitPathPrefixes) {
                sortPathBuilder.append((String)pathNames.get(i));
                sortPathBuilder.append("-");
                sortPathBuilder.append((CharSequence)omittedPathIds);
            } else {
                sortPathBuilder.append((String)pathNames.get(i));
                sortPathBuilder.append("-");
            }
            sortPathBuilder.append(positions[i]);
            if (i >= pathNames.size() - 1) continue;
            sortPathBuilder.append("\\");
        }
        this.uniquePath = sortPathBuilder.toString();
        try {
            Object createdObject = item.getProperties().get("File Created");
            this.createdTime = (DateTime)item.getProperties().get("File Created");
        }
        catch (Exception e) {
            this.createdTime = null;
            LOGGER.error("Cannot convert object " + String.valueOf(item.getProperties().get("File Created")), (Throwable)e);
        }
        try {
            this.lastModifiedTime = (DateTime)item.getProperties().get("File Modified");
        }
        catch (Exception e) {
            this.lastModifiedTime = null;
            LOGGER.error("Cannot convert object " + String.valueOf(item.getProperties().get("File Modified")), (Throwable)e);
        }
    }
}

