/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.report.SizeUnit;
import java.util.List;

@OperationMetadata(alias=OperationAlias.TREE_COUNT_SIZE_REPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"REPORTING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class TreeCountSizeReportOperation
extends Operation {
    @FormField(required=false)
    public String scope = "flag:audited or kind:container";
    @FormField(required=false)
    public String customReportTemplatePath = "";
    @FormField
    public String reportLocation = "{case_folder}/Reports/{case_name} - Tree Count Size Report {date}.xlsx";
    @FormField
    public SizeUnit sizeUnit = SizeUnit.GiB;
    @FormField
    public int omitPathPrefixes;
    @FormField
    public int maxPathDepth = 8;
    @FormField
    public boolean mergeIdenticalPaths = false;

    public TreeCountSizeReportOperation() {
        this.modifiesNuixCase = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("TreeCountSizeReportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.TREE_COUNT_SIZE_REPORT;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.reportLocation.trim().length() == 0) {
            prerequisites.add(this.iu.getString("TreeCountSizeReportOperation.Prerequisites.ReportLocationMustBeSpecified"));
        }
        return prerequisites;
    }
}

