/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.UntagItemsOperation;
import com.nuix.automate.workflow.core.execution.options.untagitems.TagsToRemove;
import com.nuix.automate.workflow.core.execution.options.untagitems.UntagItemsMethod;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nuix.BulkAnnotater;

public class UntagItemsOperationImplementation
extends UntagItemsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UntagItemsOperation.class);
    private transient String stageName;
    private transient int stageCount;
    private transient long countTagsToProcess;
    private transient long countTagsProcessed;

    @Override
    public void startTriggered() throws Exception {
        this.executionContext.closeAllTabs();
        this.startTriggerThread = new Thread(() -> {
            try {
                boolean removeByPrefix;
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                this.scope = this.executionContext.evalParameters(this.scope, this);
                long scopeCount = this.executionContext.nuixCase.count(this.scope);
                this.addExecutionLog(this.iu.getFormattedString("UntagItemsOperation.Log.ScopeQuery", (Object)this.scope));
                this.addExecutionLog(this.iu.getNumeralString("UntagItemsOperation.Log.ScopeCount", scopeCount));
                String effectiveTagPrefix = this.executionContext.evalParameters(this.tagPrefix, this).trim();
                if (effectiveTagPrefix.endsWith("|")) {
                    effectiveTagPrefix = effectiveTagPrefix.substring(0, effectiveTagPrefix.length() - 1);
                }
                Set caseTags = this.executionContext.nuixCase.getAllTags();
                this.countTagsToProcess = caseTags.size();
                this.countTagsProcessed = 0L;
                boolean removeAllTags = this.tagsToRemove == TagsToRemove.ALL;
                boolean bl = removeByPrefix = this.tagsToRemove == TagsToRemove.BY_PREFIX;
                if ((effectiveTagPrefix.length() > 0 || removeAllTags) && this.countTagsToProcess > 0L) {
                    String tagQuery;
                    String query;
                    Object rightQuery;
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    this.stageName = this.iu.getString("UntagItemsOperation.Stage.RemovingTags");
                    this.stageCount = 1;
                    this.addExecutionLog(this.iu.getFormattedString("UntagItemsOperation.Log.TagsToRemove", (Object)this.tagsToRemove));
                    if (removeByPrefix) {
                        this.addExecutionLog(this.iu.getFormattedString("UntagItemsOperation.Log.TagsPrefix", (Object)effectiveTagPrefix));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("UntagItemsOperation.Log.RemoveTagMethod", (Object)this.untagItemsMethod));
                    effectiveTagPrefix = this.escapeLucene(effectiveTagPrefix);
                    long countItemsUntagged = 0L;
                    if (removeAllTags) {
                        rightQuery = "has-tag:1";
                        query = NuixUtils.addAndQuery(this.scope, (String)rightQuery);
                        countItemsUntagged = this.executionContext.nuixCase.count(query);
                    } else if (removeByPrefix) {
                        rightQuery = "tag:(\"" + effectiveTagPrefix + "\" OR \"" + effectiveTagPrefix + "|*\")";
                        query = NuixUtils.addAndQuery(this.scope, (String)rightQuery);
                        countItemsUntagged = this.executionContext.nuixCase.count(query);
                    }
                    if (countItemsUntagged > 0L) {
                        LOGGER.info("Removing previous tags");
                        this.addExecutionLog(this.iu.getString("UntagItemsOperation.Log.TagsRemoved"));
                        for (String caseTag : caseTags) {
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            if (removeByPrefix) {
                                LOGGER.info("Checking tag " + caseTag + " vs prefix " + effectiveTagPrefix);
                            }
                            if (!caseTag.equals(effectiveTagPrefix) && !caseTag.startsWith(effectiveTagPrefix + "|") && !removeAllTags) continue;
                            LOGGER.info("Removing tag: " + caseTag);
                            this.stageName = this.iu.getFormattedString("UntagItemsOperation.Stage.UntaggingItems", (Object)caseTag);
                            tagQuery = "tag:\"" + this.escapeLucene(caseTag) + "\"";
                            String query2 = NuixUtils.addAndQuery(this.scope, tagQuery);
                            LOGGER.info("- Searching for " + (String)tagQuery);
                            Set taggedItems = this.executionContext.nuixCase.searchUnsorted(query2);
                            if (!taggedItems.isEmpty()) {
                                LOGGER.info("- Untagging " + taggedItems.size() + " items");
                                bulkAnnotater.removeTag(caseTag, (Collection)taggedItems);
                                this.addExecutionLog("\t" + this.iu.getFormattedString("UntagItemsOperation.Log.CaseTag", (Object)caseTag));
                            }
                            ++this.countTagsProcessed;
                        }
                        this.addExecutionLog(this.iu.getNumeralString("UntagItemsOperation.Log.TagsRemovedFrom", countItemsUntagged));
                        this.countTagsProcessed = 0L;
                    } else {
                        this.addExecutionLog(this.iu.getString("UntagItemsOperation.Log.NoItemsToUntag"));
                    }
                    if (this.untagItemsMethod == UntagItemsMethod.UNTAG_AND_DELETE) {
                        this.stageName = this.iu.getString("UntagItemsOperation.Stage.DeletingTags");
                        this.addExecutionLog(this.iu.getString("UntagItemsOperation.Log.TagsDeleted"));
                        for (String caseTag : caseTags) {
                            boolean isTagEmpty;
                            if (this.stopRequested) {
                                this.trackStopped();
                                return;
                            }
                            tagQuery = "tag:\"" + this.escapeLucene(caseTag) + "\"";
                            boolean bl2 = isTagEmpty = this.executionContext.nuixCase.count(tagQuery) == 0L;
                            if (!caseTag.equals(effectiveTagPrefix) && !caseTag.startsWith(effectiveTagPrefix + "|") && !removeAllTags || !isTagEmpty) continue;
                            LOGGER.info("Delete tag " + caseTag);
                            this.stageName = this.iu.getFormattedString("UntagItemsOperation.Stage.DeletingTag", (Object)caseTag);
                            if (!this.executionContext.nuixCase.deleteTag(this.escapeLucene(caseTag))) continue;
                            ++this.countTagsProcessed;
                            this.addExecutionLog("\t" + this.iu.getFormattedString("UntagItemsOperation.Log.CaseTag", (Object)caseTag));
                        }
                    }
                } else if (this.countTagsToProcess <= 0L) {
                    this.addWarning(this.iu.getString("UntagItemsOperation.Warning.NoTagsInCase"));
                } else {
                    this.addWarning(this.iu.getString("UntagItemsOperation.Warning.TagNullOrBlank"));
                }
                this.trackFinished();
            }
            catch (Exception ex) {
                LOGGER.error("Operation unchecked exception", (Throwable)ex);
                this.exception = ex;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String escapeLucene(String query) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '\\' || ch == '\"' || ch == '*' || ch == '?') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        double percentProcessed = 0.0;
        if (this.countTagsToProcess > 0L) {
            percentProcessed = (double)this.countTagsProcessed / (double)this.countTagsToProcess;
        }
        if (this.stageCount > 0) {
            percentageComplete = percentProcessed / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
            result = (String)result + " / ";
            result = (String)result + this.iu.getNumeralString("UntagItemsOperation.Progress.TagsProcessed", this.countTagsProcessed);
        }
        return result;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.tagPrefix.trim().length() == 0 && this.tagsToRemove == TagsToRemove.BY_PREFIX) {
            prerequisites.add(this.iu.getString("UntagItemsOperation.Prerequisites.TagCannotBeBlank"));
        }
        return prerequisites;
    }
}

