/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.BooleanOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.formbuilder.SensitiveField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.usecase.CaseBackend;
import com.nuix.automate.workflow.core.execution.options.usecase.CaseType;
import com.nuix.automate.workflow.core.execution.options.usecase.Method;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

@OperationMetadata(alias=OperationAlias.USE_CASE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationParameters(value={@OperationParameter(label="keywordRetrieveCurrentCaseFolder", parameter="{case_folder}"), @OperationParameter(label="keywordRetrievePreviousCaseFolder", parameter="{previous_case_folder}"), @OperationParameter(label="keywordRetrieveFirstUsedCase", parameter="{first_case_folder}")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class UseCaseOperation
extends Operation {
    @FormField
    public String caseLocation;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.TIMEZONE_IDS)
    public String timeZoneId;
    @FormField
    public Method method;
    @FormField(componentType=FieldComponentType.TEXTAREA, visibleOn={@OnField(name="method", value={"CREATE", "OPEN_CREATE"})})
    public String caseDescription;
    @FormField(visibleOn={@OnField(name="method", value={"CREATE", "OPEN_CREATE"})})
    public String caseInvestigator;
    @FormField(visibleOn={@OnField(name="method", value={"CREATE", "OPEN_CREATE"})})
    @ExcludeFromPrintableOptions
    public CaseType caseType;
    @FormField(visibleOn={@OnField(name="method", value={"CREATE", "OPEN_CREATE"})})
    @ExcludeFromPrintableOptions
    public CaseBackend caseBackend;
    @FormField(visibleOn={@OnField(name="caseBackend", value={"ELASTIC"})})
    public boolean useElasticsearchService;
    @FormField(visibleOn={@OnField(name="useElasticsearchService")})
    public String elasticsearchServiceId;
    @FormField(visibleOnOperator=BooleanOperator.AND, visibleOn={@OnField(name="caseBackend", value={"ELASTIC"}), @OnField(name="useElasticsearchService", value={"false"})}, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="value")})
    @ExcludeFromPrintableOptions
    @SensitiveField
    public List<Object[]> elasticProperties;
    @FormField(visibleOn={@OnField(name="method", value={"OPEN", "OPEN_CREATE"})})
    public boolean migrateCaseIfRequired;
    @FormField(visibleOn={@OnField(name="method", value={"OPEN", "OPEN_CREATE"})})
    public boolean attemptReopenIfLocked;
    @FormField(min=1.0, enableOn={@OnField(name="attemptReopenIfLocked")}, positionLabel=@PositionLabel(right="minutes"))
    @ExcludeFromPrintableOptions
    public int attemptTimeout;
    @ExcludeFromPrintableOptions
    public boolean predefined;

    public boolean getDisplayElasticProperties() {
        return this.caseBackend.equals((Object)CaseBackend.ELASTIC);
    }

    public UseCaseOperation() {
        this.requiresCase = false;
        this.predefined = true;
        this.caseLocation = "";
        this.caseDescription = "{client_name}/{matter_name}";
        this.caseInvestigator = "{job_submitted_by}";
        this.method = Method.OPEN_CREATE;
        this.migrateCaseIfRequired = false;
        this.caseType = CaseType.SIMPLE;
        this.caseBackend = CaseBackend.CLASSIC;
        this.attemptReopenIfLocked = false;
        this.attemptTimeout = 1;
        this.timeZoneId = TimeZone.getDefault().getID();
        this.elasticProperties = new ArrayList<Object[]>();
        this.elasticProperties.add(new String[]{"cluster.name", "localhost"});
        this.elasticProperties.add(new String[]{"nuix.transport.hosts", "127.0.0.1"});
        this.elasticProperties.add(new String[]{"index.number_of_shards", ""});
        this.elasticProperties.add(new String[]{"index.number_of_replicas", ""});
        this.useElasticsearchService = false;
        this.elasticsearchServiceId = "{elasticsearch_service_id}";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("UseCaseOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!(activity != Operation.PrerequisitesActivity.RUN_UNATTENDED && activity != Operation.PrerequisitesActivity.SUBMIT_UNATTENDED || this.predefined)) {
            prerequisites.add(this.iu.getString("UseCaseOperation.Prerequisites.SettingRequiredUnattended"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        if (this.predefined) {
            features.add(Feature.NUIX);
        } else {
            features.add(Feature.NUIX_WORKSTATION);
        }
        return features;
    }
}

