/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.QueryTerm;
import com.nuix.automate.utils.models.internal.vault.VaultHold;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.hold.HeldAccount;
import com.nuix.automate.utils.models.internal.vault.hold.HeldDriveQuery;
import com.nuix.automate.utils.models.internal.vault.hold.HeldGroupsQuery;
import com.nuix.automate.utils.models.internal.vault.hold.HeldHangoutsChatQuery;
import com.nuix.automate.utils.models.internal.vault.hold.HeldMailQuery;
import com.nuix.automate.utils.models.internal.vault.hold.HeldOrgUnit;
import com.nuix.automate.utils.models.internal.vault.hold.HeldQuery;
import com.nuix.automate.utils.models.internal.vault.hold.HeldVoiceQuery;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.workflow.core.execution.operations.VaultAddHoldsOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class VaultAddHoldsOperationImplementation
extends VaultAddHoldsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultAddHoldsOperation.class);
    private transient HeldMailQuery mailQuery;
    private transient HeldGroupsQuery groupsQuery;
    private transient HeldDriveQuery driveQuery;
    private transient HeldHangoutsChatQuery hangoutsChatQuery;
    private transient HeldVoiceQuery voiceQuery;

    @Override
    public void startTriggered() {
        this.stageCount = 4.0;
        this.stageId = 0.0;
        this.consumptionLocations = new ArrayList();
        this.runStartTriggeredThread(() -> {
            this.initialize();
            String dateTime = FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
            this.holdNamePrefix = this.executionContext.evalParameters(this.holdNamePrefix, this);
            this.stageName = this.iu.getString("VaultAddHoldsOperation.Stage.PreparingHolds");
            if (this.useHoldFiles) {
                this.holdLocationsFilePath = this.executionContext.evalParameters(this.holdLocationsFilePath, this);
                this.addExecutionLog(this.iu.getFormattedString("VaultAddHoldsOperation.Log.HoldLocationsFile", (Object)this.holdLocationsFilePath));
                this.holdLocations = this.readVaultLocationsFile(this.holdLocationsFilePath);
                this.queryTermsFilePath = this.executionContext.evalParameters(this.queryTermsFilePath, this);
                this.addExecutionLog(this.iu.getFormattedString("VaultAddHoldsOperation.Log.QueryTermsFile", (Object)this.queryTermsFilePath));
                this.queryTerms = this.readQueryTermsFile(this.queryTermsFilePath);
            }
            if (this.holdLocations.isEmpty()) {
                this.addWarning(this.iu.getString("VaultAddHoldsOperation.Log.NoHoldLocations"));
                return;
            }
            HashMap<String, VaultHold> holds = new HashMap<String, VaultHold>();
            HashMap<String, List> holdConsumptions = new HashMap<String, List>();
            this.populateOptions();
            for (int i = 0; i < this.holdLocations.size(); ++i) {
                VaultLocation holdLocation = (VaultLocation)this.holdLocations.get(i);
                if (!this.validateHoldLocation(i, holdLocation)) continue;
                String holdId = this.getHoldId(holdLocation);
                VaultHold hold = (VaultHold)holds.get(holdId);
                if (hold == null) {
                    hold = this.buildVaultHold(holdLocation);
                    hold.setName(this.holdNamePrefix + " " + holdId + " " + dateTime);
                    holds.put(holdId, hold);
                }
                String value = holdLocation.getValue().trim();
                switch (holdLocation.getSearchMethod()) {
                    case ACCOUNT: {
                        HeldAccount heldAccount = new HeldAccount();
                        heldAccount.setEmail(value);
                        hold.getAccounts().add(heldAccount);
                        break;
                    }
                    case ORG_UNIT: {
                        hold.getOrgUnit().setOrgUnitId(value);
                    }
                }
                List consumptions = holdConsumptions.computeIfAbsent(holdId, k -> new ArrayList());
                consumptions.add(holdLocation);
            }
            this.testOperationConsumption(holdConsumptions.values());
            this.stageId = 1.0;
            this.stageName = this.iu.getString("VaultAddHoldsOperation.Stage.CreatingHolds");
            this.stageItems = holds.size();
            this.processedItems = new AtomicLong();
            HashSet<String> createdHoldIds = new HashSet<String>();
            HashSet<String> addedLocations = new HashSet<String>();
            long failedToCreateHoldsCount = 0L;
            for (String holdId : holds.keySet()) {
                VaultHold hold = (VaultHold)holds.get(holdId);
                try {
                    hold = this.vaultRestClient.createHold(this.vaultMatterId, hold);
                    createdHoldIds.add(hold.getHoldId());
                    this.addExecutionLog(this.iu.getFormattedString("VaultAddHoldsOperation.Log.CreatedHold", new Object[]{hold.getName(), hold.getHoldId()}));
                    if (hold.getAccounts() != null && !hold.getAccounts().isEmpty()) {
                        for (HeldAccount heldAccount : hold.getAccounts()) {
                            if (heldAccount.getEmail() == null) continue;
                            addedLocations.add(heldAccount.getEmail().trim());
                        }
                    } else if (hold.getOrgUnit() != null && hold.getOrgUnit().getOrgUnitId() != null) {
                        addedLocations.add(hold.getOrgUnit().getOrgUnitId().trim());
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Could not create hold, " + hold.toString(), (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("VaultAddHoldsOperation.Warning.CouldNotCreateHold", new Object[]{hold.toUserPrintableString(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    ++failedToCreateHoldsCount;
                    holdConsumptions.remove(holdId);
                }
                this.processedItems.getAndIncrement();
            }
            for (List consumedLocations : holdConsumptions.values()) {
                this.consumptionLocations.addAll(consumedLocations);
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultAddHoldsOperation.Log.CreatedHolds", (long)createdHoldIds.size()));
            this.addExecutionLog(this.iu.getNumeralString("VaultAddHoldsOperation.Log.AddedLocations", (long)addedLocations.size()));
            if (failedToCreateHoldsCount > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("VaultAddHoldsOperation.Log.FailedToCreateHolds", failedToCreateHoldsCount));
            }
            this.concatenateToCollectionJson("{vault_hold_ids}", createdHoldIds);
            this.concatenateToCollectionJson("{vault_hold_locations}", addedLocations);
        });
    }

    private String getHoldId(VaultLocation holdLocation) {
        Object holdId = holdLocation.getCorpusType().toLocalizedString() + "/" + holdLocation.getSearchMethod().toLocalizedString();
        holdId = String.join((CharSequence)"", ((String)holdId).split(" "));
        if (holdLocation.getSearchMethod() == SearchMethod.ORG_UNIT) {
            holdId = (String)holdId + " " + holdLocation.getValue().trim();
        }
        return holdId;
    }

    private VaultHold buildVaultHold(VaultLocation holdLocation) {
        VaultHold hold = new VaultHold();
        hold.setCorpus(holdLocation.getCorpusType());
        switch (holdLocation.getSearchMethod()) {
            case ACCOUNT: {
                hold.setAccounts(new ArrayList());
                break;
            }
            case ORG_UNIT: {
                hold.setOrgUnit(new HeldOrgUnit());
            }
        }
        HeldQuery heldQuery = new HeldQuery();
        hold.setQuery(heldQuery);
        switch (hold.getCorpus()) {
            case MAIL: {
                heldQuery.setMailQuery(this.mailQuery);
                break;
            }
            case GROUPS: {
                heldQuery.setGroupsQuery(this.groupsQuery);
                break;
            }
            case DRIVE: {
                heldQuery.setDriveQuery(this.driveQuery);
                break;
            }
            case HANGOUTS_CHAT: {
                heldQuery.setHangoutsChatQuery(this.hangoutsChatQuery);
                break;
            }
            case VOICE: {
                heldQuery.setVoiceQuery(this.voiceQuery);
            }
        }
        return hold;
    }

    private boolean validateHoldLocation(int i, VaultLocation holdLocation) {
        if (holdLocation.getCorpusType() == null || holdLocation.getSearchMethod() == null) {
            this.addWarning(this.iu.getFormattedString("VaultAddHoldsOperation.Warning.InvalidHoldLocation", (Object)i));
            return false;
        }
        if (holdLocation.getSearchMethod() != SearchMethod.ACCOUNT && holdLocation.getSearchMethod() != SearchMethod.ORG_UNIT) {
            this.addWarning(this.iu.getFormattedString("VaultAddHoldsOperation.Warning.InvalidHoldType", new Object[]{i, holdLocation.getSearchMethod()}));
            return false;
        }
        if (holdLocation.getValue() == null || holdLocation.getValue().trim().isEmpty()) {
            this.addWarning(this.iu.getFormattedString("VaultAddHoldsOperation.Warning.InvalidHoldLocationMissingValue", (Object)i));
            return false;
        }
        return true;
    }

    private void populateOptions() {
        String startTime = null;
        String endTime = null;
        if (this.useDateRange) {
            startTime = FormattingUtils.dateTimeToIsoString((DateTime)new DateTime((Object)this.startDate));
            endTime = FormattingUtils.dateTimeToIsoString((DateTime)new DateTime((Object)this.endDate));
        }
        HashMap<CorpusType, String> serviceQueryTerms = new HashMap<CorpusType, String>();
        for (QueryTerm queryTerm : this.queryTerms) {
            serviceQueryTerms.putIfAbsent(queryTerm.getCorpusType(), queryTerm.getValue());
        }
        this.mailQuery = new HeldMailQuery();
        this.mailQuery.setTerms((String)serviceQueryTerms.get(CorpusType.MAIL));
        this.mailQuery.setStartTime(startTime);
        this.mailQuery.setEndTime(endTime);
        this.groupsQuery = new HeldGroupsQuery();
        this.groupsQuery.setTerms((String)serviceQueryTerms.get(CorpusType.GROUPS));
        this.groupsQuery.setStartTime(startTime);
        this.groupsQuery.setEndTime(endTime);
        this.driveQuery = new HeldDriveQuery();
        this.driveQuery.setIncludeSharedDriveFiles(this.includeSharedDriveFiles);
        this.hangoutsChatQuery = new HeldHangoutsChatQuery();
        this.hangoutsChatQuery.setIncludeRooms(this.includeChatRooms);
        this.voiceQuery = this.executionContext.evalJsonParameter("{vault_hold_voice_options}", HeldVoiceQuery.class, this);
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(3.0);
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = super.getPrintablePercentageComplete();
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            if (this.stageId == 1.0) {
                result = (String)result + this.iu.getNumeralString("VaultAddHoldsOperation.Progress.ItemsProcessed", this.processedItems.get());
            }
        }
        return result;
    }
}

