/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.VaultService;
import com.nuix.automate.utils.models.internal.vault.VaultMatter;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultConfigureConnectionOperation;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.List;
import java.util.Map;

public class VaultConfigureConnectionOperationImplementation
extends VaultConfigureConnectionOperation
implements ThirdPartyServiceOperation {
    private transient Map<String, ThirdPartyService> thirdPartyServices;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), VaultService.class.getSimpleName(), ParameterType.VAULT_SERVICE);
            this.stageName = this.iu.getString("VaultConfigureConnectionOperation.Stage.InitializingRestClient");
            this.vaultServiceId = this.executionContext.evalParameters(this.vaultServiceId, this);
            VaultService vaultService = (VaultService)this.thirdPartyServices.get(this.vaultServiceId);
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_service_id}", this.vaultServiceId)));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{vault_whitelisted_cert_fingerprints}", SerializationUtils.toJson((Object)vaultService.getWhitelistedCertFingerprints()))));
            this.initializeVaultRestClient();
            this.stageName = this.iu.getString("VaultConfigureConnectionOperation.Stage.TestingRestClient");
            this.percentageComplete = 0.3;
            this.addExecutionLog(this.iu.getFormattedString("VaultConfigureConnectionOperation.Log.VaultUser", (Object)vaultService.getUserCredential().getUsername()));
            this.percentageComplete = 0.6;
            List<VaultMatter> vaultMatters = this.vaultRestClient.getMatters(null);
            this.addExecutionLog(this.iu.getNumeralString("VaultConfigureConnectionOperation.Log.FoundMatters", (long)vaultMatters.size()));
        });
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

