/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.models.internal.vault.QueryTerm;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.query.DataScope;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

@FormFieldRow(name="dateRangeRow", children={"startDate", "endDate"}, enableOn={@OnField(name="useDateRange")})
@FormFieldGroups(value={@FormFieldGroup(name="useDateRangeGroup", children={"useDateRange", "timezone", "dateRangeRow"}), @FormFieldGroup(name="queryLocationsAndTermsGroup", children={"useQueryFiles", "queryFilesGroup", "queryInputsGroup"}), @FormFieldGroup(name="queryFilesGroup", children={"queryLocationsFilePath", "queryTermsFilePath"}, styled=false, visibleOn={@OnField(name="useQueryFiles")}), @FormFieldGroup(name="queryInputsGroup", children={"queryLocations", "queryTerms"}, styled=false, visibleOn={@OnField(name="useQueryFiles", value={"false"})})})
@OperationMetadata(alias=OperationAlias.VAULT_CREATE_SAVED_QUERIES, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"GOOGLE_VAULT"}), @OperationTag(name="Category", value={"SEARCH"})})
@OperationParameter(label="savedQueryIds", parameter="{vault_saved_query_ids}")
@OperationLicenseModule(module=ModuleType.GOOGLE_COLLECTIONS)
public class VaultCreateSavedQueriesOperation
extends VaultOperation {
    @FormField
    protected String queryNamePrefix = "";
    @FormField(excludeValues={"DATA_SCOPE_UNSPECIFIED"})
    protected DataScope queryDataScope = DataScope.ALL_DATA;
    @FormField
    protected boolean useDateRange = false;
    @FormField(enableOn={@OnField(name="useDateRange")}, componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.TIMEZONE_IDS)
    protected String timezone = TimeZone.getDefault().getID();
    @FormField(positionLabel=@PositionLabel(left="startDate"))
    protected Date startDate;
    @FormField(positionLabel=@PositionLabel(left="endDate"))
    protected Date endDate;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    protected boolean useQueryFiles;
    @FormField
    protected String queryLocationsFilePath;
    @FormField
    protected String queryTermsFilePath;
    @FormField(componentType=FieldComponentType.OBJECT_TABLE)
    @ExcludeFromPrintableOptions
    protected List<VaultLocation> queryLocations = new ArrayList<VaultLocation>();
    @FormField(componentType=FieldComponentType.OBJECT_TABLE, required=false)
    @ExcludeFromPrintableOptions
    protected List<QueryTerm> queryTerms = new ArrayList<QueryTerm>();

    public boolean getDisplayTimezone() {
        return this.useDateRange;
    }

    public boolean getDisplayStartDate() {
        return this.useDateRange;
    }

    public boolean getDisplayEndDate() {
        return this.useDateRange;
    }

    public boolean getDisplayQueryLocations() {
        return !this.useQueryFiles;
    }

    public boolean getDisplayQueryTerms() {
        return !this.useQueryFiles;
    }

    public VaultCreateSavedQueriesOperation() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(this.timezone));
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 0);
        this.endDate = calendar.getTime();
        calendar.set(1, calendar.get(1) - 10);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.startDate = calendar.getTime();
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.queryNamePrefix == null || this.queryNamePrefix.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VaultCreateSavedQueriesOperation.Prerequisites.QueryNamePrefixRequired"));
            }
            if (this.queryDataScope == null || this.queryDataScope == DataScope.DATA_SCOPE_UNSPECIFIED) {
                prerequisites.add(this.iu.getString("VaultCreateSavedQueriesOperation.Prerequisites.QueryDataScopeRequired"));
            }
            if (this.useQueryFiles && (this.queryLocationsFilePath == null || this.queryLocationsFilePath.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VaultCreateSavedQueriesOperation.Prerequisites.QueryLocationsFilePathRequired"));
            }
            if (this.useQueryFiles && (this.queryTermsFilePath == null || this.queryTermsFilePath.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VaultCreateSavedQueriesOperation.Prerequisites.QueryTermsFilePathRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(VaultSetMatterOperation.class));
        return prerequisites;
    }
}

