/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.vault.export.DriveExportOptions;
import com.nuix.automate.utils.models.internal.vault.export.ExportFormat;
import com.nuix.automate.utils.models.internal.vault.export.ExportRegion;
import com.nuix.automate.utils.models.internal.vault.export.MailExportOptions;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultExportsOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.VAULT_EXPORT_SAVED_QUERIES, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"GOOGLE_VAULT"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationParameter(label="exportIds", parameter="{vault_export_ids}")
@OperationLicenseModule(module=ModuleType.GOOGLE_COLLECTIONS)
public class VaultExportSavedQueriesOperation
extends VaultExportsOperation {
    @FormField
    protected String exportNamePrefix;
    @FormField(excludeValues={"EXPORT_REGION_UNSPECIFIED"})
    protected ExportRegion exportRegion = ExportRegion.ANY;
    @FormField(excludeValues={"EXPORT_FORMAT_UNSPECIFIED"})
    protected ExportFormat exportFormat = ExportFormat.MBOX;
    @FormField
    protected MailExportOptions mailExportOptions = new MailExportOptions();
    @FormField
    protected DriveExportOptions driveExportOptions = new DriveExportOptions();
    @FormField
    @ExcludeFromPrintableOptions
    protected ObjectIdentifierType savedQueryIdentifierType = ObjectIdentifierType.ID;
    @FormField
    protected Set<String> savedQueryIdentifiers = new HashSet<String>();
    @FormField
    public boolean waitForCompletion;

    public VaultExportSavedQueriesOperation() {
        this.savedQueryIdentifiers.add("{vault_saved_query_ids}");
        this.waitForCompletion = true;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.exportNamePrefix == null || this.exportNamePrefix.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("VaultExportSavedQueriesOperation.Prerequisites.ExportNamePrefixRequired"));
            }
            if (this.savedQueryIdentifierType == null || this.savedQueryIdentifiers == null || this.savedQueryIdentifiers.stream().allMatch(String::isEmpty)) {
                prerequisites.add(this.iu.getString("VaultExportSavedQueriesOperation.Prerequisites.SavedQueryIdentifiersRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(VaultSetMatterOperation.class));
        return prerequisites;
    }
}

