/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.QueryTerm;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.OperationRunnable;
import com.nuix.automate.workflow.core.utils.vault.VaultOperationException;
import com.nuix.automate.workflow.core.utils.vault.VaultRestClient;
import com.nuix.automate.workflow.core.utils.vault.VaultRestException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public abstract class VaultOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultOperation.class);
    protected transient String vaultMatterId;
    protected transient VaultRestClient vaultRestClient;
    protected transient int operationPollingDelay;
    protected transient int parallelThreads;
    protected transient String stageName;
    protected transient double stageId;
    protected transient double stageCount;
    protected transient long stageItems;
    protected transient AtomicLong processedItems;
    protected transient double percentageComplete;
    protected List<VaultLocation> consumptionLocations;

    public VaultOperation() {
        this.requiresCase = false;
        this.operationPollingDelay = SystemUtils.getIntegerProperty((String)"automate.vault.operationPollingDelay", (Integer)30);
        this.parallelThreads = SystemUtils.getIntegerProperty((String)"automate.vault.parallelThreads", (Integer)4);
    }

    protected void initialize() throws ParameterException, GeneralSecurityException {
        this.vaultMatterId = this.executionContext.evalParameters("{vault_matter_id}", this);
        this.initializeVaultRestClient();
    }

    protected void initializeVaultRestClient() throws ParameterException, GeneralSecurityException {
        String vaultServiceId = this.executionContext.evalParametersIfSet("{vault_service_id}", this);
        String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this).trim();
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        try {
            whitelistedCertFingerprints.addAll((Collection)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{vault_whitelisted_cert_fingerprints}", this)));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        try {
            whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this).trim());
        }
        catch (ParameterException e) {
            LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
        }
        this.vaultRestClient = new VaultRestClient(vaultServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.vaultRestClient.setOperation(this);
    }

    protected Set<String> normalizeListIdentifiers(Set<String> identifiers) {
        HashSet<String> normalizedIdentifiers = new HashSet<String>();
        for (String identifier : identifiers) {
            normalizedIdentifiers.addAll(this.executionContext.evalOneOrManyStringParameter(identifier, this));
        }
        return normalizedIdentifiers;
    }

    protected <T extends VaultObject> Map<String, T> filterVaultObjects(ObjectIdentifierType identifierType, Collection<String> identifiers, List<T> vaultObjects, Function<T, String> idGenerator, Function<T, String> nameGenerator) throws VaultRestException {
        HashMap<String, VaultObject> result = new HashMap<String, VaultObject>();
        switch (identifierType) {
            case ID: {
                for (VaultObject obj : vaultObjects) {
                    String id = idGenerator.apply(obj);
                    if (!identifiers.contains(id)) continue;
                    result.put(id, obj);
                }
                break;
            }
            case NAME: {
                for (VaultObject obj : vaultObjects) {
                    String name = nameGenerator.apply(obj);
                    if (!identifiers.contains(name)) continue;
                    result.put(idGenerator.apply(obj), obj);
                }
                break;
            }
            case NAME_REGEX: {
                for (String nameRegex : identifiers) {
                    List<VaultObject> matchingObjects = VaultRestClient.getObjectsForNameRegex(nameRegex, vaultObjects, nameGenerator);
                    for (VaultObject matchingObject : matchingObjects) {
                        result.put(idGenerator.apply(matchingObject), matchingObject);
                    }
                }
                break;
            }
        }
        return result;
    }

    protected void testOperationConsumption(Collection<List<VaultLocation>> locationsList) {
        try {
            ArrayList<VaultLocation> consumptions = new ArrayList<VaultLocation>();
            for (List<VaultLocation> locations : locationsList) {
                consumptions.addAll(locations);
            }
            this.convertVaultUserLocationsToIds(consumptions);
        }
        catch (IOException e) {
            LOGGER.error("Error testing operation consumption", (Throwable)e);
            throw new VaultOperationException(this.iu.getFormattedString("VaultOperation.Error.ErrorComputingVaultOperationConsumption", (Object)e));
        }
    }

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = new Consumption();
        this.addUserLocationsConsumptionEvent(consumption);
        if (!consumption.getConsumptionEvents().isEmpty()) {
            return consumption;
        }
        return null;
    }

    private void addUserLocationsConsumptionEvent(Consumption consumption) {
        if (this.consumptionLocations != null) {
            if (this.consumptionLocations.isEmpty()) {
                LOGGER.warn("Vault operation " + String.valueOf(this) + " does not have locations");
            } else {
                HashSet<String> consumptionLocationIds = new HashSet<String>();
                try {
                    consumptionLocationIds.addAll(this.convertVaultUserLocationsToIds(this.consumptionLocations));
                }
                catch (IOException e) {
                    LOGGER.error("Could not get consumption IDs for " + String.valueOf(this) + " locations");
                    for (VaultLocation location : this.consumptionLocations) {
                        switch (location.getSearchMethod()) {
                            case ACCOUNT: 
                            case ORG_UNIT: {
                                consumptionLocationIds.add(location.getValue());
                            }
                        }
                    }
                }
                ConsumptionEvent consumptionEvent = new ConsumptionEvent();
                consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
                consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
                consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
                if (this.finishedDateTime != null) {
                    consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
                } else {
                    consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
                }
                consumptionEvent.setPlatformType(ConsumptionPlatformType.GOOGLE_VAULT);
                try {
                    consumptionEvent.setPlatformId(this.vaultRestClient.getDomain());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot get Google Vault domain", (Throwable)e);
                }
                consumptionEvent.setConsumptionType(ConsumptionType.CUSTODIAN_USED);
                consumptionEvent.setUnitType(UnitType.CUSTODIANS);
                consumptionEvent.setResourceType(ResourceType.VAULT_MATTER_ID);
                consumptionEvent.setResourceId(this.vaultMatterId);
                consumptionEvent.setResourceSubType(ResourceSubType.CUSTODIAN_IDS);
                consumptionEvent.setResourceSubId(SerializationUtils.toJson(consumptionLocationIds));
                if (this.executionContext.getEngine() != null) {
                    consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
                }
                consumption.addConsumptionEvents(consumptionEvent, consumptionLocationIds);
            }
        }
    }

    private Set<String> convertVaultUserLocationsToIds(List<VaultLocation> locations) throws IOException {
        HashSet<String> userEmails = new HashSet<String>();
        HashSet<String> groupEmails = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashSet<String> chatSpaceIds = new HashSet<String>();
        boolean entireOrg = false;
        for (VaultLocation location : locations) {
            switch (location.getSearchMethod()) {
                case ACCOUNT: {
                    if (location.getCorpusType() == CorpusType.GROUPS) {
                        groupEmails.add(location.getValue());
                        break;
                    }
                    userEmails.add(location.getValue());
                    break;
                }
                case ORG_UNIT: {
                    orgUnitIds.add(location.getValue());
                    break;
                }
                case ROOM: {
                    if (location.getCorpusType() != CorpusType.HANGOUTS_CHAT) break;
                    chatSpaceIds.add(location.getValue());
                    break;
                }
                case ENTIRE_ORG: {
                    entireOrg = true;
                }
            }
        }
        HashSet<String> userIds = new HashSet<String>();
        if (entireOrg) {
            userIds.addAll(this.vaultRestClient.getAllUserIds());
        }
        if (!groupEmails.isEmpty()) {
            userIds.addAll(this.vaultRestClient.getUserIdsFromGroups(groupEmails));
        }
        if (!userEmails.isEmpty()) {
            userIds.addAll(this.vaultRestClient.getUserIdsFromEmails(userEmails));
        }
        if (!orgUnitIds.isEmpty()) {
            userIds.addAll(this.vaultRestClient.getUserIdsForOrgUnits(orgUnitIds));
        }
        if (!chatSpaceIds.isEmpty()) {
            for (String chatSpaceId : chatSpaceIds) {
                userIds.addAll(this.vaultRestClient.getUserIdsForChatSpace(chatSpaceId));
            }
        }
        return userIds;
    }

    protected List<VaultLocation> readVaultLocationsFile(String fileLocation) throws IOException {
        Path vaultLocationsPath = Paths.get(fileLocation, new String[0]);
        if (!Files.exists(vaultLocationsPath, new LinkOption[0])) {
            String errorMessage = this.iu.getFormattedString("VaultOperation.Error.VaultLocationsFileDoesNotExist", (Object)fileLocation);
            throw new VaultOperationException(errorMessage);
        }
        CsvFileResult vaultLocationsFile = this.readVaultCsvFile(vaultLocationsPath);
        LOGGER.info("Detected vault locations file with startIndex " + vaultLocationsFile.startIndex);
        ArrayList<VaultLocation> queryLocations = new ArrayList<VaultLocation>();
        for (int i = vaultLocationsFile.startIndex; i < vaultLocationsFile.lines.size(); ++i) {
            queryLocations.add(VaultLocation.build((Object[])vaultLocationsFile.lines.get(i)));
        }
        return queryLocations;
    }

    protected List<QueryTerm> readQueryTermsFile(String fileLocation) throws IOException {
        Path queryTermsPath = Paths.get(fileLocation, new String[0]);
        if (!Files.exists(queryTermsPath, new LinkOption[0])) {
            String errorMessage = this.iu.getFormattedString("VaultOperation.Error.QueryTermsFileDoesNotExist", (Object)fileLocation);
            throw new VaultOperationException(errorMessage);
        }
        CsvFileResult queryTermsFile = this.readVaultCsvFile(queryTermsPath);
        LOGGER.info("Detected query terms file with startIndex " + queryTermsFile.startIndex);
        ArrayList<QueryTerm> queryTerms = new ArrayList<QueryTerm>();
        for (int i = queryTermsFile.startIndex; i < queryTermsFile.lines.size(); ++i) {
            queryTerms.add(QueryTerm.build((Object[])queryTermsFile.lines.get(i)));
        }
        return queryTerms;
    }

    protected CsvFileResult readVaultCsvFile(Path filePath) throws IOException {
        Object[] line;
        CsvFileResult csvFileResult = new CsvFileResult();
        csvFileResult.lines = FileUtils.loadVariableColumnDetectFormatFile((File)filePath.toFile());
        csvFileResult.startIndex = 0;
        if (!csvFileResult.lines.isEmpty() && (line = csvFileResult.lines.get(0)).length > 0) {
            try {
                CorpusType.normalizeType((String)((String)line[0]));
                csvFileResult.startIndex = 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return csvFileResult;
    }

    @Override
    protected void runStartTriggeredThread(OperationRunnable operationRunnable) {
        this.startTriggerThread = new Thread(() -> {
            try {
                operationRunnable.run();
                this.trackFinished();
            }
            catch (ThirdPartyRestException | VaultOperationException e) {
                LOGGER.error("Error during " + this.getOperationName(), e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public String getOperationName() {
        String className = this.getClass().getSimpleName().replace("Implementation", "");
        return this.iu.getString(className + ".Property.Name");
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    protected double getProcessedItemsPercentageComplete(double stageMultiplier) {
        return this.getProcessedItemsPercentageComplete(0.0, stageMultiplier);
    }

    protected double getProcessedItemsPercentageComplete(double startingStageId, double stageMultiplier) {
        double stageProgress = 0.0;
        if (this.stageId >= startingStageId && this.processedItems != null && this.stageItems > 0L) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        stageProgress *= stageMultiplier;
        double percentageComplete = 0.0;
        if (this.stageCount > 0.0) {
            percentageComplete = (stageProgress + this.stageId) / this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    protected static class CsvFileResult {
        List<Object[]> lines;
        int startIndex;

        protected CsvFileResult() {
        }
    }
}

