/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.VaultOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.general.ObjectIdentifierType;
import com.nuix.automate.workflow.core.execution.options.vault.HoldLocationsInputType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="holdLocationsInputTypeRadioButtonGroup", radioButton="holdLocationsInputType", values={@RadioButtonValue(value="ALL_LOCATIONS"), @RadioButtonValue(component="holdLocationsFilePath", value="FILE"), @RadioButtonValue(component="holdLocations", value="VALUES")})
@FormFieldGroup(name="holdIdentifiersGroup", styled=false, children={"removeFromAllHolds", "holdIdentifierType", "holdIdentifiers"})
@OperationMetadata(alias=OperationAlias.VAULT_REMOVE_LOCATIONS_FROM_HOLDS, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"GOOGLE_VAULT"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.GOOGLE_HOLD)
public class VaultRemoveLocationsFromHoldsOperation
extends VaultOperation {
    @FormField
    protected HoldLocationsInputType holdLocationsInputType = HoldLocationsInputType.VALUES;
    @FormField(enableOn={@OnField(name="holdLocationsInputType", value={"FILE"})})
    protected String holdLocationsFilePath;
    @FormField(keepLabel=true, enableOn={@OnField(name="holdLocationsInputType", value={"VALUES"})})
    protected Set<String> holdLocations = new HashSet<String>();
    @FormField
    protected boolean removeFromAllHolds;
    @FormField(enableOn={@OnField(name="removeFromAllHolds", value={"false"})})
    @ExcludeFromPrintableOptions
    protected ObjectIdentifierType holdIdentifierType;
    @FormField(enableOn={@OnField(name="removeFromAllHolds", value={"false"})})
    protected Set<String> holdIdentifiers;

    public boolean getDisplayHoldLocationsFilePath() {
        return this.holdLocationsInputType == HoldLocationsInputType.FILE;
    }

    public VaultRemoveLocationsFromHoldsOperation() {
        this.holdLocations.add("{vault_hold_locations}");
        this.holdIdentifierType = ObjectIdentifierType.ID;
        this.holdIdentifiers = new HashSet<String>();
        this.holdIdentifiers.add("{vault_hold_ids}");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.holdLocationsInputType == HoldLocationsInputType.VALUES && (this.holdLocations == null || this.holdLocations.isEmpty())) {
                prerequisites.add(this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Prerequisites.HoldLocationsRequired"));
            }
            if (this.holdLocationsInputType == HoldLocationsInputType.FILE && (this.holdLocationsFilePath == null || this.holdLocationsFilePath.trim().isEmpty())) {
                prerequisites.add(this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Prerequisites.HoldLocationsFilePathRequired"));
            }
            if (!this.removeFromAllHolds && (this.holdIdentifierType == null || this.holdIdentifiers == null || this.holdIdentifiers.isEmpty())) {
                prerequisites.add(this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Prerequisites.HoldIdentifiersRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(VaultSetMatterOperation.class));
        return prerequisites;
    }
}

