/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.vault.VaultHold;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.VaultObject;
import com.nuix.automate.utils.models.internal.vault.hold.HeldOrgUnit;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.VaultRemoveLocationsFromHoldsOperation;
import com.nuix.automate.workflow.core.execution.options.vault.HoldLocationsInputType;
import com.nuix.automate.workflow.core.utils.vault.VaultOperationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class VaultRemoveLocationsFromHoldsOperationImplementation
extends VaultRemoveLocationsFromHoldsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultRemoveLocationsFromHoldsOperation.class);

    @Override
    public void startTriggered() {
        this.stageCount = 4.0;
        this.stageId = 0.0;
        this.consumptionLocations = new ArrayList();
        this.runStartTriggeredThread(() -> {
            List<VaultHold> holds;
            this.initialize();
            this.holdIdentifiers = this.normalizeListIdentifiers(this.holdIdentifiers);
            this.stageName = this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Stage.GettingHolds");
            if (this.holdLocationsInputType == HoldLocationsInputType.FILE) {
                this.holdLocationsFilePath = this.executionContext.evalParameters(this.holdLocationsFilePath, this);
                this.addExecutionLog(this.iu.getFormattedString("VaultRemoveLocationsFromHoldsOperation.Log.HoldLocationsFile", (Object)this.holdLocationsFilePath));
                this.holdLocations = this.readHoldLocationsFile(this.holdLocationsFilePath);
            } else if (this.holdLocationsInputType == HoldLocationsInputType.VALUES) {
                this.holdLocations = this.normalizeListIdentifiers(this.holdLocations);
            }
            this.holdLocations.removeIf(location -> location == null || location.trim().isEmpty());
            if (this.holdLocationsInputType != HoldLocationsInputType.ALL_LOCATIONS && this.holdLocations.isEmpty()) {
                this.addWarning(this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Log.NoHoldLocations"));
                return;
            }
            try {
                this.vaultRestClient.getOrgUnits();
            }
            catch (IOException e) {
                LOGGER.error("Error testing operation consumption", (Throwable)e);
                throw new VaultOperationException(this.iu.getFormattedString("VaultOperation.Error.ErrorComputingVaultOperationConsumption", (Object)e));
            }
            List<VaultHold> allHolds = this.vaultRestClient.getHolds(this.vaultMatterId);
            if (this.removeFromAllHolds) {
                holds = allHolds;
            } else {
                Map<String, VaultHold> holdsMap = this.filterVaultObjects(this.holdIdentifierType, this.holdIdentifiers, allHolds, VaultHold::getHoldId, VaultObject::getName);
                holds = new ArrayList<VaultHold>(holdsMap.values());
            }
            if (holds.isEmpty()) {
                this.addWarning(this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Log.CouldNotFindHolds"));
                return;
            }
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.stageId = 1.0;
            this.stageName = this.iu.getString("VaultRemoveLocationsFromHoldsOperation.Stage.RemovingLocations");
            this.stageItems = holds.size();
            this.processedItems = new AtomicLong();
            HashSet<String> locationsRemoved = new HashSet<String>();
            int holdsDeletedCount = 0;
            int failedToRemoveLocationsFromHoldCount = 0;
            for (VaultHold hold : holds) {
                try {
                    ArrayList<VaultLocation> consumptionsRemoved = new ArrayList<VaultLocation>();
                    switch (hold.getSearchMethod()) {
                        case ACCOUNT: {
                            if (hold.getAccounts() == null) break;
                            HashSet<String> accountIdsToRemove = new HashSet<String>();
                            hold.getAccounts().removeIf(heldAccount -> {
                                String email = FormattingUtils.getNonEmptyTrimmedText((String)heldAccount.getEmail());
                                if (this.holdLocationsInputType == HoldLocationsInputType.ALL_LOCATIONS || email != null && this.holdLocations.contains(email)) {
                                    locationsRemoved.add(email);
                                    accountIdsToRemove.add(heldAccount.getAccountId());
                                    consumptionsRemoved.add(new VaultLocation(hold.getCorpus(), SearchMethod.ACCOUNT, email));
                                    return true;
                                }
                                return false;
                            });
                            if (hold.getAccounts().isEmpty()) {
                                this.vaultRestClient.deleteHold(this.vaultMatterId, hold.getHoldId());
                                ++holdsDeletedCount;
                                this.addExecutionLog(this.iu.getFormattedString("VaultRemoveLocationsFromHoldsOperation.Log.DeletedHold", (Object)hold.getName()));
                                break;
                            }
                            if (accountIdsToRemove.isEmpty()) break;
                            this.vaultRestClient.removeHeldAccountsFromHold(this.vaultMatterId, hold.getHoldId(), accountIdsToRemove);
                            break;
                        }
                        case ORG_UNIT: {
                            HeldOrgUnit heldOrgUnit = hold.getOrgUnit();
                            if (heldOrgUnit == null) break;
                            String orgUnitId = FormattingUtils.getNonEmptyTrimmedText((String)heldOrgUnit.getOrgUnitId());
                            if (this.holdLocationsInputType != HoldLocationsInputType.ALL_LOCATIONS && (orgUnitId == null || !this.holdLocations.contains(orgUnitId))) break;
                            this.vaultRestClient.deleteHold(this.vaultMatterId, hold.getHoldId());
                            locationsRemoved.add(orgUnitId);
                            consumptionsRemoved.add(new VaultLocation(hold.getCorpus(), SearchMethod.ORG_UNIT, orgUnitId));
                            ++holdsDeletedCount;
                            this.addExecutionLog(this.iu.getFormattedString("VaultRemoveLocationsFromHoldsOperation.Log.DeletedHold", (Object)hold.getName()));
                        }
                    }
                    this.consumptionLocations.addAll(consumptionsRemoved);
                }
                catch (Exception e) {
                    this.addWarning(this.iu.getFormattedString("VaultRemoveLocationsFromHoldsOperation.Warning.CouldNotRemoveLocationsFromHold", new Object[]{hold, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    ++failedToRemoveLocationsFromHoldCount;
                }
                this.processedItems.getAndIncrement();
            }
            HashSet locationsRemaining = new HashSet(this.holdLocations);
            locationsRemaining.removeAll(locationsRemoved);
            this.addExecutionLog(this.iu.getNumeralString("VaultRemoveLocationsFromHoldsOperation.Log.RemovedLocations", (long)locationsRemoved.size()));
            if (!locationsRemaining.isEmpty()) {
                this.addWarning(this.iu.getNumeralString("VaultRemoveLocationsFromHoldsOperation.Warning.CouldNotFindLocations", (long)locationsRemaining.size()));
            }
            if (holdsDeletedCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("VaultRemoveLocationsFromHoldsOperation.Log.DeletedHolds", (long)holdsDeletedCount));
            }
            if (failedToRemoveLocationsFromHoldCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("VaultRemoveLocationsFromHoldsOperation.Log.FailedToRemoveLocationsFromHolds", (long)failedToRemoveLocationsFromHoldCount));
            }
        });
    }

    private Set<String> readHoldLocationsFile(String fileLocation) throws IOException {
        Path holdLocationsFilePath = Paths.get(fileLocation, new String[0]);
        if (!Files.exists(holdLocationsFilePath, new LinkOption[0])) {
            String errorMessage = this.iu.getFormattedString("VaultRemoveLocationsFromHoldsOperation.Error.HoldLocationsFileDoesNotExist", (Object)fileLocation);
            throw new VaultOperationException(errorMessage);
        }
        HashSet<String> holdLocations = new HashSet<String>();
        for (Object[] line : FileUtils.loadVariableColumnDetectFormatFile((File)holdLocationsFilePath.toFile())) {
            if (line.length <= 0) continue;
            holdLocations.add((String)line[0]);
        }
        return holdLocations;
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(3.0);
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = super.getPrintablePercentageComplete();
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            if (this.stageId == 1.0) {
                result = (String)result + this.iu.getNumeralString("VaultRemoveLocationsFromHoldsOperation.Progress.ItemsProcessed", this.processedItems.get());
            }
        }
        return result;
    }
}

