/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.export.ExportStatus;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.VaultExportsOperation;
import com.nuix.automate.workflow.core.execution.operations.VaultSetExportsOperation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class VaultSetExportsOperationImplementation
extends VaultSetExportsOperation {
    @Override
    public void startTriggered() {
        this.stageId = 0.0;
        this.stageCount = 2.0;
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.exportIdentifiers = this.normalizeListIdentifiers(this.exportIdentifiers);
            this.stageName = this.iu.getString("VaultSetExportsOperation.Stage.GettingExports");
            this.stageId = 0.2;
            VaultExportsOperation.FilteredResult<VaultExport> result = this.getFilteredVaultExports(this.exportIdentifierType, this.exportIdentifiers, this.includeLinkedExports);
            List exports = result.values;
            Set<String> exportIds = result.ids;
            if (exports.isEmpty()) {
                this.addWarning(this.iu.getString("VaultSetExportsOperation.Log.CouldNotFindExports"));
                return;
            }
            this.addExecutionLog(this.iu.getNumeralString("VaultSetExportsOperation.Log.FoundExports", (long)exports.size()));
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.processedItems = new AtomicLong();
            this.stageId = 0.5;
            if (this.waitForCompletion) {
                HashSet<String> remainingExportIds = new HashSet<String>();
                for (VaultExport export : exports) {
                    if (export.getStatus() != ExportStatus.IN_PROGRESS) continue;
                    remainingExportIds.add(export.getId());
                }
                if (!remainingExportIds.isEmpty()) {
                    this.stageName = this.iu.getString("VaultSetExportsOperation.Stage.WaitingForExports");
                    this.stageItems = remainingExportIds.size();
                    this.waitForExports(remainingExportIds, "Export");
                    this.waitForLinkedExports(exportIds);
                }
            }
            this.stageId = 2.0;
            this.concatenateToCollectionJson("{vault_export_ids}", exportIds);
        });
    }

    @Override
    protected double getPercentageComplete() {
        return this.getProcessedItemsPercentageComplete(0.5, 1.0);
    }
}

