/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneService;
import com.nuix.automate.utils.models.internal.veritone.EngineDetail;
import com.nuix.automate.utils.models.internal.veritone.OrganizationDetail;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.VeritoneConfigureConnectionOperation;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneOperationException;
import java.util.List;
import java.util.Map;

public class VeritoneConfigureConnectionOperationImplementation
extends VeritoneConfigureConnectionOperation {
    private transient Map<String, ThirdPartyService> thirdPartyServices;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), VeritoneService.class.getSimpleName(), ParameterType.VERITONE_SERVICE);
            this.stageName = this.iu.getString("VeritoneConfigureConnectionOperation.Stage.InitializingRestClient");
            this.veritoneServiceId = this.executionContext.evalParameters(this.veritoneServiceId, this);
            VeritoneService veritoneService = (VeritoneService)this.thirdPartyServices.get(this.veritoneServiceId);
            if (veritoneService == null) {
                throw new VeritoneOperationException(this.iu.getFormattedString("VeritoneConfigureConnectionOperation.Prerequisites.MissingVeritoneServiceId", new Object[0]));
            }
            this.percentageComplete = 0.3;
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{veritone_service_id}", this.veritoneServiceId)));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{veritone_whitelisted_cert_fingerprints}", SerializationUtils.toJson((Object)veritoneService.getWhitelistedCertFingerprints()))));
            this.stageName = this.iu.getString("VeritoneConfigureConnectionOperation.Stage.TestingRestClient");
            this.initializeVeritoneRestClient();
            this.percentageComplete = 0.6;
            List<OrganizationDetail> organizations = this.veritoneRestClient.getOrganizations();
            this.addExecutionLog(this.iu.getNumeralString("VeritoneConfigureConnectionOperation.Log.FoundOrganizations", (long)organizations.size()));
            List<EngineDetail> engines = this.veritoneRestClient.getEngines();
            this.addExecutionLog(this.iu.getNumeralString("VeritoneConfigureConnectionOperation.Log.FoundEngines", (long)engines.size()));
            if (veritoneService.getTranslationEngines() != null) {
                this.addExecutionLog(this.iu.getNumeralString("VeritoneConfigureConnectionOperation.Log.VeritoneServiceTranslationEngineCount", (long)veritoneService.getTranslationEngines().size()));
            }
            if (veritoneService.getTranscriptionEngines() != null) {
                this.addExecutionLog(this.iu.getNumeralString("VeritoneConfigureConnectionOperation.Log.VeritoneServiceTranscriptionEngineCount", (long)veritoneService.getTranscriptionEngines().size()));
            }
        });
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

