/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneService;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.execution.options.veritone.ItemVeritoneJob;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.OperationRunnable;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneOperationException;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneRestClient;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class VeritoneOperation
extends Operation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VeritoneOperation.class);
    protected static final String DEFAULT_SEPARATOR = "---";
    protected static final String VERITONE_PREFIX = "Veritone";
    protected static final String VERITONE_ERROR_METADATA = "System|Error";
    protected static final String VERITONE_WARNING_METADATA = "System|Warning";
    protected transient VeritoneRestClient veritoneRestClient;
    protected transient VeritoneService veritoneService;
    protected transient String fileDownloadToken;
    protected transient String jobId;
    protected transient Path jobFilesDirectory;
    protected transient String stageName;
    protected transient double stageId;
    protected transient double stageCount;
    protected transient long stageItems;
    protected transient AtomicLong processedItems;
    protected transient double percentageComplete;
    protected transient int operationPollingDelay = SystemUtils.getIntegerProperty((String)"automate.veritone.operationPollingDelay", (Integer)10);
    protected transient int parallelThreads = SystemUtils.getIntegerProperty((String)"automate.veritone.parallelThreads", (Integer)4);

    protected void initialize() throws ParameterException, GeneralSecurityException {
        this.initializeVeritoneRestClient();
    }

    protected void initializeVeritoneRestClient() throws ParameterException, GeneralSecurityException {
        String veritoneServiceId = this.executionContext.evalParametersIfSet("{veritone_service_id}", this);
        String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this).trim();
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        try {
            whitelistedCertFingerprints.addAll((Collection)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{veritone_whitelisted_cert_fingerprints}", this)));
        }
        catch (Exception e) {
            LOGGER.error("Error adding {veritone_whitelisted_cert_fingerprints}", (Throwable)e);
        }
        try {
            whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this).trim());
        }
        catch (ParameterException e) {
            LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
        }
        this.veritoneRestClient = new VeritoneRestClient(veritoneServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.veritoneRestClient.setOperation(this);
    }

    @Override
    protected void runStartTriggeredThread(OperationRunnable operationRunnable) {
        this.startTriggerThread = new Thread(() -> {
            try {
                operationRunnable.run();
                this.trackFinished();
            }
            catch (ThirdPartyRestException | VeritoneOperationException e) {
                LOGGER.error("Error during " + this.getOperationName(), e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    protected void cancelVeritoneJobIfRunning(ItemVeritoneJob veritoneJob) {
        if (veritoneJob.getJobId() != null && (veritoneJob.getJobStatus() == null || veritoneJob.getJobStatus().isRunning())) {
            try {
                LOGGER.info("Cancelling veritone job " + veritoneJob.getJobId());
                this.veritoneRestClient.cancelJob(veritoneJob.getJobId());
            }
            catch (IOException e) {
                LOGGER.error("Error cancelling veritone job " + veritoneJob.getJobId());
            }
        }
    }

    @Override
    public String getOperationName() {
        String className = this.getClass().getSimpleName().replace("Implementation", "");
        return this.iu.getString(className + ".Property.Name");
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    protected double getProcessedItemsPercentageComplete(double startingStageId, double stageMultiplier) {
        double stageProgress = 0.0;
        if (this.stageId >= startingStageId && this.processedItems != null && this.stageItems > 0L) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        stageProgress *= stageMultiplier;
        double percentageComplete = 0.0;
        if (this.stageCount > 0.0) {
            percentageComplete = (stageProgress + this.stageId) / this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        try {
            String veritoneServiceId = this.executionContext.evalParametersIfSet("{veritone_service_id}", this);
            this.veritoneService = (VeritoneService)thirdPartyServices.get(veritoneServiceId);
        }
        catch (ParameterException e) {
            LOGGER.error("Could not evaluate veritoneServiceId from {veritone_service_id}", (Throwable)e);
        }
    }
}

