/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.veritone.VeritoneEngine;
import com.nuix.automate.utils.models.internal.veritone.VeritoneTranscriptionEngine;
import com.nuix.automate.utils.models.internal.veritone.output.JobOutput;
import com.nuix.automate.utils.models.internal.veritone.output.TranscriptionJobOutputContents;
import com.nuix.automate.utils.models.internal.veritone.payload.FfmpegPayload;
import com.nuix.automate.utils.models.internal.veritone.payload.WebStreamPayload;
import com.nuix.automate.utils.models.internal.veritone.request.CreateJobRequest;
import com.nuix.automate.utils.models.internal.veritone.response.CreateJobResponse;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.VeritoneTranscribeOperation;
import com.nuix.automate.workflow.core.execution.operations.VeritoneTranslateItemsOperation;
import com.nuix.automate.workflow.core.execution.options.veritone.ItemVeritoneJob;
import com.nuix.automate.workflow.core.execution.options.veritone.TranscriptionTextFormat;
import com.nuix.automate.workflow.core.execution.options.veritone.VeritoneJobSaveAs;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import com.nuix.automate.workflow.core.utils.veritone.VeritoneOperationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nuix.BatchExporter;
import nuix.BulkAnnotater;
import nuix.ExportProcessingJob;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import nuix.ItemEventInfo;
import nuix.ItemModifier;
import nuix.LicenceException;
import nuix.ParallelProcessingConfigurable;
import nuix.ProcessingJob;

public class VeritoneTranscribeItemsOperationImplementation
extends VeritoneTranscribeOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VeritoneTranslateItemsOperation.class);
    private static final Pattern endsWithPunctutationPattern = Pattern.compile(".*\\p{Punct}");
    public String scope;
    public String targetLanguage;
    public TranscriptionTextFormat resultFormat;
    public VeritoneJobSaveAs saveResultAs;
    public boolean replaceText;
    public String customMetadataName;
    public boolean tagFailedItems;
    public String failedItemTagName;
    public boolean untagSuccessfulItems;
    private transient Integer workerMemory = null;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient String tempTag;
    private transient String textSeparator;
    private transient Set<Item> transcribedItems;
    private transient Set<Item> failedItems;
    private transient Long timestampedWordsGroupingMs;
    private transient Map<String, Integer> stageNameToId;
    private transient ExportProcessingJob exportProcessingJob;
    private transient boolean isPaused;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            try {
                this.timestampedWordsGroupingMs = this.executionContext.evalLongParameter("{veritone_transcription_words_grouping_ms}", this);
            }
            catch (ParameterException e) {
                LOGGER.error((Throwable)e);
            }
            if (this.timestampedWordsGroupingMs == null) {
                this.timestampedWordsGroupingMs = 500L;
            }
            this.stageCount = 1.0;
            this.stageId = 0.0;
            this.stageName = this.iu.getString("VeritoneTranscribeItemsOperation.Stage.PreparingItems");
            this.transcribedItems = ConcurrentHashMap.newKeySet();
            this.failedItems = ConcurrentHashMap.newKeySet();
            this.initialize();
            this.targetLanguage = this.executionContext.evalParameters(this.targetLanguage, this);
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TargetLanguage", (Object)this.targetLanguage));
            String transcriptionEngineKey = VeritoneEngine.getKey((String[])new String[]{this.targetLanguage});
            VeritoneTranscriptionEngine transcriptionEngine = null;
            if (this.veritoneService.getTranscriptionEngines() != null) {
                for (VeritoneTranscriptionEngine engine : this.veritoneService.getTranscriptionEngines()) {
                    if (!engine.getKey().equalsIgnoreCase(transcriptionEngineKey)) continue;
                    transcriptionEngine = engine;
                    break;
                }
            }
            if (transcriptionEngine == null) {
                throw new VeritoneOperationException(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Error.CouldNotFindTranscriptionEngineForLanguage", (Object)this.targetLanguage));
            }
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TranscriptionEngine", new Object[]{transcriptionEngine.getName(), transcriptionEngine.getId()}));
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TranscriptionResultFormat", (Object)this.resultFormat.toLocalizedString()));
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TranscriptionSaveResultAs", (Object)this.saveResultAs.toLocalizedString()));
            try {
                this.textSeparator = this.executionContext.evalParametersIfSet("{veritone_transcription_append_separator}", this);
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            if (this.textSeparator == null) {
                this.textSeparator = "\n---\n";
            } else {
                this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TranscriptionTextCustomAppendSeparator", (Object)this.textSeparator));
            }
            switch (this.saveResultAs) {
                case ITEM_TEXT: {
                    this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.TextModifications", (Object)(this.replaceText ? "Overwrite" : "Append text")));
                    break;
                }
                case CUSTOM_METADATA: {
                    this.customMetadataName = this.executionContext.evalParameters(this.customMetadataName, this);
                    this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.CustomMetadataName", (Object)this.customMetadataName));
                }
            }
            this.scope = this.executionContext.evalParameters(this.scope, this);
            LOGGER.info("Searching Nuix case with scope query: " + this.scope);
            this.addExecutionLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.Log.ScopeQuery", (Object)this.scope));
            Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
            this.addExecutionLog(this.iu.getNumeralString("VeritoneTranscribeItemsOperation.Log.ScopeCount", (long)scopeItems.size()));
            if (scopeItems.isEmpty()) {
                this.addWarning(this.iu.getString("VeritoneTranscribeItemsOperation.Warning.EmptyScopeItems"));
                return;
            }
            this.tempTag = "Automate|System|Run|Veritone|" + String.valueOf(UUID.randomUUID());
            LOGGER.info("Tagging " + scopeItems.size() + " items with tag " + this.tempTag);
            this.executionContext.nuixUtilities.getBulkAnnotater().addTag(this.tempTag, (Collection)scopeItems);
            if (this.stopRequested) {
                return;
            }
            try {
                this.stageId = 0.1;
                this.stageName = this.iu.getString("VeritoneTranscribeItemsOperation.Stage.ExportingItemBinaries");
                this.stageItems = scopeItems.size();
                this.processedItems = new AtomicLong();
                this.jobId = this.executionContext.getEngine().getJobId();
                this.jobFilesDirectory = this.executionContext.getJobFilesDirectory(this.jobId);
                LOGGER.info("Creating job " + this.jobId + " files directory " + String.valueOf(this.jobFilesDirectory.toAbsolutePath()));
                Files.createDirectories(this.jobFilesDirectory, new FileAttribute[0]);
                this.exportItemBinaries(this.jobFilesDirectory.toAbsolutePath().toString(), scopeItems);
                scopeItems.removeAll(this.failedItems);
                if (this.stopRequested) {
                    return;
                }
                this.stageId = 0.4;
                this.stageName = this.iu.getString("VeritoneTranscribeItemsOperation.Stage.RunningVeritoneTranscriptions");
                this.stageItems = scopeItems.size();
                this.processedItems = new AtomicLong();
                String transcriptionEngineId = transcriptionEngine.getId();
                AtomicReference exception = new AtomicReference();
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    LOGGER.info("Starting veritone transcription jobs, with " + this.veritoneService.getParallelJobSubmissions() + " in parallel");
                    ThreadPoolExecutor transcriptionRequestThreadPool = ThreadPoolUtils.createTimeoutThreadPool((String)"VeritoneJobThreadPool", (int)this.veritoneService.getParallelJobSubmissions());
                    ArrayList<Future> translationTaskFutures = new ArrayList<Future>();
                    try {
                        for (Item item : scopeItems) {
                            if (this.stopRequested) {
                                return;
                            }
                            Future<?> taskFuture = transcriptionRequestThreadPool.submit(() -> {
                                ItemTranscriptionJob transcriptionJob = new ItemTranscriptionJob(item);
                                transcriptionJob.setEngineId(transcriptionEngineId);
                                try {
                                    this.transcribeItem(transcriptionJob);
                                    this.transcribedItems.add(item);
                                    this.processedItems.incrementAndGet();
                                    this.clearItemVeritoneMetadata(item, "System|Error");
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error running veritone job " + transcriptionJob.getJobId() + " for item " + item.getGuid(), (Throwable)e);
                                    this.failedItems.add(item);
                                    this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.RunningLog.ErrorRunningVeritoneTranscription", new Object[]{transcriptionJob.getJobId(), item.getGuid(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                                    this.setItemVeritoneMetadata(item, "System|Error", this.iu.getFormattedString("VeritoneTranscribeItemsOperation.ErrorRunningItemTranscription", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                                }
                            });
                            translationTaskFutures.add(taskFuture);
                        }
                        while (!translationTaskFutures.isEmpty()) {
                            if (this.stopRequested) {
                                return;
                            }
                            Thread.sleep((long)this.operationPollingDelay * 1000L);
                            translationTaskFutures.removeIf(Future::isDone);
                        }
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                    finally {
                        try {
                            transcriptionRequestThreadPool.shutdownNow();
                            transcriptionRequestThreadPool.awaitTermination(60L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error shutting down Veritone jobs threadPool", (Throwable)e);
                        }
                    }
                });
                if (this.stopRequested) {
                    return;
                }
                if (exception.get() != null) {
                    throw (Exception)exception.get();
                }
            }
            finally {
                if (this.jobId != null && this.jobFilesDirectory != null) {
                    LOGGER.info("Clearing job " + this.jobId + " files directory " + String.valueOf(this.jobFilesDirectory));
                    try {
                        FileUtils.deleteRecursively((Path)this.jobFilesDirectory);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error deleting jobFilesDirectory " + String.valueOf(this.jobFilesDirectory), (Throwable)e);
                    }
                }
            }
            this.addExecutionLog(this.iu.getNumeralFormattedString("VeritoneTranscribeItemsOperation.Log.TranscribedItems", (long)this.transcribedItems.size(), new Object[0]));
            if (!this.failedItems.isEmpty()) {
                this.addWarning(this.iu.getNumeralString("VeritoneTranscribeItemsOperation.Warning.FailedItems", (long)this.failedItems.size()));
            }
            if (this.stopRequested) {
                return;
            }
            this.stageId = 0.9;
            this.stageName = this.iu.getString("VeritoneTranscribeItemsOperation.Stage.TaggingItems");
            BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
            if (this.tagFailedItems) {
                if (!this.failedItems.isEmpty()) {
                    this.tagItems(bulkAnnotater, this.failedItems, this.failedItemTagName);
                }
                if (this.untagSuccessfulItems) {
                    this.untagItems(bulkAnnotater, this.failedItems, this.failedItemTagName, this.tempTag);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transcribeItem(ItemTranscriptionJob transcriptionJob) throws Exception {
        Item item = transcriptionJob.getItem();
        try {
            CreateJobResponse createJobResponse = this.createVeritoneJob(transcriptionJob);
            String veritoneJobId = (String)createJobResponse.getInternalJobIds().get(0);
            transcriptionJob.setJobId(veritoneJobId);
            this.veritoneRestClient.waitForJob(transcriptionJob, this.operationPollingDelay);
            String transcriptionResult = "";
            String runningLogKey = "";
            List<JobOutput> jobOutputs = this.veritoneRestClient.getJobOutputs(veritoneJobId);
            if (!jobOutputs.isEmpty()) {
                switch (this.resultFormat) {
                    case RAW: {
                        transcriptionResult = this.formatRawOutput(jobOutputs);
                        break;
                    }
                    case TEXT: {
                        transcriptionResult = this.formatTextOutput(jobOutputs);
                        break;
                    }
                    case TIME_STAMPED: {
                        transcriptionResult = this.formatTimestampedOutput(jobOutputs);
                    }
                }
            }
            switch (this.saveResultAs) {
                case ITEM_TEXT: {
                    Object resultingItemText;
                    if (this.replaceText) {
                        resultingItemText = transcriptionResult;
                        runningLogKey = "TranscribedResultReplacedText";
                    } else {
                        String itemText = item.getTextObject().toString();
                        resultingItemText = itemText + "\n" + this.textSeparator + "\n" + transcriptionResult;
                        runningLogKey = "TranscribedResultAppendedText";
                    }
                    item.modify(arg_0 -> VeritoneTranscribeItemsOperationImplementation.lambda$transcribeItem$3((String)resultingItemText, arg_0));
                    break;
                }
                case CUSTOM_METADATA: {
                    item.getCustomMetadata().put((Object)this.customMetadataName, (Object)transcriptionResult);
                    runningLogKey = "TranscribedResultAddedAsCustomMetadata";
                }
            }
            this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.RunningLog." + runningLogKey, (Object)item.getGuid()));
        }
        finally {
            this.veritoneRestClient.cancelJobIfRunning(transcriptionJob);
            Path itemExportDirPath = this.jobFilesDirectory.resolve(transcriptionJob.getFileName()).getParent();
            FileUtils.deleteRecursively((Path)itemExportDirPath);
        }
    }

    private String formatRawOutput(List<JobOutput> jobOutputs) {
        StringBuilder output = new StringBuilder();
        for (JobOutput jobOutput : jobOutputs) {
            if (output.length() > 0) {
                output.append("\n").append(this.textSeparator).append("\n");
            }
            output.append(jobOutput.getContents());
        }
        return output.toString();
    }

    private String formatTextOutput(List<JobOutput> jobOutputs) {
        StringBuilder output = new StringBuilder();
        for (JobOutput jobOutput : jobOutputs) {
            if (output.length() > 0) {
                output.append("\n").append(this.textSeparator).append("\n");
            }
            TranscriptionJobOutputContents outputContents = (TranscriptionJobOutputContents)SerializationUtils.fromJson((String)jobOutput.getContents(), TranscriptionJobOutputContents.class);
            String wordDelimiter = outputContents.getVendor().getLanguageWordDelimiter();
            for (TranscriptionJobOutputContents.Transcription transcription : outputContents.getSeries()) {
                TranscriptionJobOutputContents.WordSettings wordSettings;
                String combinedWords = transcription.getWords().stream().map(TranscriptionJobOutputContents.TranscribedWord::getWord).collect(Collectors.joining(wordDelimiter));
                if (output.length() > 0 && ((wordSettings = transcription.getVendor()) == null || wordSettings.getAttachesTo() != TranscriptionJobOutputContents.WordAttachesTo.PREVIOUS)) {
                    output.append(wordDelimiter);
                }
                output.append(combinedWords);
            }
        }
        return output.toString();
    }

    private String formatTimestampedOutput(List<JobOutput> jobOutputs) {
        ArrayList<Object> outputs = new ArrayList<Object>();
        SimpleDateFormat timestampDateFormat = this.getTimestampDateFormat(jobOutputs);
        for (JobOutput jobOutput : jobOutputs) {
            if (!outputs.isEmpty()) {
                outputs.add("\n" + this.textSeparator + "\n");
            }
            TranscriptionJobOutputContents outputContents = (TranscriptionJobOutputContents)SerializationUtils.fromJson((String)jobOutput.getContents(), TranscriptionJobOutputContents.class);
            String wordDelimiter = outputContents.getVendor().getLanguageWordDelimiter();
            StringBuilder timeframeBuilder = new StringBuilder();
            String lastAppend = null;
            Long prevStopMs = null;
            for (TranscriptionJobOutputContents.Transcription transcription : outputContents.getSeries()) {
                TranscriptionJobOutputContents.WordSettings wordSettings;
                boolean startNewTimeframe;
                Long currentStartMs = transcription.getStartTimeMs();
                boolean bl = startNewTimeframe = prevStopMs == null || currentStartMs - prevStopMs > this.timestampedWordsGroupingMs;
                if (startNewTimeframe && lastAppend != null && !lastAppend.endsWith(".") && endsWithPunctutationPattern.matcher(lastAppend).matches()) {
                    startNewTimeframe = false;
                }
                if (startNewTimeframe) {
                    if (timeframeBuilder.length() > 0) {
                        outputs.add(timeframeBuilder.toString());
                    }
                    timeframeBuilder.setLength(0);
                    timeframeBuilder.append(timestampDateFormat.format(currentStartMs));
                    timeframeBuilder.append(" ");
                }
                String combinedWords = transcription.getWords().stream().map(TranscriptionJobOutputContents.TranscribedWord::getWord).collect(Collectors.joining(wordDelimiter));
                if (timeframeBuilder.length() > 0 && ((wordSettings = transcription.getVendor()) == null || wordSettings.getAttachesTo() != TranscriptionJobOutputContents.WordAttachesTo.PREVIOUS)) {
                    timeframeBuilder.append(wordDelimiter);
                }
                timeframeBuilder.append(combinedWords);
                lastAppend = combinedWords;
                prevStopMs = transcription.getStopTimeMs();
            }
            if (timeframeBuilder.length() <= 0) continue;
            outputs.add(timeframeBuilder.toString());
        }
        return String.join((CharSequence)"\n", outputs);
    }

    private SimpleDateFormat getTimestampDateFormat(List<JobOutput> jobOutputs) {
        TranscriptionJobOutputContents.Transcription lastSeries;
        DateFormat timestampDateFormat = null;
        JobOutput lastOutput = jobOutputs.get(jobOutputs.size() - 1);
        TranscriptionJobOutputContents lastContents = (TranscriptionJobOutputContents)SerializationUtils.fromJson((String)lastOutput.getContents(), TranscriptionJobOutputContents.class);
        if (lastContents != null && lastContents.getSeries() != null && (lastSeries = (TranscriptionJobOutputContents.Transcription)lastContents.getSeries().get(lastContents.getSeries().size() - 1)) != null && lastSeries.getStopTimeMs() < 3600000L) {
            timestampDateFormat = new SimpleDateFormat("[mm:ss.SSS]");
        }
        if (timestampDateFormat == null) {
            timestampDateFormat = new SimpleDateFormat("[HH:mm:ss.SSS]");
        }
        timestampDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return timestampDateFormat;
    }

    private synchronized CreateJobResponse createVeritoneJob(ItemTranscriptionJob transcriptionJob) throws IOException {
        Item item = transcriptionJob.getItem();
        String engineId = transcriptionJob.getEngineId();
        String exportedItemFileName = transcriptionJob.getFileName();
        CreateJobRequest jobRequest = new CreateJobRequest();
        CreateJobRequest.CreateJobDetail job = this.veritoneRestClient.buildTranscriptionJobDetail();
        jobRequest.setJobs(Collections.singletonList(job));
        WebStreamPayload webStreamPayload = new WebStreamPayload();
        webStreamPayload.setChunkSize(Integer.valueOf(1000000));
        webStreamPayload.setUrl(this.veritoneRestClient.createFileDownloadUrl(this.jobId, exportedItemFileName));
        CreateJobRequest.CreateTaskDetail webStreamTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(0);
        webStreamTask.setTaskPayloadJSON(SerializationUtils.toJson((Object)webStreamPayload));
        FfmpegPayload ffmpegPayload = new FfmpegPayload();
        ffmpegPayload.setFfmpegTemplate(FfmpegPayload.FfmpegTemplate.AUDIO);
        FfmpegPayload.CustomFfmpegProperties customFfmpegProperties = new FfmpegPayload.CustomFfmpegProperties();
        customFfmpegProperties.setChunkSizeInSeconds(Integer.valueOf(300));
        ffmpegPayload.setCustomFFMPEGProperties(customFfmpegProperties);
        CreateJobRequest.CreateTaskDetail ffmpegTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(3);
        ffmpegTask.setTaskPayloadJSON(SerializationUtils.toJson((Object)ffmpegPayload));
        CreateJobRequest.CreateTaskDetail transcriptionTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(2);
        transcriptionTask.setEngineId(engineId);
        CreateJobRequest.CreateTaskDetail owTask = (CreateJobRequest.CreateTaskDetail)job.getTasks().get(3);
        owTask.setEngineId(this.veritoneService.getOwEngine().getId());
        CreateJobResponse createJobResponse = this.veritoneRestClient.createJobs(jobRequest);
        String veritoneJobId = (String)createJobResponse.getInternalJobIds().get(0);
        LOGGER.info("Created Veritone job " + veritoneJobId + " for item " + item.getGuid());
        this.addOperationRunningLog(this.iu.getFormattedString("VeritoneTranscribeItemsOperation.RunningLog.StartedVeritoneJobForItem", new Object[]{veritoneJobId, item.getGuid()}));
        return createJobResponse;
    }

    private void exportItemBinaries(String exportFolder, Collection<Item> items) throws Exception {
        BatchExporter batchExporter = this.executionContext.nuixUtilities.createBatchExporter(exportFolder);
        batchExporter.whenItemEventOccurs(this::itemProcessed);
        HashMap<String, String> productOptions = new HashMap<String, String>();
        productOptions.put("naming", "guid");
        batchExporter.addProduct("native", productOptions);
        HashMap<String, Boolean> numberingOptions = new HashMap<String, Boolean>();
        numberingOptions.put("createProductionSet", false);
        batchExporter.setNumberingOptions(numberingOptions);
        ArrayList<String> stageNames = new ArrayList<String>();
        stageNames.add("work_queue");
        stageNames.add("native");
        stageNames.add("stored_email_fixup");
        stageNames.add("numbering");
        stageNames.add("binary_store");
        stageNames.add("file_naming");
        stageNames.add("set_file_times");
        stageNames.add("digest");
        this.stageNameToId = new HashMap<String, Integer>();
        int id = 0;
        for (String stageName : stageNames) {
            this.stageNameToId.put(stageName, id);
            ++id;
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        batchExporter.setParallelProcessingSettings(configurationParser.getParallelProcessingLegalExportSettings());
        NuixWorkerUtils.setWorkerSettings(this.executionContext, this, (ParallelProcessingConfigurable)batchExporter, true);
        this.workerMemory = NuixWorkerUtils.getProcessorWorkerMemory((ParallelProcessingConfigurable)batchExporter);
        this.exportProcessingJob = batchExporter.exportItemsAsync(new ArrayList<Item>(items));
        if (this.exportProcessingJob == null) {
            throw new VeritoneOperationException(this.iu.getString("VeritoneTranscribeItemsOperation.Error.UnexpectedNullExportProcessingJob"));
        }
        String processingJobGuid = this.exportProcessingJob.getJobGuid().replace("-", "");
        LOGGER.info("Job Guid: " + processingJobGuid);
        NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.exportProcessingJob, this.addedWorkerCount);
        NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.exportProcessingJob);
        try {
            long failedExportItemCount = this.exportProcessingJob.getFailedItemCount();
            if (failedExportItemCount > 0L) {
                this.addExecutionLog(this.iu.getNumeralFormattedString("VeritoneTranscribeItemsOperation.Warning.FailedExportItems", failedExportItemCount, new Object[0]));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get job failed items", (Throwable)e);
        }
    }

    private void tagItems(BulkAnnotater bulkAnnotater, Set<Item> items, String tagName) throws IOException {
        LOGGER.info("Tagging " + items.size() + " items with tag " + tagName);
        bulkAnnotater.addTag(tagName, items);
        this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.TaggedItems", (long)items.size(), (Object)tagName));
    }

    private void untagItems(BulkAnnotater bulkAnnotater, Set<Item> itemsToKeep, String tagName, String tempTag) throws IOException {
        String scopeItemsWithTagQuery = NuixUtils.addAndQuery("tag:\"" + tagName + "\"", "tag:\"" + tempTag + "\"");
        LOGGER.info("Searching for items with query: " + scopeItemsWithTagQuery);
        Set scopeItemsWithTag = this.executionContext.nuixCase.searchUnsorted(scopeItemsWithTagQuery);
        Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)scopeItemsWithTag, itemsToKeep);
        if (!itemsToUntag.isEmpty()) {
            LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + tagName);
            bulkAnnotater.removeTag(tagName, (Collection)itemsToUntag);
            this.addExecutionLog(this.iu.getNumeralFormattedString("Operation.Log.UntaggedItems", (long)itemsToUntag.size(), (Object)tagName));
        }
    }

    private void cleanUpTempTag(String tempTag) {
        if (tempTag == null || tempTag.isEmpty()) {
            return;
        }
        try {
            LOGGER.info("Searching for tag:" + tempTag);
            Set taggedItems = this.executionContext.nuixCase.searchUnsorted("tag:\"" + tempTag + "\"");
            if (!taggedItems.isEmpty()) {
                LOGGER.info("Removing tag " + tempTag + " from " + taggedItems.size() + " items");
                this.executionContext.nuixUtilities.getBulkAnnotater().removeTag(tempTag, (Collection)taggedItems);
            }
            LOGGER.info("Deleting tag" + tempTag);
            this.executionContext.nuixCase.deleteTag(tempTag);
        }
        catch (IOException e) {
            LOGGER.error("Cannot delete tag", (Throwable)e);
            this.addWarning("Cannot remove tag " + tempTag + ", " + FormattingUtils.getExceptionPrintableMessage((Exception)e));
        }
    }

    private void setItemVeritoneMetadata(Item item, String name, String value) {
        String effectiveName = "Veritone|" + name;
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        customMetadata.remove((Object)effectiveName);
        customMetadata.put((Object)effectiveName, (Object)value);
    }

    private void clearItemVeritoneMetadata(Item item, String name) {
        String effectiveName = "Veritone|" + name;
        ItemCustomMetadataMap customMetadata = item.getCustomMetadata();
        customMetadata.remove((Object)effectiveName);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.cleanUpTempTag(this.tempTag);
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.exportProcessingJob != null) {
            return this.exportProcessingJob.getJobGuid();
        }
        return null;
    }

    @Override
    public synchronized void updateState() {
        if (this.exportProcessingJob != null) {
            if (!this.isPaused && this.exportProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.exportProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.exportProcessingJob.hasFinished() && this.executionState == ExecutionState.STOPPING) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        if (this.exportProcessingJob != null && !this.exportProcessingJob.hasFinished()) {
            Thread thread = new Thread(() -> {
                while (this.executionState == ExecutionState.STOPPING) {
                    try {
                        LOGGER.info("Sending stop command while job is in state " + this.exportProcessingJob.getCurrentStage());
                        this.exportProcessingJob.stop();
                    }
                    catch (LicenceException e) {
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot stop job");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
            thread.start();
        }
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete;
        if (this.stageId == 0.1 && this.exportProcessingJob != null && this.stageNameToId != null) {
            int stageCount = this.stageNameToId.size();
            int currentStage = 0;
            String exportStage = this.exportProcessingJob.getCurrentStage();
            if (exportStage != null && this.stageNameToId.containsKey(exportStage.toLowerCase())) {
                currentStage = this.stageNameToId.get(exportStage.toLowerCase());
            }
            long itemsCount = this.exportProcessingJob.getTotalItemCount();
            long itemsExported = this.exportProcessingJob.getCurrentStageExportedItemsCount();
            double stageExportPercentageComplete = (double)itemsExported / (double)itemsCount;
            double stageIdPercentageComplete = (stageExportPercentageComplete + (double)currentStage) / (double)stageCount;
            percentageComplete = Math.min(Math.max(stageIdPercentageComplete, 0.0), 0.4);
        } else {
            percentageComplete = this.getProcessedItemsPercentageComplete(0.4, 0.5);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            if (this.stageId == 0.1 && this.exportProcessingJob != null) {
                result = (String)result + this.iu.getNumeralString("VeritoneTranscribeItemsOperation.Progress.ItemsProcessed", this.exportProcessingJob.getCurrentStageExportedItemsCount());
            } else if (this.stageId == 0.4) {
                result = (String)result + this.iu.getNumeralString("VeritoneTranscribeItemsOperation.Progress.ItemsProcessed", this.processedItems.get());
            }
        }
        return result;
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.VERITONE_TRANSCRIBE_ITEMS;
    }

    public void itemProcessed(ItemEventInfo itemEventInfo) {
        Item processedItem = itemEventInfo.getItem();
        String mimeType = "unknown";
        String pathName = "N/A";
        if (processedItem != null) {
            pathName = String.join((CharSequence)"/", processedItem.getPathNames());
            mimeType = processedItem.getType().getName();
        }
        String stage = itemEventInfo.getStage() == null ? "exported" : itemEventInfo.getStage();
        String translatedStage = this.iu.getString("MimeType.Stage." + stage);
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.ExportedStage", new Object[]{translatedStage, pathName}));
        this.trackItemProcessedFailed(mimeType, stage, itemEventInfo.getFailure() != null);
        if (itemEventInfo.getFailure() != null) {
            this.failedItems.add(itemEventInfo.getItem());
        }
    }

    @Override
    public Integer getWorkerMemory() {
        if (this.executionContext.workflowBrokerWorkersCount <= 0) {
            return null;
        }
        return this.workerMemory;
    }

    @Override
    public Integer getAddedWorkerCount() {
        if (this.addedWorkerCount == null) {
            return 0;
        }
        return this.addedWorkerCount.get();
    }

    private static /* synthetic */ void lambda$transcribeItem$3(String resultingItemText, ItemModifier itemModifier) {
        itemModifier.replaceText(resultingItemText);
    }

    private static class ItemTranscriptionJob
    extends ItemVeritoneJob {
        public ItemTranscriptionJob(Item item) {
            super(item);
        }

        @Override
        public String getFileName() {
            String itemExportDir = this.item.getGuid().substring(0, 3);
            String itemFileName = this.item.getGuid() + "." + this.item.getCorrectedExtension();
            return Paths.get(itemExportDir, itemFileName).toString();
        }
    }
}

