/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.WordListExportOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.Item;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class WordListExportOperationImplementation
extends WordListExportOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WordListExportOperation.class);
    private transient long itemsInScope;
    private transient AtomicInteger itemsProcessed = new AtomicInteger();
    private transient AtomicInteger itemsWithErrors = new AtomicInteger();
    private transient int stageId;
    private transient int stageCount;
    private transient String stageName;
    private transient String itemType;

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exportLocation = this.executionContext.evalParameters(this.exportLocation, this);
        this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        this.itemsProcessed = new AtomicInteger(0);
        this.splitRegex = this.executionContext.evalParameters(this.splitRegex, this);
        Pattern pattern = Pattern.compile(this.splitRegex);
        this.stageCount = 2;
        this.stageId = 0;
        this.startTriggerThread = new Thread(() -> {
            try {
                Set items = null;
                try {
                    this.executionContext.closeAllTabs();
                    this.itemType = this.iu.getString("WordListExportOperation.Property.ItemTypeItem");
                    this.stageName = this.iu.getString("WordListExportOperation.Stage.SearchingForItems");
                    LOGGER.info("Searching for " + NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
                    this.addExecutionLog(this.iu.getFormattedString("WordListExportOperation.Log.ScopeQuery", (Object)this.scope));
                    items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                    this.itemsInScope = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("WordListExportOperation.Log.ScopeCount", this.itemsInScope));
                    this.addExecutionLog(this.iu.getFormattedString("WordListExportOperation.Log.SplitRegex", (Object)this.splitRegex));
                    this.addExecutionLog(this.iu.getNumeralString("WordListExportOperation.Log.MinWordLength", (long)this.minLength));
                    this.addExecutionLog(this.iu.getNumeralString("WordListExportOperation.Log.MaxWordLength", (long)this.maxLength));
                }
                catch (IOException e) {
                    LOGGER.error("Error searching scope items: " + this.scope, (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                this.stageName = this.iu.getString("WordListExportOperation.Stage.ExtractingWordText");
                Set wordsSet = Collections.newSetFromMap(new ConcurrentHashMap());
                Set failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    while (iterator.hasNext()) {
                        Item item = (Item)iterator.next();
                        try {
                            String[] words;
                            for (String word : words = pattern.split((CharSequence)item.getTextObject())) {
                                if (word.length() < this.minLength || word.length() > this.maxLength) continue;
                                wordsSet.add(word);
                            }
                        }
                        catch (Exception e) {
                            failedItems.add(item);
                        }
                        this.itemsProcessed.incrementAndGet();
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
                if (failedItems.size() > 0) {
                    this.addWarning(this.iu.getNumeralString("WordListExportOperation.Warning.FailedExtractingWords", (long)failedItems.size()));
                }
                if (this.tagFailedItems.booleanValue() && failedItems.size() > 0) {
                    LOGGER.info("Tagging " + failedItems.size() + " items with tag " + this.failedItemTagName);
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    bulkAnnotater.addTag(this.failedItemTagName, failedItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("WordListExportOperation.Log.FailedItemTag", (long)failedItems.size(), (Object)this.iu.getString("WordListExportOperation.Log.FailedItemTagName")));
                }
                this.addExecutionLog(this.iu.getNumeralString("WordListExportOperation.Log.ExportCount", (long)wordsSet.size()));
                ++this.stageId;
                this.stageName = this.iu.getString("WordListExportOperation.Stage.SortingWords");
                this.itemsProcessed.set(0);
                TreeSet sortedSet = new TreeSet(wordsSet);
                this.itemsInScope = wordsSet.size();
                this.stageName = this.iu.getString("WordListExportOperation.Stage.WritingToFile");
                this.itemType = this.iu.getString("WordListExportOperation.Property.ItemTypeWord");
                this.addExecutionLog(this.iu.getFormattedString("WordListExportOperation.Log.ExportLocation", (Object)this.exportLocation));
                File file = new File(this.exportLocation);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(this.exportLocation, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
                for (String word : sortedSet) {
                    writer.write(word);
                    writer.write("\r\n");
                    this.itemsProcessed.incrementAndGet();
                }
                ((Writer)writer).close();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_word_list_export_file}", this.exportLocation)));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.exportLocation).getParentFile().getAbsolutePath())));
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.itemsProcessed != null) {
            stageProgress = (double)this.itemsProcessed.get() / (double)this.itemsInScope;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.itemsProcessed != null && this.itemsProcessed.get() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = this.itemType.equals(this.iu.getString("WordListExportOperation.Property.ItemTypeItem")) ? (String)result + this.iu.getNumeralFormattedString("WordListExportOperation.Progress.ItemsProcessed", (long)this.itemsProcessed.get(), (Object)this.itemType) : (String)result + this.iu.getNumeralFormattedString("WordListExportOperation.Progress.WordsProcessed", (long)this.itemsProcessed.get(), (Object)this.itemType);
        }
        return result;
    }
}

