/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.addevidence;

import com.nuix.automate.utils.general.LocalizableEnumUtils;
import java.util.Arrays;
import java.util.HashSet;

public enum SourceScope {
    PATH_ITEM,
    PATH_CONTENTS,
    PATH_CONTENTS_AS_SEPARATE_EVIDENCE,
    EVIDENCE_LISTING,
    DATASET,
    LOADFILE,
    GOOGLE_VAULT_EXPORT,
    MICROSOFT_GRAPH,
    SHAREPOINT,
    EXCHANGE,
    ENTERPRISE_VAULT,
    S3,
    SQL_SERVER,
    ORACLE,
    DOCUMENTUM,
    DROPBOX,
    SLACK,
    SSH,
    HISTORICAL_TWITTER;


    public String toString() {
        return LocalizableEnumUtils.getLocalizedString((Enum)this);
    }

    public static boolean isSourceDirectory(SourceScope scope) {
        return scope != null && new HashSet<SourceScope>(Arrays.asList(PATH_CONTENTS, PATH_CONTENTS_AS_SEPARATE_EVIDENCE, GOOGLE_VAULT_EXPORT)).contains((Object)scope);
    }

    public static boolean isNetworkScope(SourceScope scope) {
        return scope != null && new HashSet<SourceScope>(Arrays.asList(S3, MICROSOFT_GRAPH, SHAREPOINT, EXCHANGE, ENTERPRISE_VAULT, DOCUMENTUM, SQL_SERVER, ORACLE, DROPBOX, SSH, HISTORICAL_TWITTER, SLACK)).contains((Object)scope);
    }

    public static boolean usesSourcePath(SourceScope scope) {
        return scope != null && new HashSet<SourceScope>(Arrays.asList(PATH_ITEM, PATH_CONTENTS, PATH_CONTENTS_AS_SEPARATE_EVIDENCE, EVIDENCE_LISTING, GOOGLE_VAULT_EXPORT, LOADFILE)).contains((Object)scope);
    }

    public static boolean usesEvidenceName(SourceScope scope) {
        return scope != null && new HashSet<SourceScope>(Arrays.asList(PATH_ITEM, PATH_CONTENTS, SHAREPOINT, EXCHANGE, ENTERPRISE_VAULT, S3, SQL_SERVER, ORACLE, DOCUMENTUM, DROPBOX, SSH, HISTORICAL_TWITTER, MICROSOFT_GRAPH, SLACK, LOADFILE)).contains((Object)scope);
    }
}

