/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain;

import com.nuix.automate.utils.general.ReflectionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.genaichain.Chain;
import com.nuix.automate.workflow.core.execution.options.genaichain.ChainOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.ChainTrace;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepInput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepTrace;
import com.nuix.automate.workflow.core.execution.options.genaichain.step.ChainStep;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nuix.Item;
import org.apache.commons.lang3.NotImplementedException;

public class ChainExecutor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScriptOperationImplementation.class);
    private Map<String, Class<?>> stepsImplementations;
    private static ChainExecutor instance;

    public static synchronized ChainExecutor getInstance() {
        if (instance == null) {
            instance = new ChainExecutor();
        }
        return instance;
    }

    private ChainExecutor() {
        this.findImplementations();
    }

    public ChainOutput execute(StepInput stepInput, Chain chain, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        ChainTrace chainTrace = new ChainTrace(item.getGuid(), new ArrayList<StepTrace>());
        StepOutput lastStepOutput = null;
        for (ChainStep step : chain.getSteps()) {
            lastStepOutput = this.executeStep(step, stepInput, item, genAiChainOperation);
            chainTrace.getStepsTraces().add(lastStepOutput.getTrace());
            if (lastStepOutput.getOutput() == null) break;
            stepInput.getPreviousOutputs().add(lastStepOutput.getOutput());
        }
        ChainOutput chainOutput = new ChainOutput();
        if (lastStepOutput != null && lastStepOutput.getOutput() != null) {
            chainOutput.setOutput(lastStepOutput.getOutput());
        }
        chainOutput.setChainTrace(chainTrace);
        return chainOutput;
    }

    public StepOutput executeStep(ChainStep step, StepInput stepInput, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        List<String> previousOutputs;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long startCpuTimeMs = threadMXBean.getCurrentThreadCpuTime() / 1000000L;
        long startMs = System.currentTimeMillis();
        ChainStep implementationStep = this.getImplementation(step);
        StepOutput stepOutput = implementationStep.execute(stepInput, item, genAiChainOperation);
        String output = stepOutput.getOutput();
        StepTrace stepTrace = stepOutput.getTrace();
        if (stepTrace == null) {
            stepTrace = new StepTrace();
        }
        stepTrace.setOutput(output);
        if (output != null) {
            stepTrace.setOutputLength(output.length());
        }
        if ((previousOutputs = stepInput.getPreviousOutputs()) == null || previousOutputs.size() > 0) {
            // empty if block
        }
        stepTrace.setDescription(step.getDescription());
        long endMs = System.currentTimeMillis();
        long endCpuTimeMs = threadMXBean.getCurrentThreadCpuTime() / 1000000L;
        stepTrace.setStartEpoch(startMs);
        stepTrace.setDurationMs(endMs - startMs);
        stepTrace.setCpuTimeMs(endCpuTimeMs - startCpuTimeMs);
        stepTrace.setStepType(step.getClass().getSimpleName());
        ChainStep traceStep = this.getTraceStep(step);
        stepTrace.setSettings(SerializationUtils.gsonWithoutNulls.toJson((Object)traceStep));
        return stepOutput;
    }

    public ChainOutput execute(Chain chain, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        LOGGER.info("Executing chain for item " + item.getGuid());
        StepInput stepInput = new StepInput();
        stepInput.setPreviousOutputs(new ArrayList<String>());
        return this.execute(stepInput, chain, item, genAiChainOperation);
    }

    private void findImplementations() {
        this.stepsImplementations = new HashMap();
        String implementationPackage = "com.nuix.automate.workflow.core.execution.options.genaichain.implementation";
        List classes = null;
        try {
            classes = ReflectionUtils.getClassesForPackage((String)implementationPackage, ChainStep.class);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String data = "control_text=previous_outputs[0];\ndata_text=previous_outputs[1];\nprompt='You are an auditor and are auditing a company for compliance with a specific control from a standard.\\n\\nThe context of the standard is provided in the xml tag context:\\n\\n<context>\\n'+context_text+'\\n</context>\\n\\nThe specific control to which compliance is assessed in provided in the xml tag control:\\n<control>\\n'+control_text+'\\n</control>\\n\nYou the review the following snippet of company data, in data xml tag\\n<data>\\n'+data_text+'\\n</data>\\n\\nAnalyze if the snippet of company data provided clearly indicates that there is a reasonable probability that the company is in non-compliance with the standard. \\n\\nDon't assess against other controls or standards. \\n\\nOnly report on areas where the is a clear indication that the control is breached.\n\nIf there isn't evidence indicating that certain required actions are taken, don't assume this is not done, as this information might exist and might be documented elsewhere. \\n\\nOnly respond with the probability of non-compliance, 'low', 'medium' or 'high', nothing else.'\\nresult=prompt";
        for (Class clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            String name = clazz.getSuperclass().getName();
            if (this.stepsImplementations.containsKey(name)) {
                LOGGER.warn("Multiple implementations for step " + name);
            }
            this.stepsImplementations.put(name, clazz);
            this.stepsImplementations.put(clazz.getName(), clazz);
        }
    }

    public ChainStep getImplementation(ChainStep step) {
        Class<?> implementationClass = this.stepsImplementations.get(step.getClass().getName());
        if (implementationClass == null) {
            throw new NotImplementedException("No implementation found for step " + step.getClass().getName());
        }
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        xstream.ignoreUnknownElements();
        xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.workflow.core.execution.options.genaichain.**"});
        String xmlText = xstream.toXML((Object)step);
        xmlText = xmlText.replace(step.getClass().getName(), implementationClass.getName());
        Object operationImplementation = xstream.fromXML(xmlText);
        return (ChainStep)operationImplementation;
    }

    public ChainStep getTraceStep(ChainStep step) {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        xstream.ignoreUnknownElements();
        xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.workflow.core.execution.options.genaichain.**"});
        String xmlText = xstream.toXML((Object)step);
        ChainStep traceStep = (ChainStep)xstream.fromXML(xmlText);
        traceStep.simplifyForTrace();
        return traceStep;
    }
}

