/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain.implementation;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperationImplementation;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepInput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepTrace;
import com.nuix.automate.workflow.core.execution.options.genaichain.step.LlmPromptStep;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiHelper;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import nuix.Item;

public class LlmPromptStepImplementation
extends LlmPromptStep {
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    @Override
    public StepOutput execute(StepInput input, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        GenAiHelper genAiHelper;
        StepOutput stepOutput = new StepOutput();
        StepTrace trace = new StepTrace();
        stepOutput.setTrace(trace);
        ArrayList<CallSite> logLines = new ArrayList<CallSite>();
        try {
            genAiHelper = new GenAiHelper(genAiChainOperation.getExecutionContext(), genAiChainOperation, genAiChainOperation.getThirdPartyServices());
        }
        catch (ParameterException | GenAiException e) {
            throw new IllegalStateException(e);
        }
        GenAiService genAiService = genAiHelper.getGenAiService();
        String model = genAiService.getModel();
        String printableService = genAiHelper.getPrintableServiceName();
        trace.setService(printableService);
        trace.setModel(model);
        ArrayList<String> printablePromptLines = new ArrayList<String>();
        String id = UUID.randomUUID().toString();
        ArrayList<GenAiMessage> messages = new ArrayList<GenAiMessage>();
        if (Boolean.TRUE.equals(this.preservePreviousContext) && input.getPreviousLlmMessages() != null) {
            messages.addAll(input.getPreviousLlmMessages());
            if (!input.getPreviousLlmMessages().isEmpty()) {
                logLines.add((CallSite)((Object)("Included previous messages: " + String.valueOf(input.getPreviousLlmMessages()) + "\n")));
            }
        }
        if (input.getPreviousLlmMessages() == null) {
            input.setPreviousLlmMessages(new ArrayList<GenAiMessage>());
        }
        ArrayList<String> previousOutputs = new ArrayList<String>(input.getPreviousOutputs());
        Collections.reverse(previousOutputs);
        if (this.systemPrompt != null) {
            String effectiveSystemPrompt = null;
            effectiveSystemPrompt = this.evaluateParameter(this.systemPrompt, input, genAiChainOperation);
            GenAiMessage systemMessage = new GenAiMessage("system", effectiveSystemPrompt);
            input.getPreviousLlmMessages().add(systemMessage);
            printablePromptLines.add(systemMessage.toString());
            messages.add(systemMessage);
        }
        if (this.userPrompt != null) {
            String effectiveUserPrompt = null;
            effectiveUserPrompt = this.evaluateParameter(this.userPrompt, input, genAiChainOperation);
            GenAiMessage userMessage = new GenAiMessage("user", effectiveUserPrompt);
            input.getPreviousLlmMessages().add(userMessage);
            printablePromptLines.add(userMessage.toString());
            messages.add(userMessage);
        }
        trace.setPrompt(String.join((CharSequence)"\n\n", printablePromptLines));
        GenAiRequest request = new GenAiRequest(id, messages);
        try {
            GenAiResponse completions = genAiHelper.getCompletions(request);
            stepOutput.setOutput(completions.getMessage().getContent());
            input.getPreviousLlmMessages().add(completions.getMessage());
            trace.setPromptTokens(completions.getUsage().getPromptTokens());
            trace.setResponseTokens(completions.getUsage().getCompletionTokens());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!logLines.isEmpty()) {
            trace.setLog(String.join((CharSequence)"\n", logLines));
        }
        return stepOutput;
    }

    public void setIu(InternationalizationUtils iu) {
        this.iu = iu;
    }

    public InternationalizationUtils getIu() {
        return this.iu;
    }
}

