/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.genaichain.implementation;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperationImplementation;
import com.nuix.automate.workflow.core.execution.operations.ScriptParameters;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepInput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepOutput;
import com.nuix.automate.workflow.core.execution.options.genaichain.StepTrace;
import com.nuix.automate.workflow.core.execution.options.genaichain.step.ScriptStep;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.LineOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import nuix.Item;

public class ScriptStepImplementation
extends ScriptStep {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScriptStep.class);

    @Override
    public StepOutput execute(StepInput input, Item item, GenAiChainOperationImplementation genAiChainOperation) {
        ArrayList<Object> previousOutputs;
        ScriptEngine scriptEngine;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        StepOutput stepOutput = new StepOutput();
        StepTrace trace = new StepTrace();
        stepOutput.setTrace(trace);
        switch (this.scriptType) {
            case PYTHON: {
                scriptEngine = scriptEngineManager.getEngineByName("python");
                break;
            }
            case ECMA_SCRIPT: {
                scriptEngine = scriptEngineManager.getEngineByName("ECMAScript");
                break;
            }
            case RUBY: {
                scriptEngine = scriptEngineManager.getEngineByName("ruby");
                break;
            }
            default: {
                trace.setLog("ERROR: Unsupported script type: " + String.valueOf((Object)this.scriptType));
                return stepOutput;
            }
        }
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        StringBuffer scriptOutput = new StringBuffer();
        ExecutionContext executionContext = genAiChainOperation.getExecutionContext();
        simpleScriptContext.setAttribute("AUTOMATE_VERSION", executionContext.getVersion(), 100);
        if (executionContext.nuixVersion != null) {
            simpleScriptContext.setAttribute("NUIX_VERSION", executionContext.nuixVersion.toString(), 100);
        }
        Set<String> executionStateDynamicParameterNames = executionContext.getExecutionStateDynamicParameterNames();
        for (String placeholder : executionContext.getParameterNames()) {
            if (executionStateDynamicParameterNames.contains(placeholder)) continue;
            try {
                String variableName;
                String unpackedPlaceholder = executionContext.evalParameters(placeholder, genAiChainOperation, true);
                if (placeholder.equals(unpackedPlaceholder) || (variableName = placeholder.substring(1, placeholder.length() - 1)).isEmpty()) continue;
                simpleScriptContext.setAttribute(variableName, unpackedPlaceholder, 100);
                simpleScriptContext.setAttribute("$" + variableName, unpackedPlaceholder, 100);
                try {
                    String displayValue = executionContext.evalParameterUserPrintableValue(placeholder);
                    simpleScriptContext.setAttribute(variableName + "_userprintable", displayValue, 100);
                    simpleScriptContext.setAttribute("$" + variableName + "_userprintable", displayValue, 100);
                }
                catch (ParameterException displayValue) {
                }
            }
            catch (ParameterNotDefinedException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cannot evaluate parameter " + placeholder, (Throwable)e);
            }
            catch (ParameterException e) {
                if (e.getCause() != null && e.getCause().getClass().getName().equals("nuix.LicenceException")) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot evaluate parameter " + placeholder, (Throwable)e);
                    continue;
                }
                LOGGER.warn("Cannot evaluate parameter " + placeholder, (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot set parameter " + placeholder, (Throwable)e);
            }
        }
        ScriptParameters scriptParameters = new ScriptParameters(executionContext, genAiChainOperation);
        simpleScriptContext.setAttribute("parameters", scriptParameters, 100);
        String lastOutput = null;
        if (input.getPreviousOutputs() != null && !input.getPreviousOutputs().isEmpty()) {
            lastOutput = input.getPreviousOutputs().get(input.getPreviousOutputs().size() - 1);
        }
        if (input.getPreviousOutputs() != null) {
            previousOutputs = new ArrayList<String>(input.getPreviousOutputs());
            Collections.reverse(previousOutputs);
        } else {
            previousOutputs = new ArrayList();
        }
        simpleScriptContext.setAttribute("last_output", lastOutput, 100);
        for (int i = 0; i < Math.min(9, previousOutputs.size()); ++i) {
            simpleScriptContext.setAttribute("previous_output_" + i, previousOutputs.get(i), 100);
        }
        simpleScriptContext.setAttribute("previous_outputs", previousOutputs, 100);
        simpleScriptContext.setAttribute("previous_llm_messages", input.getPreviousLlmMessages(), 100);
        LineOutputStream lineOutputStream = new LineOutputStream();
        lineOutputStream.addListener(line -> scriptOutput.append(line).append("\n"));
        simpleScriptContext.setWriter(new PrintWriter(lineOutputStream, true));
        LineOutputStream lineErrorOutputStream = new LineOutputStream();
        lineErrorOutputStream.addListener(line -> scriptOutput.append("ERROR: ").append(line).append("\n"));
        simpleScriptContext.setErrorWriter(new PrintWriter(lineErrorOutputStream, true));
        try {
            Object scriptResult = scriptEngine.eval(this.scriptCode, (ScriptContext)simpleScriptContext);
            if (scriptResult == null) {
                scriptResult = simpleScriptContext.getAttribute("result", 100);
            }
            if (scriptResult != null) {
                stepOutput.setOutput(String.valueOf(scriptResult));
            }
        }
        catch (ScriptException e) {
            trace.setExceptionStackTrace(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (scriptOutput.length() > 0) {
            trace.setLog(scriptOutput.toString());
        }
        return stepOutput;
    }
}

