/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.relativity.restv1;

import com.fasterxml.jackson.annotation.JsonValue;

public enum BooleanConditionOperator {
    AND("And"),
    OR("Or"),
    NONE("None");

    String relativityName;

    private BooleanConditionOperator(String relativityName) {
        this.relativityName = relativityName;
    }

    public static BooleanConditionOperator fromRelativityName(String givenRelativityName) {
        for (BooleanConditionOperator type : BooleanConditionOperator.values()) {
            if (!type.relativityName.equals(givenRelativityName)) continue;
            return type;
        }
        return null;
    }

    @JsonValue
    public String getJsonValue() {
        return this.relativityName;
    }

    public String getRelativityName() {
        if (this == NONE) {
            return "";
        }
        return this.relativityName;
    }

    public String getOperator() {
        if (this == NONE) {
            return "";
        }
        return this.relativityName.toLowerCase();
    }
}

