/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.relativity.restv1;

import com.google.gson.annotations.SerializedName;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityLoginProfileMethod;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityLoginProfilePasswordSettings;
import java.io.Serializable;
import java.util.List;

public class RelativityLoginProfile
implements Serializable {
    @SerializedName(value="UserID")
    private Long userID;
    @SerializedName(value="Password")
    private RelativityLoginProfilePasswordSettings passwordSettings;
    @SerializedName(value="IntegratedAuthentication")
    private RelativityLoginProfileMethod integratedAuthentication;
    @SerializedName(value="ActiveDirectory")
    private RelativityLoginProfileMethod activeDirectory;
    @SerializedName(value="RSA")
    private RelativityLoginProfileMethod rsa;
    @SerializedName(value="ClientCertificate")
    private RelativityLoginProfileMethod clientCertificate;
    @SerializedName(value="OpenIDConnectMethods")
    private List<RelativityLoginProfileMethod> openIDConnectMethods = null;
    @SerializedName(value="SAML2Methods")
    private List<RelativityLoginProfileMethod> sAML2Methods = null;

    public RelativityLoginProfile() {
    }

    public RelativityLoginProfile(RelativityLoginProfile profile, Long userArtifactId, String email, String subject) {
        this.userID = userArtifactId;
        this.passwordSettings = profile.passwordSettings;
        if (this.passwordSettings != null) {
            this.passwordSettings.updateUniqueFields(email);
        }
        this.integratedAuthentication = profile.integratedAuthentication;
        if (this.integratedAuthentication != null) {
            this.integratedAuthentication.setAccount(subject);
        }
        this.activeDirectory = profile.activeDirectory;
        if (this.activeDirectory != null) {
            this.activeDirectory.setAccount(subject);
        }
        this.rsa = profile.rsa;
        if (this.rsa != null) {
            this.rsa.setSubject(subject);
        }
        this.clientCertificate = profile.clientCertificate;
        if (this.clientCertificate != null) {
            this.clientCertificate.setSubject(subject);
        }
        this.openIDConnectMethods = profile.openIDConnectMethods;
        if (this.openIDConnectMethods != null) {
            for (RelativityLoginProfileMethod method : this.openIDConnectMethods) {
                method.setSubject(subject);
            }
        }
        this.sAML2Methods = profile.sAML2Methods;
        if (this.sAML2Methods != null) {
            for (RelativityLoginProfileMethod method : this.sAML2Methods) {
                method.setSubject(subject);
            }
        }
    }

    public Long getUserID() {
        return this.userID;
    }

    public void setUserID(Long userID) {
        this.userID = userID;
    }

    public RelativityLoginProfilePasswordSettings getPassword() {
        return this.passwordSettings;
    }

    public void setPassword(RelativityLoginProfilePasswordSettings password) {
        this.passwordSettings = password;
    }

    public List<RelativityLoginProfileMethod> getOpenIDConnectMethods() {
        return this.openIDConnectMethods;
    }

    public void setOpenIDConnectMethods(List<RelativityLoginProfileMethod> openIDConnectMethods) {
        this.openIDConnectMethods = openIDConnectMethods;
    }

    public List<RelativityLoginProfileMethod> getSAML2Methods() {
        return this.sAML2Methods;
    }

    public void setSAML2Methods(List<RelativityLoginProfileMethod> sAML2Methods) {
        this.sAML2Methods = sAML2Methods;
    }

    public RelativityLoginProfileMethod getIntegratedAuthentication() {
        return this.integratedAuthentication;
    }

    public void setIntegratedAuthentication(RelativityLoginProfileMethod integratedAuthentication) {
        this.integratedAuthentication = integratedAuthentication;
    }

    public RelativityLoginProfileMethod getActiveDirectory() {
        return this.activeDirectory;
    }

    public void setActiveDirectory(RelativityLoginProfileMethod activeDirectory) {
        this.activeDirectory = activeDirectory;
    }

    public RelativityLoginProfileMethod getRsa() {
        return this.rsa;
    }

    public void setRsa(RelativityLoginProfileMethod rsa) {
        this.rsa = rsa;
    }

    public RelativityLoginProfileMethod getClientCertificate() {
        return this.clientCertificate;
    }

    public void setClientCertificate(RelativityLoginProfileMethod clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public String toString() {
        return "RelativityLoginProfile{\nuserID=" + this.userID + "\npasswordSettings=" + String.valueOf(this.passwordSettings) + "\nintegratedAuthentication=" + String.valueOf(this.integratedAuthentication) + "\nactiveDirectory=" + String.valueOf(this.activeDirectory) + "\nrsa=" + String.valueOf(this.rsa) + "\nclientCertificate=" + String.valueOf(this.clientCertificate) + "\nopenIDConnectMethods=" + String.valueOf(this.openIDConnectMethods) + "\nsAML2Methods=" + String.valueOf(this.sAML2Methods) + "}";
    }
}

