/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.options.relativity.restv1;

import com.google.gson.annotations.SerializedName;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.PossibleScriptValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RelativityScriptParameter
implements Serializable {
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    @SerializedName(value="Name")
    private String name;
    @SerializedName(value="Identifier", alternate={"Id"})
    private String identifier;
    @SerializedName(value="IsRequired")
    private Boolean isRequired;
    @SerializedName(value="Type")
    private String type;
    @SerializedName(value="PossibleValues")
    private List<PossibleScriptValue> possibleValues;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Boolean getRequired() {
        return this.isRequired;
    }

    public void setRequired(Boolean required) {
        this.isRequired = required;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<PossibleScriptValue> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(List<PossibleScriptValue> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public String toDisplayValue() {
        if (this.possibleValues == null || this.possibleValues.size() == 0) {
            return this.iu.getFormattedString("Relativity.Exception.Type", (Object)("'" + this.getType() + "'"));
        }
        ArrayList<String> possibleValuesArray = new ArrayList<String>();
        for (PossibleScriptValue value : this.possibleValues) {
            possibleValuesArray.add(value.toDisplayString());
        }
        return this.iu.getFormattedString("Relativity.Exception.PossibleValues", (Object)String.join((CharSequence)", ", possibleValuesArray));
    }

    public String toString() {
        return "RelativityScriptParameter{name='" + this.name + "', identifier='" + this.identifier + "', isRequired=" + this.isRequired + ", type='" + this.type + "', possibleValues=" + String.valueOf(this.possibleValues) + "}";
    }
}

