/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.parameters;

import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.workflow.core.execution.workflow.DynamicParameter;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import nuix.BatchLoadDetails;
import org.joda.time.ReadableInstant;

public abstract class LastBatchLoadParameter
extends DynamicParameter {
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected ExecutionContext executionContext;

    public LastBatchLoadParameter(String name, String description, ExecutionContext executionContext) {
        super(name, description);
        this.executionContext = executionContext;
    }

    protected BatchLoadDetails getLastBatchLoadDetails() throws ParameterNotDefinedException {
        if (this.executionContext.nuixCase == null) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
        }
        if (this.executionContext.nuixCase.getBatchLoads().size() == 0) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoBatches", (Object)this.getName()));
        }
        BatchLoadDetails lastBatchLoad = null;
        for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
            if (lastBatchLoad != null && !batchLoadDetails.getLoaded().isAfter((ReadableInstant)lastBatchLoad.getLoaded())) continue;
            lastBatchLoad = batchLoadDetails;
        }
        return lastBatchLoad;
    }
}

