/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.parameters;

import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.parameters.LastBatchLoadParameter;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nuix.BatchLoadDetails;
import nuix.Item;
import org.joda.time.ReadableInstant;

public abstract class LastEvidenceParameter
extends LastBatchLoadParameter {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(LastEvidenceParameter.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public LastEvidenceParameter(String name, String description, ExecutionContext executionContext) {
        super(name, description, executionContext);
    }

    public List<Item> getLastEvidenceItems() throws ParameterNotDefinedException {
        ArrayList<BatchLoadDetails> batchesWithRootItems = new ArrayList<BatchLoadDetails>();
        if (this.executionContext.nuixCase == null) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
        }
        try {
            for (Item rootItem : this.executionContext.nuixCase.getRootItems()) {
                try {
                    BatchLoadDetails batchLoadDetails = rootItem.getBatchLoadDetails();
                    batchesWithRootItems.add(batchLoadDetails);
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.warn("Cannot get item " + rootItem.getGuid() + " batchload details");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
        BatchLoadDetails lastBatchLoad = null;
        for (BatchLoadDetails batchLoadDetails : batchesWithRootItems) {
            if (lastBatchLoad != null && !batchLoadDetails.getLoaded().isAfter((ReadableInstant)lastBatchLoad.getLoaded())) continue;
            lastBatchLoad = batchLoadDetails;
        }
        ArrayList<Item> lastEvidenceItems = new ArrayList<Item>();
        if (lastBatchLoad == null) {
            return lastEvidenceItems;
        }
        try {
            for (Item rootItem : this.executionContext.nuixCase.getRootItems()) {
                if (!lastBatchLoad.getItems().contains(rootItem)) continue;
                lastEvidenceItems.add(rootItem);
            }
            return lastEvidenceItems;
        }
        catch (IOException iOException) {
            LOGGER.error("Cannot evaluate parameter " + this.getName(), (Throwable)iOException);
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoRootItems", (Object)this.getName()));
        }
    }
}

