/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.parameters;

import com.nuix.automate.utils.exceptions.ParameterNotDefinedException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.workflow.core.execution.workflow.DynamicParameter;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import nuix.ItemSet;
import nuix.ItemSetBatch;
import org.joda.time.ReadableInstant;

public abstract class LastItemSetParameter
extends DynamicParameter {
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected ExecutionContext executionContext;

    public LastItemSetParameter(String name, String description, ExecutionContext executionContext) {
        super(name, description);
        this.executionContext = executionContext;
    }

    protected ItemSetBatch getLastItemSetBatch() throws ParameterNotDefinedException {
        if (this.executionContext.nuixCase == null) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoCase", (Object)this.getName()));
        }
        ItemSetBatch lastItemSetBatch = null;
        for (ItemSet itemsSet : this.executionContext.nuixCase.getAllItemSets()) {
            for (ItemSetBatch itemSetBatch : itemsSet.getBatches()) {
                if (lastItemSetBatch != null && !itemSetBatch.getCreated().isAfter((ReadableInstant)lastItemSetBatch.getCreated())) continue;
                lastItemSetBatch = itemSetBatch;
            }
        }
        if (lastItemSetBatch == null) {
            throw new ParameterNotDefinedException(this.iu.getFormattedString("Parameters.Log.NoItemSetBatches", (Object)this.getName()));
        }
        return lastItemSetBatch;
    }
}

