/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.callapi.Verb;
import com.nuix.automate.workflow.core.execution.script.ApplicationRestClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericRestClient
extends ApplicationRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenericRestClient.class);
    private final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected String username;
    protected String password;
    private Map<String, String> customHeaders;

    public GenericRestClient(String name) {
        super((LogChannel)new DummyLogChannel(), name);
    }

    public void setBasicAuth(String username, String password) throws ParameterException {
        this.username = username;
        this.password = password;
    }

    public void setHeader(String name, String value) {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, String>();
        }
        this.customHeaders.put(name, value);
    }

    private String getCallUrl(String endpoint) throws IOException {
        if (this.baseUrl == null) {
            return endpoint;
        }
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        Object callUrl = this.baseUrl;
        if (endpoint != null && !endpoint.isEmpty()) {
            callUrl = endpoint.startsWith("/") ? (String)callUrl + endpoint : (String)callUrl + "/" + endpoint;
        }
        return callUrl;
    }

    @Override
    protected Map<String, String> getHeaders(Verb verb, String url, Object body) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.bearerToken != null) {
            headers.put("Authorization", "Bearer " + this.bearerToken);
        } else if (this.username != null) {
            String basicAuthCredentials = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
            headers.put("Authorization", "Basic " + basicAuthCredentials);
        }
        if (this.customHeaders != null) {
            headers.putAll(this.customHeaders);
        }
        return headers;
    }

    public Response get(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.GET, callUrl, "");
    }

    public Response delete(String endpoint) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        return this.callApi(Verb.DELETE, callUrl, "");
    }

    public Response post(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.POST, callUrl, body);
    }

    public Response put(String endpoint, Object data) throws IOException {
        String callUrl = this.getCallUrl(endpoint);
        Object body = this.prepareBody(data);
        return this.callApi(Verb.PUT, callUrl, body);
    }
}

