/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.script;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import java.util.Collection;
import org.joda.time.DateTime;

public class Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Operation.class);
    private final com.nuix.automate.workflow.core.execution.operations.Operation operation;
    private int id;

    public Operation(com.nuix.automate.workflow.core.execution.operations.Operation operation) {
        this.operation = operation;
    }

    public Operation(com.nuix.automate.workflow.core.execution.operations.Operation operation, int id) {
        this(operation);
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public ExecutionState getExecutionState() {
        return this.operation.executionState;
    }

    public String getName() {
        return this.operation.getOperationName();
    }

    public String getNotes() {
        return this.operation.notes;
    }

    public String getErrorMessage() {
        return this.operation.getErrorMessage();
    }

    public Collection<String> getWarningMessages() {
        return this.operation.getWarningMessages();
    }

    public void clearWarningMessages() {
        LOGGER.info("API clearing warning messages");
        this.operation.clearWarningMessages();
    }

    public DateTime getStartDateTime() {
        return this.operation.startDateTime;
    }

    public DateTime getFinishedDateTime() {
        return this.operation.finishedDateTime;
    }

    public boolean getSkippable() {
        return this.operation.skippable;
    }

    public boolean getDisabled() {
        return this.operation.disabled;
    }

    public void setDisabled(boolean disabled) throws Exception {
        LOGGER.info("API setting operation disabled: " + disabled);
        this.operation.getExecutionContext().workflowExecution.updateDisabledOperation(this.id - 1, disabled);
    }

    public boolean getSoftFail() {
        return Boolean.TRUE.equals(this.operation.softFail);
    }

    public void setSoftFail(Boolean softFail) {
        LOGGER.info("API setting operation softFail: " + softFail);
        this.operation.softFail = softFail;
    }

    public boolean getSuppressWarnings() {
        return Boolean.TRUE.equals(this.operation.suppressWarnings);
    }

    public void setSuppressWarnings(Boolean suppressWarnings) {
        LOGGER.info("API setting operation suppressWarnings: " + suppressWarnings);
        this.operation.suppressWarnings = suppressWarnings;
    }

    public boolean getUsesWorkers() {
        return this.operation.getUsesWorkers();
    }

    public DateTime getEta() {
        return this.operation.getEta();
    }

    public double getPercentageComplete() {
        return this.operation.getNormalizedPercentageComplete();
    }

    public void skipOperation() {
        LOGGER.info("API skipping operation");
        this.operation.skip();
    }
}

